begin;
drop table if exists snb_delivery.israel_clients_dash__managers;
create table snb_delivery.israel_clients_dash__managers as
with clients as (
select distinct
  corp_client_id
  ,first_value(corp_client_name) over (partition by corp_client_id) as corp_client_name
from delivery_cdm_b2b.dim_corp_contract
)
,managers as (
select distinct
    *
from snb_delivery.niksm_contract_manager m
where corp_client_id is not null
)
select
  utc_order_created_dt as date
  ,case
    when o.corp_client_id is null then 'NON_CORP_C2C'
    when m.manager_name = 'Bocharnikov Avital' then 'Bocharnikov Avital'
    when l.corp_client_name = 'Yandex.Go Israel' then 'Weinberg Levy Allan Isaac'
    else coalesce(c.manager_name,l.corp_client_name)
  end as manager
  ,corp_client_name
  ,o.corp_client_id as corp_client_id
  ,sum(least(1,delivery_point_cnt)) as trips
  ,sum(delivery_point_cnt) as deliveries
  ,sum(order_cost)/1.17 as gmv
  ,sum(gross_commission_revenue_amt) as commissions
  ,sum(incentives_amt) as subsidies
  ,sum(b2b_decoupling_amt*case when decoupling_flg then 1 else 0 end) as decoupling
  ,sum(net_inflow_amt) as ni
from taxi_cdm_marketplace.fct_order_metric o
  left join clients l
    on l.corp_client_id = o.corp_client_id
  left join managers m
    on m.corp_client_id = o.corp_client_id
  left join snb_delivery.balance_contracts_tmp c --snb_b2b.balance_contracts c
    on c.contract_eid = o.corp_contract_id
    and c.dt <= cast(o.lcl_order_created_dttm as date)
    and cast(o.lcl_order_created_dttm as date) <= coalesce(c.finish_dt,to_date('01/01/3000','dd/mm/yyyy'))
where 0<1
  and success_order_flg
  and tariff_class_code in ('courier','express','night')
  and (country_name_ru = 'Израиль' or tariff_geo_zone_code = 'tel_aviv')
  and utc_order_created_dttm >= to_date('01/01/2022','dd/mm/yyyy')
  and utc_order_created_dttm < current_date::timestamp
group by
  utc_order_created_dt
  ,case
    when o.corp_client_id is null then 'NON_CORP_C2C'
    when m.manager_name = 'Bocharnikov Avital' then 'Bocharnikov Avital'
    when l.corp_client_name = 'Yandex.Go Israel' then 'Weinberg Levy Allan Isaac'
    else coalesce(c.manager_name,l.corp_client_name)
  end
  ,corp_client_name
  ,o.corp_client_id;
commit;

grant select on snb_delivery.israel_clients_dash__managers to public;
commit;
