import pandas as pd
import numpy as np
from business_models import hahn
import logging 
import sys
sheet_id = '1fTQHIzedK0KkMpZr0i3QaApu_ch0kF_aTG-GfFzOQGk'

hahn_table = "//home/taxi-delivery/analytics/dev/ivanterekhov/LOGDATA-2736/raw_money_data"

from projects.common.helpers import build_gdocs

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f"%(asctime)s %(filename)s %(levelname)s: %(message)s")

logging.info("Start")


gdocs = build_gdocs()

sheet_names = gdocs.get_all_sheet_titles(sheet_id)

data = []

yt = hahn.yt

for sheet_name in sheet_names:
    df1 = gdocs.read(
        table_name=sheet_name,  # Название листа в google.sheet
        sheet_id=sheet_id,   # ID google.sheet (берется из ссылки)
        header=1,            # Количество строк-заголовков
    ).to_dict(orient='records')
    
    for el in df1:
        skip_flg = False
        for val in el.values():
            if val is None or val == '':
                skip_flg = True
        if not skip_flg:
            el['country'] = sheet_name
            data.append(el)

yt.write_table(hahn_table, data)


