USE hahn;

PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yt.InferSchema = '1';
PRAGMA yt.Owners = 'ivanterekhov';

$raw_path = "//home/taxi-delivery/analytics/dev/ivanterekhov/LOGDATA-2736/raw_money_data";

$path = "//home/taxi-delivery/analytics/dev/ivanterekhov/LOGDATA-2736/money_data";

$to_date = ($t) -> {return DateTime::MakeDate(DateTime::Parse('%d.%m.%Y')(String::Strip($t)))};

INSERT INTO $path WITH TRUNCATE
SELECT cast(String::ReplaceAll(String::RemoveAll(`GMV (local currency)`, "\u00A0"), ',', '.') as Double) as gmv,
        cast(String::ReplaceAll(String::RemoveAll(`Operations Costs (local currency)`, "\u00A0"), ',', '.') as Double) as ops_cost,
        cast(String::ReplaceAll(String::RemoveAll(`Other Costs (local currency)`, "\u00A0"), ',', '.') as Double) as other_cost,
        cast($to_date(String::SplitToList(`Week`, '-')[0]) as String) as start_of_week,
        cast($to_date(String::SplitToList(`Week`, '-')[1]) as String) as end_of_week,
        `country`
FROM $raw_path;
