use hahn;

-- functions to convert english names of country to russian and currency of country
$country_name_ru = ($country) -> {
    return case
                when $country = 'Turkey' then 'Турция'
                when $country = 'UAE' then 'Объединённые Арабские Эмираты'
                when $country = 'Chile' then 'Чили'
                when $country = 'Peru' then 'Перу'
                when $country = 'Mexico' then 'Мексика'
                when $country = 'Serbia' then 'Сербия'
                else $country
            end
};

$currency_name = ($country) -> {
    return case
                when $country = 'Turkey' then 'TRY'
                when $country = 'UAE' then 'AED'
                when $country = 'Chile' then 'CLP'
                when $country = 'Peru' then 'PEN'
                when $country = 'Mexico' then 'MXN'
                when $country = 'Serbia' then 'RSD'
                else $country
            end
};

-- tables used in query
$money_data_table = '//home/taxi-delivery/analytics/dev/ivanterekhov/LOGDATA-2736/money_data';
$delivery_data_table = '//home/taxi-delivery/analytics/dev/griganton/LOGDATA-1292/summary/delivery';
$currency_data_table = '//home/taxi-dwh/dds/dim_currency_rate';

$wms_value = '//home/taxi-delivery/international/routing_wms/value';


-- we get matched data and flag that row is in interval
$data = (
    select order_id, 
            route_id, 
            del.country as country_name_ru, 
            money.country as country, 
            route_date, 
            start_of_week, 
            end_of_week, 
            gmv, 
            ops_cost + other_cost as cost, 
            if(start_of_week <= route_date and route_date <= end_of_week, 1, 0) as is_fine
    from $delivery_data_table as del
    join 
    $money_data_table as money 
    on del.country = $country_name_ru(money.country)
);

-- stats_calc
$almost_final = (
    select country, 
            country_name_ru, 
            start_of_week as valid_from, 
            end_of_week as valid_to, 
            max(gmv) as gmv, 
            max(cost) as cost, 
            count(distinct order_id) as orders_amt, 
            1.0 * max(gmv) / count(distinct order_id) as gmv_per_order, 
            1.0 * max(cost) / count(distinct order_id) as cost_per_order
    from $data 
    where is_fine = 1
    group by country, country_name_ru, start_of_week, end_of_week
);

-- change end_date to inf
$good_money_data = (
    select almost_final.*, 
            if(almost_final.valid_to = maxval.valid_to, '3000-01-01', almost_final.valid_to) as valid_to
        without almost_final.valid_to
    from 
    $almost_final as almost_final
    join 
    (select country, max(valid_to) as valid_to
    from $almost_final
    group by country) as maxval 
    on almost_final.country = maxval.country
);

-- get currency data suitable for routeq countries
$currency_data = (
    select `date`, `source_cur`, `target_cur`, `rate`
    from $currency_data_table
    where (`target_cur` = 'RUB') 
        and (`source_cur` = 'CLP' 
            or `source_cur` = "TRY" 
            or `source_cur` = 'AED' 
            or `source_cur` = 'PEN'
            or `source_cur` = 'MXN'
            or `source_cur` = 'RSD')
);

INSERT INTO `//home/taxi-delivery/analytics/dev/ivanterekhov/LOGDATA-2736/money_divided` WITH TRUNCATE 
SELECT * 
from $good_money_data;

$final_money_table = ( 
    select d.* 
        without d.is_fine
    from 
    (select order_id, 
            route_id, 
            del.country as country_name_ru, 
            money.country as country, 
            route_date, 
            gmv_per_order as price,
            gmv_per_order * rate as price_rub,
            cost_per_order as cost,
            cost_per_order * rate as cost_rub,
            corp_client_id,
            corp_client_name,
            service_level,
            if(`valid_from` <= route_date and route_date <= `valid_to`, 1, 0) as is_fine
    from $delivery_data_table as del
    join 
    $good_money_data as money 
    on del.country = $country_name_ru(money.country)
    join 
    $currency_data as curdata 
    on $currency_name(money.country) = curdata.source_cur and del.route_date = curdata.date) as d 
    where d.is_fine = 1
);

INSERT INTO $wms_value WITH TRUNCATE 
select *
from
(
    SELECT distinct 
        wms_val.`corp_client_id` as corp_client_id, 
        wms_val.`corp_client_name` as corp_client_name,
        wms_val.`price_lcy` as price_lcy,
        wms_val.`price_rub` as price_rub,
        wms_val.`routing_order_id` as routing_order_id,
        wms_val.`service_level` as service_level,
        approx_val.`cost` as cost_lcy,
        approx_val.`cost_rub` as cost_rub
    from $wms_value  as wms_val
    left join 
    $final_money_table as approx_val
    on wms_val.routing_order_id = approx_val.order_id
    where routing_order_id is not null
)
union all 
(
    select distinct 
        approx_val.`corp_client_id` as corp_client_id, 
        approx_val.`corp_client_name` as corp_client_name,
        approx_val.price as `price_lcy`,
        approx_val.`price_rub` as price_rub,
        cast(approx_val.order_id as Uint64) as `routing_order_id`,
        approx_val.`service_level` as service_level,
        approx_val.`cost` as cost_lcy,
        approx_val.`cost_rub` as cost_rub
    from $final_money_table as approx_val
    left only join 
    $wms_value as wms_val
    on wms_val.routing_order_id = approx_val.order_id
);


