import pandas as pd
import json
from b2b_mailer import main2
import logging
import sys
from projects.common.helpers import build_gdocs

logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f"%(asctime)s %(filename)s %(levelname)s: %(message)s")

logging.info("Start")

# Get emails and corp_ids from google doc

gdocs = build_gdocs()

data = gdocs.read(
    table_name='test1',
    sheet_id='1P1xCuW3VjkRbXtXdPhVigIOBss_REN931kv-AVoPmFs',
    header=1,
).to_dict(orient='records')

logging.info("Data from gdoc: " + str(data))

# Prepare tokens for email sending
key_file = "keys.json"

gp_user = "robot-sam-bridges"

key_key = "sam_gp_token"

with open(key_file, 'r') as f:
    keys = json.load(f)

gp_token = keys[key_key]

# Read extracted data
df_main = pd.read_json("~/data.json")

logging.info(f"Dataframe size: df_main = {len(df_main)}")

# Send emails

for el in data:
    if df_main[df_main["corp_client_id"] == el["id"]].size != 0:
        main2(
            receivers_url=None,
            # add to receivers all people from specific groups at staff
            receivers_ancestors=None,
            # add to receivers people, who have listed groups above theirs
            receivers_logins=None,  # add to receivers people by logins
            exclude_logins=None,
            mail_name='test',  # name of letter
            mail_text='test',  # body of letter
            mail_cc=[el["email"]],  # send a copy to listed emails
            hierarchy=True,
            # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
            emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
            key_file=key_file,  # where the keys are
            key_key=key_key,  # key of gp token in file
            flat=['ivanterekhov'],  #list of emails. mail all rows to these addresses
            user=gp_user,
            sheets=[
                {'query': None,
                'df': df_main[df_main["corp_client_id"] == el["id"]][["external_order_id", "route_id"]],
                'exclude_columns': None,
                'col_names': None,
                'sheet_name': 'data_main'},
            ]
        )

logging.info("Finished")
