from projects.common.helpers import build_gdocs
from datetime import date

cur_date = str(date.today()) + " 00:00:00"

gdocs = build_gdocs()

data = gdocs.read(
    table_name='test1',
    sheet_id='1P1xCuW3VjkRbXtXdPhVigIOBss_REN931kv-AVoPmFs',
    header=1,
).to_dict(orient='records')

ids = [0 for i in range(len(data))]
for i in range(len(data)):
    ids[i] = data[i]["id"]
query = "\
    select\
        distinct\
        external_order_id,\
        waybill_ref,\
        corp_client_id,\
        now() as msk_timestamp\
    from cargo_orders.taxi_cargo_orders_analytics_topic\
    where created_ts >= '" + cur_date + "' and external_order_id is not null\
" + " and corp_client_id in " + str(ids)

print(query)
