use hahn;
pragma OrderedColumns;
$raw = '//home/taxi-delivery/international/routing_wms/orders_raw';
$path = '//home/taxi-delivery/international/routing_wms/orders';


insert into $path with truncate
select
  Yson::ConvertToString(order_id) as order_id
  ,Yson::ConvertToUint64(status) as status
  ,Yson::ConvertToUint64(tariff) as tariff
  ,case
    when Yson::ConvertToBool(is_reverse) = true then 'Reverse'
    when Yson::ConvertToUint64(tariff) = 0 then 'SDD'
    when Yson::ConvertToUint64(tariff) = 1 then 'NDD'
    else null
  end as service_level
  ,Yson::ConvertToBool(is_deleted) as is_deleted
  ,Yson::ConvertToBool(is_received) as is_received
  ,Yson::ConvertToBool(is_redelivery) as is_redelivery
  ,Yson::ConvertToBool(is_reverse) as is_reverse
  ,Yson::ConvertToString(corp_client_id) as corp_client_id
  ,Yson::ConvertToString(external_order_number) as external_order_number
  ,Yson::ConvertToString(created_at) as created_at
  ,substring(Yson::ConvertToString(route_date),0,10) as route_date
  ,Yson::ConvertToString(customer_comment) as customer_comment
  ,Yson::ConvertToString(customer_first_address_line) as customer_first_address_line
  ,Yson::ConvertToString(customer_second_address_line) as customer_second_address_line
  ,Yson::ConvertToString(customer_name) as customer_name
  ,Yson::ConvertToString(customer_phone) as customer_phone
  ,Yson::ConvertToString(delivery_comment) as delivery_comment
  ,Yson::ConvertToString(delivery_order_id) as delivery_order_id
  ,Yson::ConvertToString(delivery_pickup_information) as delivery_pickup_information
  ,Yson::ConvertToUint64(delivery_point_id) as delivery_point_id
  ,Yson::ConvertToString(modified_by_client_at) as modified_by_client_at
  ,Yson::ConvertToString(prefix) as prefix
  ,Yson::ConvertToString(received_at) as received_at
  ,Yson::ConvertToString(route_created_at) as route_created_at
  ,Yson::ConvertToUint64(routing_order_id) as routing_order_id
  ,Yson::ConvertToString(routing_order_number) as routing_order_number
  ,Yson::ConvertToString(routing_task_id) as routing_task_id
  ,Yson::ConvertToUint64(size) as size
  ,Yson::ConvertToString(updated_at) as updated_at
from $raw;
