use hahn;
pragma OrderedColumns;
$path_raw = '//home/taxi-delivery/international/routing_wms/orders_raw';


$wms = (
select
  Yson::SerializeJson(doc) as doc
from `//home/delivery-dwh/raw/routing_wms/orders/orders`
);


insert into $path_raw with truncate
select
  doc.Id as order_id
  ,doc.Status as status
  ,doc.Tariff as tariff
  ,doc.IsDeleted as is_deleted
  ,doc.IsReceived as is_received
  ,doc.IsRedelivery as is_redelivery
  ,doc.IsReverse as is_reverse
  ,doc.ClientId as corp_client_id
  ,doc.ClientOrderNumber as external_order_number
  ,doc.CreatedAt as created_at
  ,doc.RouteDate as route_date
  ,doc.CustomerComment as customer_comment
  ,doc.CustomerFirstAddressLine as customer_first_address_line
  ,doc.CustomerSecondAddressLine as customer_second_address_line
  ,doc.CustomerName as customer_name
  ,doc.CustomerPhone as customer_phone
  ,doc.DeliveryComment as delivery_comment
  ,doc.DeliveryOrderId as delivery_order_id
  ,doc.DeliveryPickupInformation as delivery_pickup_information
  ,doc.DeliveryPointId as delivery_point_id
  ,doc.ModifiedByClientAt as modified_by_client_at
  ,doc.Prefix as prefix
  ,doc.ReceivedAt as received_at
  ,doc.RouteCreatedAt as route_created_at
  ,doc.RoutingOrderId as routing_order_id
  ,doc.RoutingOrderNumber as routing_order_number
  ,doc.RoutingTaskId as routing_task_id
  ,doc.Size as size
  ,doc.UpdatedAt as updated_at
from $wms;
