use hahn;
pragma SimpleColumns;
pragma OrderedColumns;
$path = '//home/taxi-delivery/international/routing_wms/value';
$wms_orders = '//home/taxi-delivery/international/routing_wms/orders';
$wms_clients = '//home/taxi-delivery/international/routing_wms/clients';
-- $wms_clients = '//home/taxi-delivery/international/chile_clients';  --fallback_dict
$corp_pricing = '//home/taxi-delivery/international/chile_corp_tariffs';
$currency = '//home/taxi-dwh/dds/dim_currency_rate';


$default_pricing = (
select
  service_level
  ,price
from $corp_pricing
where corp_client_name = '__default__'
);


$clp_to_rub = (
select
  *
from $currency
where 0<1
  and source_cur = 'CLP'
  and target_cur = 'RUB'
);


insert into $path with truncate
select
  o.routing_order_id as routing_order_id
  ,o.corp_client_id as corp_client_id
  ,c.corp_client_name as corp_client_name
  ,o.service_level as service_level
  ,coalesce(p.price,d.price)*(1-cast(o.is_redelivery as int64))*1.19 as price_lcy -- with VAT
  ,coalesce(p.price*r.rate,d.price*r.rate)*(1-cast(o.is_redelivery as int64))*1.19 as price_rub -- with VAT
from $wms_orders as o
  left join $wms_clients as c
    on c.corp_client_id = o.corp_client_id
  left join $corp_pricing as p
    on p.corp_client_name = c.corp_client_name
    and p.service_level = o.service_level
  left join $default_pricing as d
    on d.service_level = o.service_level
  left join $clp_to_rub as r
    on r.date = o.route_date;
