USE hahn;
use hahn;
PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- Вот тут задаем, с какой даты смотрим
$start_dt = '2021-04-01';

-- Маркет
$delivery_services =
select distinct id
from range('//home/market/production/mstat/dictionaries/delivery_services', '2020-12-01')
-- where `type`='dropship' -- нужно ли это условие??
;

$ondemand_orders =
select distinct
    
    cast(order_id as Utf8) as order_id
    , order_creation_date
    , order_delivered_datetime
from range('//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_item_dict_flattened', substring($start_dt, 0, 7))
where (order_on_demand_delivery_flag = true
    or order_delivery_service_id = 93730)
and order_creation_date >= $start_dt
;

--select * from $ondemand_orders into result ondemad_orders;

$track_data_miles =
select t.order_id as order_id
    , id as track_id
    , delivery_service_id
    , delivery_service_type
    , t.start_ts
    , o.order_creation_date as order_creation_date
    , o.order_delivered_datetime as order_delivered_datetime
    , row_number() over (partition by t.order_id, t.delivery_service_type order by t.start_ts desc) as delivery_segment
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_delivery_track` as t
inner join $ondemand_orders as o on t.order_id = o.order_id
where delivery_service_id in (select id from $delivery_services)
    and t.delivery_service_type = 1
;

--select * from $track_data_miles into result track_data_miles;


$middle_mile = (
SELECT
    order_id
    , order_creation_date
    , delivery_service_id
    , min(checkpoint_ts) as delivered_to_lavka
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_checkpoint` as c
inner join $track_data_miles as t on c.track_id = t.track_id
where 
    (
        raw_status in (45) 
        and checkpoint_ts like '%202%' 
        and delivery_segment = 1
        and order_creation_date > '2020-06-30') 
    or (
        raw_status in (30) 
        and message like '%Заказ доставлен в пункт самовывоза%'
    )
group by 
    t.order_id as order_id
    , t.order_creation_date as order_creation_date
    , t.delivery_service_id as delivery_service_id
    , t.order_delivered_datetime as order_delivered_datetime
)
;

--select * from $middle_mile into result middle_mile 
--;

$last_mile = (
SELECT
    order_id
    , order_creation_date
    , min(checkpoint_ts) as ready_for_delivery_on_lavka
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_checkpoint` as c
inner join $track_data_miles as t on c.track_id = t.track_id
where raw_status in (45) 
    and checkpoint_ts like '%202%' 
    and delivery_segment = 2
group by 
    t.order_id as order_id
    , t.order_creation_date as order_creation_date
    , t.delivery_service_id as delivery_service_id
    , t.order_delivered_datetime as order_delivered_datetime
)
;

$datetime_parse_tz = DateTime::Parse("%Y-%m-%dT%H:%M:%SZ");

-- Часть Лог. платформы

$requests =
select distinct request_id, request_code
from range('//home/taxi/testing/export/taxi-logistic-platform-production/requests_history', $start_dt)
where request_code in (select cast(order_id as String) from $ondemand_orders)
union all 
select distinct request_id, request_code
from range('//home/taxi/testing/export/taxi-logistic-platform-market-production/requests_history', $start_dt)
where request_code in (select cast(order_id as String) from $ondemand_orders)
;

$nodes =
select node_id, request_code as market_order_id, station_id from (
select distinct node_id, request_id
        , Yson::YPathString(unpacked_data, '/node_location/station_location/station_id') as station_id
from range('home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history', $start_dt)
union all 
select distinct node_id,  request_id
        , Yson::YPathString(unpacked_data, '/node_location/station_location/station_id') as station_id
from range('home/taxi/testing/export/taxi-logistic-platform-market-production/planned_nodes_history', $start_dt)
) as a
inner join $requests as b on a.request_id = b.request_id
;

select * from $nodes into result nodes;

$stations =

select station_id
            , max(station_name)  as station_name
            , max(Yson::YPathString(unpacked_data, '/location_details/full_address')) as station_address
            , max(Yson::YPathString(unpacked_data, '/location_details/locality')) as city
from range(`//home/taxi/testing/export/taxi-logistic-platform-production/stations_history`, '2020-12-01')
group by station_id
;

select * from $stations into result stations;

$address =
(
SELECT a.*, b.node_id as node_id, b.market_order_id as market_order_id
from $stations as a
join $nodes as b on a.station_id = b.station_id
);

$accept_time = 
SELECT a.order_id as order_id
    , station_id
    , station_name
    , station_address
    , city
  --  , case when delivery_service_id <> 93730 then 'K2' else 'ЧС' end as delivery_type
    , a.order_creation_date as order_creation_date
--     , order_delivered_datetime
    , delivered_to_lavka
    , ready_for_delivery_on_lavka as accepted_on_lavka
    , case when ready_for_delivery_on_lavka > delivered_to_lavka
    then  1.0 * (DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Update($datetime_parse_tz(ready_for_delivery_on_lavka))))
    -
    DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Update($datetime_parse_tz(delivered_to_lavka)))))
    / 3600
    else 0
    end as time_delta_normal_hour
from $middle_mile as a
left join $last_mile as b on a.order_id = b.order_id
left join $address as c on cast(a.order_id as String) = c.market_order_id
where True -- ready_for_delivery_on_lavka is not null
--and station_id is not null
;
                                                                                                                                                                   
$p_s = 
SELECT 
 DISTINCT 
     s.store_id as place_id
     , s.store_wms_id as store_wms_id
     , station_id
From
$accept_time AS t
left join 
( select distinct market_order_id, 
 external_id as lavka_external_id from
    `//home/taxi-delivery/analytics/production/k2/k2_datamart`
    where pickup_or_lavka = 'lavka' 
union all 
select distinct market_order_id, 
 external_id as lavka_external_id from
    `//home/taxi-delivery/analytics/production/k2/ts_datamart`
    where pickup_or_lavka = 'lavka' 
) as d 
    on d.market_order_id = t.order_id
left join 
    range('//home/eda-dwh/ods/wms/order', '2021-01-01') as l 
    on l.external_id = d.lavka_external_id 
left join 
    `//home/eda-dwh/ods/wms/store/store` as s
    on s.store_wms_id = l.store_wms_id
where 1=1
and s.store_id is not null
and station_id <> 'fde0d790-3080-4a51-8526-86f958a13794'
;

insert into 
`//home/taxi-delivery/analytics/dev/k2/accept_time_on_lavki`
with truncate
SELECT 
    t.*
    , p.place_id as place_id
    , p.store_wms_id as store_wms_id
from 
$accept_time AS t
left join 
    $p_s as p
    on p.station_id = t.station_id
;
