use hahn;

$beru_orders =
(
select distinct claim_id
from `//home/eda-analytics/vlesnichenko/lavka_beru_raw`
where confirmed_flg = True
)
;

$about_points =
(
select
    c.corp_client_id as corp_client_id,
    c.taxi_order_id as taxi_order_id,
    cp.*,
    p.* without cp.hash, p.hash,
    cp.id, cp.updated_ts
from
    `//home/taxi/production/replica/postgres/cargo_claims/claim_points` as cp
left join
    `//home/taxi/production/replica/postgres/cargo_claims/points` as p
    on cp.point_id = p.id
join
    `//home/taxi/production/replica/postgres/cargo_claims/claims` as c
    on cp.claim_id = c.id
join $beru_orders as b on c.id = b.claim_id
);

$base =
(
 select taxi_order_id,
            count(distinct claim_id) as claims,
            count(*) as all_points,
            count_if(visit_status = 'arrived') as arrived_points,
            count_if(visit_status = 'pending') as pending_points,
            count_if(visit_status = 'skipped') as skipped_points,
            count_if(visit_status = 'visited') as visited_points,
            count_if(visit_status = 'visited' and type = 'destination') as visited_destinations,
            count_if(visit_status = 'skipped' and type = 'destination') as is_refund
from $about_points
group by taxi_order_id
)
;

-- INSERT INTO `//home/taxi-analytics/alena-lukina/courier20/beru_orders_points`
INSERT INTO `//home/taxi-delivery/analytics/production/k2/beru_orders_points`
with truncate
select *
from $base
;
