use hahn;
pragma yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$MARKET_ORDERS = '//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_dict_flattened';
$GET_COURIER_OPTIONS_GROUPS = '//home/taxi-delivery/analytics/production/k2/combinator_logs/GetCourierOptions_groups';

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/combinator_logs/GetCourierOptions_deferred_courier_status';

$delivery_regions = (
    select delivery_region_own_name
    from $MARKET_ORDERS
    where 1=1
        and delivery_service_id = 93730
    group by delivery_region_own_name
);

$orders_w_groups = (
    select o.delivery_region_own_name as delivery_region_own_name
        , o.creation_date as creation_date
        , o.id as market_id

        , (o.on_demand_delivery_flag and delivery_service_id!=93730) as on_demand_flag
        , o.delivery_service_id = 93730 as deffered_courier_flag

        , o.market_request_id as market_request_id

        , coalesce(g.deferred_courier_group, 'TBA') as deferred_courier_group
        , coalesce(g.on_demand_group, 'TBA') as on_demand_group

        , if(g.on_demand_group = 'OK', 1, 0) as on_demand_available_flag
        , if(g.deferred_courier_group = 'OK', 1, 0) as deferred_courier_available_flag
    from $MARKET_ORDERS as o 
    left join (
        select mrid 
            , deferred_courier_group
            , on_demand_group
        from $GET_COURIER_OPTIONS_GROUPS
    ) as g on o.market_request_id = g.mrid
    where 1=1
        and creation_date >= '2021-12-20'
        and delivery_region_own_name in $delivery_regions
);

$groupped_by_region = (
    select delivery_region_own_name
        , deferred_courier_group
        , creation_date
        , count(market_id) as market_orders_cnt
    from $orders_w_groups
    group by delivery_region_own_name
        , creation_date
        , deferred_courier_group
);

insert into $SAVE_TO with truncate 
select * from $groupped_by_region;
