use hahn;

$LOGS = '//home/taxi-delivery/analytics/production/k2/combinator_logs/GetCourierOptions';
$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/combinator_logs/GetCourierOptions_groups';

$START_DATE = '2021-12-20';

$extract_mrid = ($request_id) -> {
    $first_slash = find($request_id, '/') + cast(1 as Uint32);
    $second_slash = find($request_id, '/', $first_slash) + cast(1 as Uint32);
    $third_slash = find($request_id, '/', $second_slash);
    $mrid = substring($request_id, 0, $third_slash);

    return $mrid;
};

$mrids = (
    select mrid
        , some(ts) as event_timestamp
        , ListSort(AGGREGATE_LIST_DISTINCT(on_demand_error_code)) as on_demand_error_codes
        , ListSort(AGGREGATE_LIST_DISTINCT(deferred_courier_error_code)) as deferred_courier_error_codes
        , case 
            when ListLength(ListSort(AGGREGATE_LIST_DISTINCT(on_demand_error_code))) = 1 then ListSort(AGGREGATE_LIST_DISTINCT(on_demand_error_code))[0]
            when 'OK' in ListSort(AGGREGATE_LIST_DISTINCT(on_demand_error_code)) then 'AT_LEAST_ONE_OK'
            when 'OK' not in ListSort(AGGREGATE_LIST_DISTINCT(on_demand_error_code)) then 'MULTIPLE_ERRORS'
            else 'OTHER'
        end as on_demand_group
        , case 
            when ListLength(ListSort(AGGREGATE_LIST_DISTINCT(deferred_courier_error_code))) = 1 then ListSort(AGGREGATE_LIST_DISTINCT(deferred_courier_error_code))[0]
            when 'OK' in ListSort(AGGREGATE_LIST_DISTINCT(deferred_courier_error_code)) then 'AT_LEAST_ONE_OK'
            when 'OK' not in ListSort(AGGREGATE_LIST_DISTINCT(deferred_courier_error_code)) then 'MULTIPLE_ERRORS'
            else 'OTHER'
        end as deferred_courier_group
    from range($LOGS, $START_DATE)
    group by $extract_mrid(req_id) as mrid
);

insert into $SAVE_TO WITH TRUNCATE
SELECT *
from $mrids;
