/*
    Зачем скрипт?
    Парсит логи комбинатора, чтобы построить воронку для Доставки по Клику в Яндекс Маркете

    Автор:
    @ikhomyanin
*/

use hahn;

$COMBINATOR_LOGS = '//logs/market-combinator-request-log/1d';

$METHOD_NAME = 'GetCourierOptions';

$today = CurrentUtcDate();
$yesterday = cast($today - 3*Interval('P1D') as String);

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/combinator_logs/GetCourierOptions/' || $yesterday;

INSERT INTO $SAVE_TO WITH TRUNCATE 
select uid
    -- , _rest
    , grpc_code
    , graph
    , ts
    , on_demand_error_code
    , grpc_method
    , iso_eventtime
    , client
    , user_agent
    , req_id
    -- , Yson::SerializeJson(Yson::ParseJson(grpc_req)) as grpc_req
    -- , Yson::SerializeJson(Yson::ParseJson(grpc_resp)) as grpc_resp
    , Yson::ConvertToString(_rest['deferred_courier_error_code']) as deferred_courier_error_code
from range($COMBINATOR_LOGS, $yesterday, $yesterday)
where 1=1
    and grpc_method = $METHOD_NAME
    and grpc_resp is not null
    and Yson::YPathBool(Yson::ParseJson(grpc_req), '/disable_external_requests') is null;
    
