use hahn;
PRAGMA yt.InferSchema = '1';
PRAGMA yt.Owners = 'svkorolev';
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$start_dt = '2021-01-01';

$to_date = ($datetime) -> (DateTime::MakeDatetime(DateTime::FromSeconds(CAST($datetime AS UInt32))) )
;

$datetime_parse_tz = DateTime::Parse("%Y-%m-%dT%H:%M:%SZ");

--Все заказы по клику маркета
$ondemand_orders =
select distinct
    cast(order_id as Utf8) as order_id -- id заказа
    , order_creation_date -- Дата создания 
    , order_delivered_datetime -- Дата доставки
    , order_delivery_attribute_min_control_delivery_datetime -- Контрольное минимальное время доставки
    , order_max_control_delivery_datetime
    , order_min_control_delivery_datetime -- Контрольное минимальное время доставки
    , order_raw_original_plan_shipment_date -- Исходное плановое время отправки
    , order_plan_min_delivery_service_delayed_date -- Плановая минимальная дата доставки до переноса СД
    , order_plan_max_delivery_service_delayed_date -- Плановая максимальная дата доставки до переноса СД 
    , order_delivery_attribute_original_delivery_to_datetime --Исходное максимальное время доставки
    , order_delivery_attribute_original_delivery_from_datetime -- Исходное минимальное время доставки
    , order_reserved_datetime -- RESERVED - время перехода в статус
    , order_unpaid_datetime -- UNPAID - время перехода в статус 
    , order_pending_datetime -- PENDING - время перехода в статус 
    , order_processing_datetime -- PROCESSING - время перехода в статус 
    , order_delivery_datetime -- DELIVERY - время перехода в статус 
    , order_pickup_datetime -- PICKUP - время перехода в статус
    , delivered_datetime -- DELIVERED время прохождения
    , order_cancelled_datetime -- CANCELLED - время перехода в статус 
    , order_delivery_service_name -- Название службы доставки
    , order_delivery_service_id -- id службы доставки
    , order_status_ru_name --русское название последнего статуса
    , order_order_status -- последний статус
from range('//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_item_dict_flattened', substring($start_dt, 0, 7))
where 1=1
and order_on_demand_delivery_flag = true
and order_creation_date >= $start_dt
;

-- чекпоинты средней и последней мили заказа
$track_data_miles =
select t.order_id as order_id
    , id as track_id
    , delivery_service_id
    , delivery_service_type
    , t.start_ts
    , o.order_creation_date as order_creation_date
    , o.order_delivered_datetime as order_delivered_datetime
    , row_number() over (partition by t.order_id, t.delivery_service_type order by t.start_ts desc) as delivery_segment
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_delivery_track` as t
inner join $ondemand_orders as o on t.order_id = o.order_id
where 
1=1
--delivery_service_id in (select id from $delivery_services)
    and t.delivery_service_type = 1
;

$middle_mile = (
SELECT
    order_id
    ---, order_creation_date
    , min(checkpoint_ts) as delivered_to_lavka
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_checkpoint` as c
inner join $track_data_miles as t on c.track_id = t.track_id
where 
    (
        raw_status in (45) 
        and checkpoint_ts like '%202%' 
        and delivery_segment = 1
        and order_creation_date > '2020-06-30') 
    or (
        raw_status in (30) 
        and message like '%Заказ доставлен в пункт самовывоза%'
    )
group by 
    t.order_id as order_id
    , t.order_creation_date as order_creation_date
    , t.delivery_service_id as delivery_service_id
    , t.order_delivered_datetime as order_delivered_datetime
)
;

$last_mile = (
SELECT
    order_id
    --, order_creation_date
    , min(checkpoint_ts) as ready_for_delivery_on_lavka
from `//home/cdc/market/production/mstat/delivery_tracker/delivery_checkpoints/delivery_tracker_checkpoint` as c
inner join $track_data_miles as t on c.track_id = t.track_id
where raw_status in (45) 
    and checkpoint_ts like '%202%' 
    and delivery_segment = 2
group by 
    t.order_id as order_id
    , t.order_creation_date as order_creation_date
    , t.delivery_service_id as delivery_service_id
    , t.order_delivered_datetime as order_delivered_datetime
)
;


$market = SELECT
    o.order_id as market_order_id-- id заказа
    , o.order_creation_date as order_creation_date -- Дата создания 
    , o.order_delivered_datetime as order_delivered_datetime -- Дата доставки
    , o.order_delivery_attribute_min_control_delivery_datetime as order_delivery_attribute_min_control_delivery_datetime-- Контрольное минимальное время доставки
    , o.order_min_control_delivery_datetime as order_min_control_delivery_datetime -- Контрольное минимальное время доставки
    , o.order_max_control_delivery_datetime as order_max_control_delivery_datetime -- Контрольное минимальное время доставки
    , o.order_raw_original_plan_shipment_date as order_raw_original_plan_shipment_date -- Исходное плановое время отправки
    , o.order_plan_min_delivery_service_delayed_date as order_plan_min_delivery_service_delayed_date -- Плановая минимальная дата доставки до переноса СД
    , o.order_plan_max_delivery_service_delayed_date as order_plan_max_delivery_service_delayed_date -- Плановая максимальная дата доставки до переноса СД 
    , o.order_delivery_attribute_original_delivery_to_datetime as order_delivery_attribute_original_delivery_to_datetime --Исходное максимальное время доставки
    , o.order_delivery_attribute_original_delivery_from_datetime as order_delivery_attribute_original_delivery_from_datetime -- Исходное минимальное время доставки
    , o.order_reserved_datetime as order_reserved_datetime -- RESERVED - время перехода в статус
    , o.order_unpaid_datetime as order_unpaid_datetime -- UNPAID - время перехода в статус 
    , o.order_pending_datetime as order_pending_datetime -- PENDING - время перехода в статус 
    , o.order_processing_datetime as order_processing_datetime -- PROCESSING - время перехода в статус 
    , o.order_delivery_datetime as order_delivery_datetime -- DELIVERY - время перехода в статус 
    , o.order_pickup_datetime as order_pickup_datetime -- PICKUP - время перехода в статус
    , o.delivered_datetime as delivered_datetime -- DELIVERED время прохождения
    , o.order_cancelled_datetime as order_cancelled_datetime -- CANCELLED - время перехода в статус 
    , o.order_delivery_service_name as order_delivery_service_name -- Название службы доставки
    , o.order_delivery_service_id as order_delivery_service_id -- id службы доставки
    , o.order_status_ru_name as  order_status_ru_name--русское название последнего статуса
    , o.order_order_status as order_order_status-- последний статус
    , mm.delivered_to_lavka as delivered_to_lavka
    , lm.ready_for_delivery_on_lavka as ready_for_delivery_on_lavka
from $ondemand_orders as o
left join 
    $middle_mile as mm 
    on mm.order_id = o.order_id
left join 
    $last_mile as lm 
    on lm.order_id = o.order_id
;


--- лог платформа

$requests =
select 
    distinct 
    request_id
    , request_code
    , MAX(case when status = 'finished' then status else NULL end) as log_status_finished
    , MAX(case when status = 'finished' then $to_date(history_timestamp) else NULL end) as log_status_finished_dt
    , COUNT(case when status = 'finished' then status else NULL end) as log_status_finished_cnt

    , MAX(case when status = 'new' then status else NULL end) as log_status_new
    , MAX(case when status = 'new' then $to_date(history_timestamp) else NULL end) as log_status_new_dt
    , COUNT(case when status = 'new' then status else NULL end) as log_status_new_cnt

    , MAX(case when status = 'processing' then status else NULL end) as log_status_processing
    , MAX(case when status = 'processing' then $to_date(history_timestamp) else NULL end) as log_status_processing_dt
    , COUNT(case when status = 'processing' then status else NULL end) as log_status_processing_cnt
    
    , MAX(case when status = 'returned' then status else NULL end) as log_status_returned
    , MAX(case when status = 'returned' then $to_date(history_timestamp) else NULL end) as log_status_returned_dt
    , COUNT(case when status = 'returned' then status else NULL end) as log_status_returned_cnt
    
    , MAX(case when status = 'returning' then status else NULL end) as log_status_returning
    , MAX(case when status = 'returning' then $to_date(history_timestamp) else NULL end) as log_status_returning_dt
    , COUNT(case when status = 'returning' then status else NULL end) as log_status_returning_cnt

    , MAX(case when status = 'waiting' then status else NULL end) as log_status_waiting
    , MAX(case when status = 'waiting' then $to_date(history_timestamp) else NULL end) as log_status_waiting_dt
    , COUNT(case when status = 'waiting' then status else NULL end) as log_status_waiting_cnt

from range('//home/taxi/testing/export/taxi-logistic-platform-production/requests_history', $start_dt)
where request_code in (select cast(order_id as String) from $ondemand_orders)
group by 
    request_id
    , request_code
;


-- lavka orders 

$parcels = (select order_id, String::JoinFromList(Aggregate_List(item_id), ', ') as item_ids, count(1) as delivered_items_count from 
range(`//home/eda-dwh/ods/wms/order_item_parcel`, `2020-01-01`)
group by order_id);

$orders = (select order_id, some(external_id) as external_id from
`//home/lavka/production/replica/postgres/wms/orders`
group by order_id);

$lavka_orders_tmp = 
SELECT
    distinct 
    `confirmed_flg`,
    `external_id`,
    `order_id`,
    `order_status`,
    `place_address_short`,
    `place_id`,
    `utc_adopted_by_courier_dttm`,
    `utc_arrival_to_customer_fact_dttm`,
    `utc_arrival_to_place_fact_dttm`,
    `utc_claim_created_dttm`,
    `utc_courier_assigned_dttm`,
    `utc_created_dttm`,
    `utc_delivered_dttm`,
    `utc_order_taken_fact_dttm`,
    `utc_place_confirmed_dttm`,
    `wms_reserve_status`
FROM range(`//home/eda-dwh/cdm/order/dm_lavka_order`, `2021`)
;

$lavka_orders = 
select 
    data.*
from
$lavka_orders_tmp as data
left join 
$orders as o
on o.external_id = data.order_id
join
$parcels as p
on p.order_id = o.order_id
;


$lavka_wms = 
SELECT
    T.order_id as lavka_order_id
    , O.external_id as lavka_external_id
    , $to_date(MAX(T.created)) as lavka_wms_status_update_dt
from 
    `home/lavka/production/replica/postgres/wms/orders_log` as T
inner join 
    `home/lavka/production/replica/postgres/wms/orders` as O 
    on O.order_id = T.order_id
group by 
    T.order_id as order_id
    , O.external_id as external_id
;

--stations 

$nodes =
select distinct node_id, a.request_id as request_id, request_code as market_order_id
        , Yson::YPathString(unpacked_data, '/node_location/station_location/station_id') as station_id
from range('home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history', $start_dt) as a
inner join $requests as b on a.request_id = b.request_id
;

$stations =
select station_id
            , max(station_name)  as station_name
            , max(Yson::YPathString(unpacked_data, '/location_details/full_address')) as station_address
            , max(Yson::YPathString(unpacked_data, '/location_details/locality')) as city
from range(`//home/taxi/testing/export/taxi-logistic-platform-production/stations_history`, '2020-12-01')
group by station_id
;


$stations_name = 
select 
    n.station_id as station_id,
    station_name,
    station_address,
    request_id
from $stations as s
inner join 
    $nodes as n 
    on n.station_id = s.station_id
;

--
$dm_deliveries = 
SELECT 
    distinct 
    request_id
    , request_code
    , taxi_order_id
    , lavka_external_id
    , claim_id
    , claim_status
from 
    `//home/taxi-delivery/analytics/production/dm_deliveries`
;
-- lavka parcels 
$lavka_parcels = 
SELECT 
    ref_order as market_order_id
    , id as lavka_order_id_parcels
    , token as parcels_token
    , Yson::ConvertToString(status) as lavka_parcels_status
    , $to_date(updated) as lavka_parcels_status_update_tt
FROM 
    range('//home/lavka/production/replica/postgres/tristero_parcels/orders', '2021-01')
;

--- support
$a=SELECT 
    id, 
    String::JoinFromList(ListNotNull(Listmap(Yson::ConvertToList(history), ($x) -> {RETURN IF(
        Yson::ConvertToString($x.action) IN ('hidden_comment', 'defer', 'close', 'comment', 'communicate')
        AND Yson::ConvertToString($x.login) != 'superuser'
        AND Yson::ConvertToString($x.action) != 'dismiss',
        Yson::ConvertToString($x.hidden_comment) ?? Yson::ConvertToString($x.comment)
    )})), '\n\n') AS comm
FROM `home/taxi/production/services/support-taxi/support_chatterbox`
WHERE true
    --AND line='taxi_logistics_penalty'
    AND "rd_info_spam_empty_mail" NOT IN Yson::ConvertToStringList(tags)
    AND(("complaint_driver_from_market_user" IN Yson::ConvertToStringList(tags) 
        OR "complaint_driver_from_market_provider" IN Yson::ConvertToStringList(tags)
        OR "877575" IN Yson::ConvertToStringList(tags)))
    AND (("form_46200_asked_for_money" IN Yson::ConvertToStringList(tags) 
        OR "form_46200_broken" IN Yson::ConvertToStringList(tags)
        OR "form_46200_delivery_failed" IN Yson::ConvertToStringList(tags)))
;

$support = 
select 
    st.order_id as support_order_id
    , st.solved_dttm as solved_dttm
    , st.creation_dttm as creation_dttm
    , st.status as support_status
    , st.theme as theme
    , a.comm as comment
from 
    `//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets` as st
inner join 
    `//home/taxi/production/services/support-taxi/support_chatterbox` as sc
    on sc.id = st.chatterbox_ticket
left join 
    $a as a
    on a.id = sc.id

;

-- taxi 
/*
$order_log = 
select 
    order_id as taxi_order_id
    
    , MAX(case when backend_status = 'pending' then backend_status else null end) as taxi_status_pending
    , MAX(case when backend_status = 'pending' then utc_status_created_dttm else null end) as taxi_status_pending_dt
    , count(case when backend_status = 'pending' then backend_status else null end) as taxi_status_pending_cnt

    , MAX(case when backend_status = 'assigned' then backend_status else null end) as taxi_status_assigned
    , MAX(case when backend_status = 'assigned' then utc_status_created_dttm else null end) as taxi_status_assigned_dt
    , count(case when backend_status = 'assigned' then backend_status else null end) as taxi_status_assigned_cnt

    , MAX(case when backend_status = 'cancelled' then backend_status else null end) as taxi_status_cancelled
    , MAX(case when backend_status = 'cancelled' then utc_status_created_dttm else null end) as taxi_status_cancelled_dt
    , count(case when backend_status = 'cancelled' then backend_status else null end) as taxi_status_cancelled_cnt

    , MAX(case when backend_status = 'finished' then backend_status else null end) as taxi_status_finished
    , MAX(case when backend_status = 'finished' then utc_status_created_dttm else null end) as taxi_status_finished_dt
    , count(case when backend_status = 'finished' then backend_status else null end) as taxi_status_finished_cnt

from 
    range("//home/taxi-dwh/ods/dbprocessing/order_status_log", $start_dt)
group by 
order_id as taxi_order_id
;
*/
$status_history_table = 
SELECT  
    m.*
    , r.*
    , lw.*
    --, taxi.*
    , s.*
    , lo.*
    , lp.*
    , dd.claim_id
    , dd.claim_status
    , dd.taxi_order_id as taxi_order_id
    , st.station_id as station_id
    , st.station_name as station_name
    , st.station_address as station_address
from 
    $market as m
left join 
    $requests as r 
    on r.request_code = m.market_order_id
inner join 
    $dm_deliveries as dd 
    on dd.request_code = m.market_order_id
left join 
    $lavka_wms as lw 
    on lw.lavka_external_id = dd.lavka_external_id
left join 
    $support as s 
    on s.support_order_id = dd.taxi_order_id
left join 
    $lavka_parcels as lp 
    on lp.market_order_id = m.market_order_id
/*left join 
    $order_log as taxi 
    on taxi.taxi_order_id = dd.taxi_order_id
    */
left join 
    $lavka_orders as lo 
    on lo.external_id = dd.lavka_external_id
left join 
    $stations_name as st 
    on dd.request_id = st.request_id
;




--- final 
$final_table = "//home/taxi-delivery/analytics/production/k2/status_table_history";
insert into 
$final_table 
WITH TRUNCATE 
SELECT 
    *
from 
$status_history_table
;


$requests_last_grp =
select 
    request_id
    --, LAST_VALUE(status) ignore nulls OVER window1  as log_status_last
    , MAX(history_timestamp) as history_timestamp
from range('//home/taxi/testing/export/taxi-logistic-platform-production/requests_history', $start_dt)
where request_code in (select cast(order_id as String) from $ondemand_orders)
and status is not null
group by 
   request_id 
;


$requests_last =
select 
    distinct 
    t.request_id as request_id
    , t.status as log_status_last
    , $to_date(t.history_timestamp) as log_status_last_dt
from range('//home/taxi/testing/export/taxi-logistic-platform-production/requests_history', $start_dt) as t
inner join $requests_last_grp as r 
     on r.request_id = t.request_id
     and r.history_timestamp = t.history_timestamp
where request_code in (select cast(order_id as String) from $ondemand_orders)
and status is not null
;

$order_log_last_grp = 
select 
    order_id
    , MAX(utc_status_created_dttm) as utc_status_created_dttm
from 
    range("//home/taxi-dwh/ods/dbprocessing/order_status_log", $start_dt)
where backend_status is not NULL
group by 
     order_id
;

$order_log_last = 
select 
    t.order_id as taxi_order_id
    , t.backend_status as taxi_status_last
    , t.utc_status_created_dttm as taxi_status_las_dt
from 
    range("//home/taxi-dwh/ods/dbprocessing/order_status_log", $start_dt) as t
inner join 
     $order_log_last_grp as o
     on o.order_id = t.order_id
     and o.utc_status_created_dttm = t.utc_status_created_dttm
where backend_status is not NULL
;

$fin = "//home/taxi-delivery/analytics/production/k2/status_table";

insert into 
$fin
with truncate
SELECT
    distinct
    market_order_id
    , t.request_code as request_code
    , t.request_id as request_id
    ,  case when order_creation_date > '2021-06-12' then lavka_order_id_parcels else  lavka_order_id end as lavka_order_id
    --, lavka_external_id
    , t.taxi_order_id as taxi_order_id
    , support_order_id
    
    --market
    , order_creation_date
    , delivered_datetime as order_delivery_date
    , order_max_control_delivery_datetime --контрольное максимальное время доставки
    , order_raw_original_plan_shipment_date -- Исходное плановое время отправки
    , order_status_ru_name --русское название последнего статуса
    , order_order_status -- последний статус
    , ListMax(AsList(order_reserved_datetime, order_unpaid_datetime, order_pending_datetime, order_processing_datetime
        , order_delivery_datetime, order_pickup_datetime, delivered_datetime, order_cancelled_datetime, delivered_datetime)) as market_status_update_date
    --- лог
    , log_status_last as log_status_last
    , log_status_last_dt as log_status_last_dt
    
    --чекпоинты пвз лавки
    , delivered_to_lavka 
    , ready_for_delivery_on_lavka
    , case when ready_for_delivery_on_lavka > delivered_to_lavka
        then  1.0 * (DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Update($datetime_parse_tz(ready_for_delivery_on_lavka))))
        -
        DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Update($datetime_parse_tz(delivered_to_lavka)))))
        / 3600
        else 0
        end as time_delta_normal_hour 
    
    -- статусы го 
    , taxi_status_last
    , taxi_status_las_dt
    
    -- lavka
    , lavka_parcels_status
    , lavka_parcels_status_update_tt
    , station_address as place_address
    , station_name as place_name
    , case when order_creation_date >= '2021-06-12' then lavka_parcels_status else  cast(order_status as String) end as lavka_status 
    , case when order_creation_date >= '2021-06-12' then lavka_parcels_status_update_tt else  
    $to_date(ListMax(AsList(utc_adopted_by_courier_dttm,
    utc_arrival_to_customer_fact_dttm,
    utc_arrival_to_place_fact_dttm,
    utc_claim_created_dttm,
    utc_courier_assigned_dttm,
    utc_created_dttm,
    utc_delivered_dttm,
    utc_order_taken_fact_dttm,
    utc_place_confirmed_dttm))) end as lavka_status_update_dt
    , wms_reserve_status
    , lavka_wms_status_update_dt as lavka_wms_status_update_dt
    
    --support
    , solved_dttm
    , creation_dttm
    , support_status
    --, startrek_ticket
    , theme
    , comment
FROM $status_history_table as t
left join 
    $requests_last as r 
    on r.request_id = t.request_id
left join 
    $order_log_last as o 
    on o.taxi_order_id = t.taxi_order_id
;
