use hahn;
PRAGMA yt.InferSchema;


$LP_requests_tmp =
select 
DISTINCT
    request_id
    , request_code
    , employer_code
    , history_event_id
    , status
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", "2021-08-20") 
;

$LP_requests_max = 
select 
    request_id
    , max(history_event_id) as history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", "2021-08-20") 
group by 
    request_id
;

$LP_requests = 
select 
    t.request_id as request_id
    , request_code
    , employer_code
    , status 
from 
    $LP_requests_tmp as t 
inner join 
    $LP_requests_max as m 
    on m.request_id = t.request_id
    and m.history_event_id = t.history_event_id
;

$LP_planned_transfers =
select 
DISTINCT
    request_id
    , external_order_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history", "2021-08-20") 
where 
    external_order_id is not null
;

$LP_operations_tmp =
select 
DISTINCT
    external_order_id
    , operator_event_type
    , operator_id
    , history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history", "2021-08-20") 
;

$LP_operations_max = 
select 
    external_order_id
    , max(history_event_id) as history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history", "2021-08-20") 
group by 
    external_order_id
;

$LP_operations = 
select 
    t.external_order_id as external_order_id
    , operator_id
    , operator_event_type 
from 
    $LP_operations_tmp as t 
inner join 
    $LP_operations_max as m 
    on m.external_order_id = t.external_order_id
    and m.history_event_id = t.history_event_id
;

$LP = 
select 
    r.*
    , o.*
from 
    $LP_requests as r 
left join 
    $LP_planned_transfers as p 
    on p.request_id = r.request_id
left join 
    $LP_operations as o 
    on o.external_order_id = p.external_order_id
;

select count(*) as cnt, count(distinct request_code) as cntd from $LP ;

$LPM_requests_tmp =
select 
DISTINCT
    request_id
    , request_code
    , employer_code
    , history_event_id
    , status
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/requests_history", "2021-08-20") 
;

$LPM_requests_max = 
select 
    request_id
    , max(history_event_id) as history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/requests_history", "2021-08-20") 
group by 
    request_id
;

$LPM_requests = 
select 
    t.request_id as request_id
    , request_code
    , employer_code
    , status 
from 
    $LP_requests_tmp as t 
inner join 
    $LP_requests_max as m 
    on m.request_id = t.request_id
    and m.history_event_id = t.history_event_id
;

$LPM_planned_transfers =
select 
DISTINCT
    request_id
    , external_order_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_transfers_history", "2021-08-20") 
where 
    external_order_id is not null
;

$LPM_operations_tmp =
select 
DISTINCT
    external_order_id
    , operator_event_type
    , operator_id
    , history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history", "2021-08-20") 
;

$LPM_operations_max = 
select 
    external_order_id
    , max(history_event_id) as history_event_id
from 
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history", "2021-08-20") 
group by 
    external_order_id
;

$LPM_operations = 
select 
    t.external_order_id as external_order_id
    , operator_id
    , operator_event_type 
from 
    $LPM_operations_tmp as t 
inner join 
    $LPM_operations_max as m 
    on m.external_order_id = t.external_order_id
    and m.history_event_id = t.history_event_id
;

$LPM = 
select 
    r.*
    , o.*
from 
    $LPM_requests as r 
left join 
    $LPM_planned_transfers as p 
    on p.request_id = r.request_id
left join 
    $LPM_operations as o 
    on o.external_order_id = p.external_order_id
;

$LPD = 
select * from $LP
union all 
select * from $LPM
;

$lavka_id = 
select DISTINCT 
    external_order_id
    , lavka_order_id
from(
select 
    id as external_order_id
    , SOME(Yson::ConvertToString(Yson::YPath(Yson::Parse(items), '/0/status_meta/order_id'))) as lavka_order_id
from 
    range("//home/lavka/production/replica/postgres/tristero_parcels/orders" , "2021-06")
group by 
    id
union all
select 
id as external_order_id
    , SOME(Yson::ConvertToString(Yson::YPath(Yson::Parse(items), '/0/item_history/-3/meta/order_id'))) as lavka_order_id
from 
    range("//home/lavka/production/replica/postgres/tristero_parcels/orders" , "2021-06")
group by 
    id
)
where external_order_id is not null
; 

$orders_tmp =  
select 
t.* 
, case when dm.order_id is not null then dm.claim_id else c.claim_id end as claim_id
, l.lavka_order_id as lavka_order_id
from
    $LPD as t 
left join 
    $lavka_id as l 
    on l.external_order_id = t.external_order_id
left join 
    range("//home/eda-dwh/cdm/order/dm_lavka_order", "2021") as dm
    on l.lavka_order_id = dm.order_id
left join 
    (select distinct id as claim_id, uuid_id as claim_uuid_id from
    `//home/taxi/production/replica/postgres/cargo_claims/claims`) as c 
    on t.external_order_id = c.claim_uuid_id
;

$orders =  
select 
t.* 
, c.taxi_order_id
from
    $orders_tmp as t
left join 
    (select distinct id as claim_id, taxi_order_id from
    `//home/taxi/production/replica/postgres/cargo_claims/claims`) as c 
    on t.claim_id = c.claim_id
;

insert into
`//home/taxi-delivery/analytics/production/k2/order_ids`
WITH TRUNCATE 
SELECT 
    distinct 
    `c.taxi_order_id` as taxi_order_id,
    `claim_id`,
    `employer_code`,
    `external_order_id`,
    `lavka_order_id`,
    `operator_event_type`,
    `operator_id`,
    `request_code`,
    `request_id`,
    `status`
from
$orders 
;
