use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$TS_lavka_orders = '//home/market/production/analytics/product/lavka_wide_interval/orders';

$operator_event_log ='//home/delivery-dwh/ods/logistic_platform_market/operator_event_log';
$request_log = '//home/delivery-dwh/ods/logistic_platform_market/request_log';
$planned_transfer_log = '//home/delivery-dwh/ods/logistic_platform_market/planned_transfer_log';

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/late_in_wide_slot';

$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$parse = DateTime::Parse('%Y-%m-%dT%H:%M:%S');
$date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$step1 =
    (select 
        order_id
        , timeliness
        , type_deliv
        , delivery_from_date
        , order_creation_date
        , delivery_from_time
        , delivery_from_date ||' '|| delivery_from_time ||':00' as delivery_from_datetime
        , delivery_to_date
        , delivery_to_time
        , delivery_to_date ||' '|| delivery_to_time ||':00' as delivery_to_datetime
        , delivered_datetime
        , if(delivery_attribute_fact_delivered_datetime = '1970-01-01T00:00:00', null, delivery_attribute_fact_delivered_datetime) as delivery_attribute_fact_delivered_datetime
        , $date_format($parse(delivery_attribute_fact_delivered_datetime)) as delivery_attribute_fact_delivered_datetime_new
        , case 
            when type_deliv = 'sh_slot' then 'Широкий слот'
            when type_deliv = 'deliv' then 'Курьерка'
            when type_deliv = 'hour_slot' then 'Часовой слот'
            when type_deliv = 'old_ondem_sh_slot' then 'Широкий слот -> По клику'
            when type_deliv = 'old_ondem_hour_slot' then 'Часовой слот -> По клику'
            when type_deliv = 'no_deliv' then 'ПВЗ и др.'
            when type_deliv = 'ondemand' then 'По клику'
            when type_deliv = 'express' then 'Экспресс'
            else 'no type..'
        end as rus_delivery_types
        , diff
        , if(order_cancelled_flag = 1, 'Отмененные', 'Не отмененные') as order_cancelled
        
    from $TS_lavka_orders
    where 1=1
        and type_deliv = 'sh_slot'
        and order_creation_date >= '2022-05-17'
        and if(order_cancelled_flag = 1, 'Отмененные', 'Не отмененные') = 'Не отмененные'
    );

$step2 = 
    (SELECT 
        s.*
        , case 
            when timeliness = 'not_ok' and delivery_attribute_fact_delivered_datetime_new != '1970-01-01T00:00:00' and delivery_attribute_fact_delivered_datetime_new < delivery_from_date ||' '|| delivery_from_time then 'not_ok and early'
            when timeliness = 'not_ok' and delivery_attribute_fact_delivered_datetime_new != '1970-01-01T00:00:00' and delivery_attribute_fact_delivered_datetime_new > delivery_to_date ||' '|| delivery_to_time then 'not_ok and late'
            when timeliness = 'ok_day' and delivery_attribute_fact_delivered_datetime_new != '1970-01-01T00:00:00' and delivery_attribute_fact_delivered_datetime_new < delivery_from_date ||' '|| delivery_from_time then 'not_ok_day and early'
            when timeliness = 'ok_day' and delivery_attribute_fact_delivered_datetime_new != '1970-01-01T00:00:00' and delivery_attribute_fact_delivered_datetime_new > delivery_to_date ||' '|| delivery_to_time then 'not_ok_day and late'
            when timeliness = 'not_ok' and delivery_attribute_fact_delivered_datetime_new = '1970-01-01T00:00:00' then 'not_ok and not delivered'
            else timeliness
        end as timeliness_info 
        ,  DateTime::ToSeconds(DateTime::MakeDatetime($parse(delivery_attribute_fact_delivered_datetime))) as sec_delivered_datetime
        ,  DateTime::ToSeconds(DateTime::MakeDatetime($datetime_parse(delivery_from_datetime))) as sec_delivery_from_datetime
        , DateTime::ToSeconds(DateTime::MakeDatetime($datetime_parse(delivery_to_datetime))) as sec_delivery_to_datetime
        , DateTime::ToSeconds(DateTime::MakeDatetime($datetime_parse(delivery_from_datetime))) - 
                        DateTime::ToSeconds(DateTime::MakeDatetime($parse(delivery_attribute_fact_delivered_datetime))) as diff_early
        , DateTime::ToSeconds(DateTime::MakeDatetime($parse(delivery_attribute_fact_delivered_datetime))) - DateTime::ToSeconds(DateTime::MakeDatetime($datetime_parse(delivery_to_datetime))) as diff_late
    from $step1 as s
    where delivered_datetime is not null 
);
-------------------------------- разница в секундах --------------------------------------------
$total_diff_time_info = 
    (SELECT 
        cast(order_id as string) as order_id
        , delivery_attribute_fact_delivered_datetime
        , delivery_from_datetime
        , delivery_to_datetime
        , diff_early
        , diff_late
        , if(timeliness_info = 'not_ok and late', diff_late, null) as sec_not_ok_and_late
        , if(timeliness_info = 'not_ok_day and late', diff_late, null) as sec_not_ok_day_and_late
        , if(timeliness_info = 'not_ok and early', diff_early, null) as sec_not_ok_and_early
        , if(timeliness_info = 'not_ok_day and early', diff_early, null) as sec_not_ok_day_and_early
        , order_cancelled
        , rus_delivery_types
        , timeliness
        , timeliness_info
        , type_deliv
        , order_creation_date
    from $step2
);

--------------------------- информация по статусам ---------------------------------------
$request_info = 
    (select distinct 
        request_code
        , request_id
    from range($request_log, '2022-05-01')
    where request_code in (select cast(order_id as string) from $step1)
    );

$planned_transfer_log_info = (
    select 
        request_id
        , MAX(external_order_id) as external_order_id
    from range($planned_transfer_log, '2022-05-01')
    group by request_id
);

$external_info = (
    select 
        request_code
        , r.request_id as request_id
        , external_order_id
    from $request_info as r
    left join $planned_transfer_log_info as p on r.request_id = p.request_id

);

$event_log_info = (
    select 
        o.external_order_id as external_order_id
        , operator_event_type
        , utc_event_dttm
        , request_code
        , request_id
    from range($operator_event_log,  '2022-05-01') as o
    left join $external_info as r on o.external_order_id = r.external_order_id
    where r.external_order_id in (select external_order_id from $external_info)
);

$cnt_status_info = 
    (select 
        external_order_id
        , request_code
        , request_id
        , min(if(operator_event_type = 'created' or operator_event_type = 'in_depot', utc_event_dttm, null)) as created_dttm
        , count_if(operator_event_type = 'created') as cnt_created
        , count_if(operator_event_type = 'beru') as cnt_beru
        , count_if(operator_event_type = 'in_depot') as cnt_in_depot
        , count_if(operator_event_type = 'wide_slot_planner') as cnt_wide_slot_planner
        , count_if(operator_event_type = 'auto_ordered') as cnt_auto_ordered
        , count_if(operator_event_type = 'ordered') as cnt_ordered
        , count_if(operator_event_type = 'courier_assigned') as cnt_courier_assigned
        , count_if(operator_event_type = 'ready_for_delivery') as cnt_ready_for_delivery
        , count_if(operator_event_type = 'delivering') as cnt_delivering
        , count_if(operator_event_type = 'delivered') as cnt_delivered
        , count_if(operator_event_type = 'canceled') as cnt_canceled
    from $event_log_info
    group by  external_order_id
        , cast(request_code as string) as request_code
        , request_id
    );

insert into $SAVE_TO WITH TRUNCATE 

select 
    t.*
    , c.*
    , SUBSTRING(COALESCE(order_creation_date, created_dttm),0,10) as order_creation_date_v2
from $total_diff_time_info as t
left join $cnt_status_info as c on t.order_id = c.request_code


