use hahn;
PRAGMA AnsiOptionalAs;

$cpo_attributes = 
(
SELECT
   distinct 
       order_id
       , `order_delivery_attribute_delivery_service_subtype_name` as delivery_attribute_delivery_service_subtype_name
       , `order_delivery_attribute_first_shipment_warehouse_name` as delivery_attribute_first_shipment_warehouse_name
       , `order_delivery_attribute_order_delivery_scheme_name` as delivery_attribute_order_delivery_scheme_name
       , order_delivery_region_federal_district_en_name as delivery_region_federal_district_name 
       , `order_delivery_attribute_order_logistic_scheme_name` as delivery_attribute_order_logistic_scheme_name
       , `order_delivery_region_province_name` delivery_region_province_name
       , substring(`order_delivery_attribute_fact_delivered_datetime`, 0, 10) as fact_delivered_date
FROM range(`//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_item_dict_flattened`, `2021-09`)
)
;



$cpo_dash_v1 = 
(
SELECT
cpo.order_id as order_id 
, attr.delivery_attribute_delivery_service_subtype_name as delivery_attribute_delivery_service_subtype_name
, attr.delivery_attribute_first_shipment_warehouse_name as delivery_attribute_first_shipment_warehouse_name
, attr.delivery_attribute_order_delivery_scheme_name as delivery_attribute_order_delivery_scheme_name
, attr.delivery_attribute_order_logistic_scheme_name as delivery_attribute_order_logistic_scheme_name
, attr.delivery_region_federal_district_name as delivery_region_federal_district_name
, attr.delivery_region_province_name as delivery_region_province_name
, attr.fact_delivered_date as fact_delivered_date
    , SUM(`cpo_bpvz_final`) as cpo_bpvz
    , SUM(`cpo_contract_final`) as cpo_contract
    , SUM(`cpo_courier_final`) as cpo_courier
    , SUM(`cpo_express_final`) as cpo_express
    , SUM(`cpo_lastmile`) as cpo_lastmile
    , SUM(`cpo_lavka_final`) as cpo_lavka
    , SUM(`cpo_linehole_final`) as cpo_linehole
    , SUM(`cpo_lockers_final`) as cpo_lockers
    , SUM(`cpo_midmile`) as cpo_midmile
    , SUM(`cpo_npvz_final`) as cpo_npvz
    , SUM(`cpo_pickup_point_dropoff_final`) as cpo_pickup_point_dropoff_final
    , SUM(`cpo_scmile`) as cpo_scmile
    , SUM(`cpo_sort_center_own_final`) as cpo_sort_center_own
    , SUM(`cpo_sort_center_partner_final`) as cpo_sort_center_partner
    , sum(lavka_info.lavka_total_cpo/ lavka_info.cnt) as cpo_lavka_true
    , SUM(total_cpo) as total_cpo

FROM `//home/market/production/analytics/business/delivery/cpo/combined_cpo_by_order_id`
as cpo 
inner join 
$cpo_attributes as attr
on attr.order_id = cpo.order_id
left join 
`//home/taxi-delivery/analytics/production/k2/cpo_lavka` as lavka_info
on lavka_info.market_order_id = cpo.order_id
group by 
cpo.order_id
, attr.delivery_attribute_delivery_service_subtype_name
, attr.delivery_attribute_first_shipment_warehouse_name
, attr.delivery_attribute_order_delivery_scheme_name
, attr.delivery_attribute_order_logistic_scheme_name
, attr.delivery_region_federal_district_name
, attr.delivery_region_province_name
, attr.fact_delivered_date
)
;

$lom_ids = 
(SELECT
    `order_id`,
    `logistics_point_id` ,
    `date`
FROM range(`//home/market/production/mstat/dwh/detail/link_order__combinator_segment`, '2021-10')
where segment_type = 'pickup')
;


$corr_pvz_cpo_costs = 
(
select order_id, cpo_bpvz, cpo_npvz, cpo_bpvz+cpo_npvz as cpo_pvzmile from 
$cpo_dash_v1
where 
cpo_bpvz+cpo_npvz > 0
)
;

$corr_pvz_cpo = 
(
select 
l.logistics_point_id as logistics_point_id
, l.`date` as cr_date
, median(c.cpo_pvzmile) as cpo_pvzmile
from 
$corr_pvz_cpo_costs as c
inner join
$lom_ids as l 
on l.order_id = c.order_id
group by 
l.logistics_point_id
, l.`date`
)
;




insert into 
`//home/taxi-delivery/analytics/production/k2/cpo_dash_v1`
with truncate
SELECT
main.*
, greatest(cpo_bpvz + cpo_npvz, cpo_pvzmile) as cpo_pvzmile
from 
$cpo_dash_v1 as main 
left join 
$lom_ids as l 
on l.order_id = main.order_id
left join 
$corr_pvz_cpo as c 
on c.logistics_point_id = l.logistics_point_id
and c.cr_date = l.`date`
