USE chyt.hahn/taxi-delivery;

insert into "<append=false>//home/taxi-delivery/analytics/production/k2/cpo_lavka" --engine=YtTable()
--as
select order_id
, cost as lavka_total_cpo 
, cnt 
, toInt64(market_order_id) as market_order_id
, delivery_type 
from 
(select 
order_id
, count(distinct market_order_id) as cnt 
from
(SELECT
    `order_id`
    , sum(cost) as cost
FROM `//home/taxi-delivery/analytics/production/k2/lavka_cpo`
group by 
order_id) as l_cpo
inner join 
(select distinct 
market_order_id
, order_id
, 'slots' as delivery_type
from 
`//home/taxi-delivery/analytics/production/k2/ts_datamart`
union all 
select distinct 
market_order_id
, order_id
, 'on demand' as delivery_type
from 
`//home/taxi-delivery/analytics/production/k2/k2_datamart`
) as lp 
on lp.order_id = l_cpo.order_id
group by 
order_id
) as del
inner join 
(
select order_id
, cost
, market_order_id
, delivery_type
from
(SELECT
    `order_id`
    , sum(cost) as cost
FROM `//home/taxi-delivery/analytics/production/k2/lavka_cpo`
group by 
order_id) as l_cpo
inner join 
(select distinct 
market_order_id
, order_id
, 'slots' as delivery_type
from 
`//home/taxi-delivery/analytics/production/k2/ts_datamart`
union all 
select distinct 
market_order_id
, order_id
, 'on demand' as delivery_type
from 
`//home/taxi-delivery/analytics/production/k2/k2_datamart`
) as lp 
on lp.order_id = l_cpo.order_id
) as info 
on info.order_id = del.order_id
