use chyt.hahn/taxi-delivery;

insert into "<append=false>//home/taxi-delivery/analytics/production/k2/market_cpo_for_tableau"

select 
 base.cpo_bpvz as cpo_bpvz,
    base.cpo_contract as cpo_contract,
    base.cpo_courier as cpo_courier,
    base.cpo_express as cpo_express,
    base.cpo_lastmile as cpo_lastmile,
    base.cpo_lavka_true as cpo_lavka_true,
    base.cpo_linehole as cpo_linehole,
    base.cpo_midmile as cpo_midmile,
    base.cpo_lockers as cpo_lockers,
    base.cpo_npvz as cpo_npvz,
    base.cpo_pickup_point_dropoff_final as cpo_pickup_point_dropoff_final,
    base.cpo_pvzmile as cpo_pvzmile,
    base.cpo_scmile as cpo_scmile,
    base.cpo_sort_center_own as cpo_sort_center_own,
    base.cpo_sort_center_partner as cpo_sort_center_partner,
    base.delivery_attribute_delivery_service_subtype_name as delivery_attribute_delivery_service_subtype_name,
    base.delivery_attribute_first_shipment_warehouse_name as delivery_attribute_first_shipment_warehouse_name,
    base.delivery_attribute_order_delivery_scheme_name as delivery_attribute_order_delivery_scheme_name,
    base.delivery_attribute_order_logistic_scheme_name as delivery_attribute_order_logistic_scheme_name,
    base.delivery_region_federal_district_name as delivery_region_federal_district_name,
    base.delivery_region_province_name as delivery_region_province_name,
    base.fact_delivered_date as fact_delivered_date,
    base.order_id as order_id,
    base.total_cpo as total_cpo,
    base.mnth as mnth,
    base.total_c as total_c,
    create_date.order_creation_date as order_creation_date,
    create_date.slot_type as slot_type,
    create_date.order_delivery_attribute_shipment_warehouse_region_province_name as order_delivery_attribute_shipment_warehouse_region_province_name,
    create_date.order_delivered_date as order_delivered_date,
    express.cpo_express_batch as cpo_express_batch
 from
(select * 
, toMonth(toDate(fact_delivered_date)) as mnth
, total_cpo as total_c from 
"//home/taxi-delivery/analytics/production/k2/cpo_dash_v1"
) as base
inner join 
(SELECT
    distinct
    `order_creation_date`,
    case when order_delivery_type = 'DELIVERY' and 
    (toDateTime(`order_original_delivery_to_datetime`) - 
    toDateTime(`order_original_delivery_from_datetime`)) / 3600 < 5 then 'УС'
    when 
      order_delivery_type = 'DELIVERY' and 
    (toDateTime(`order_original_delivery_to_datetime`) - 
    toDateTime(`order_original_delivery_from_datetime`)) / 3600 >= 5 then 'ШС'
    else null end as slot_type,
    order_delivery_attribute_shipment_warehouse_region_province_name,
    order_delivered_date, 
    toInt64(`order_id`) as order_id
FROM 
concatYtTablesRange(`//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_item_dict_flattened`, '2021-08'
)
where order_creation_date >= '2021-10-01' --and order_creation_date <= '2021-11-30'
) as create_date
on create_date.order_id = base.order_id
left join 
(
SELECT
toInt64(external_order_id) as order_id
, avg(final_price_wo_vat_cur) as cpo_express_batch
FROM concatYtTablesRange(
"//home/taxi-delivery/analytics/dev/griganton/LOGDATA-1049/express",
 '2021-09-01')
group by 
    order_id
) as express
on express.order_id = base.order_id

