pragma AnsiInForEmptyOrNullableItemsCollections;
use hahn;
PRAGMA yt.Pool="taxi-delivery";

$orders_by_tag = (
    select
        ws.order_id
    from `home/cdc/prod/market/logistics_lom/waybill_segment` as ws
    join `home/cdc/prod/market/logistics_lom/entity_tag` as et on et.entity_id = ws.id
    where et.tag = 'DEFERRED_COURIER' and et.entity_type = 'WAYBILL_SEGMENT' 
);

$orders_by_partner = (
    select
        ws.order_id
    from `home/cdc/prod/market/logistics_lom/waybill_segment` as ws
    where ws.partner_id in (93730)
);

$order_segment = (
    select 
        Cast(Yson::ConvertToDouble(Yson::YPath(ws.location_from, "/warehouseId")) as UInt64) as pickupPointId,
        Cast(Yson::ConvertToDouble(Yson::YPath(ws.location_to, "/inboundInterval/to/0")) as Uint8) as inboundIntervalTo,
        Cast(Yson::ConvertToDouble(Yson::YPath(ws.location_to, "/inboundInterval/from/0")) as Uint8) as inboundIntervalFrom,
        ws.*
    from `home/cdc/prod/market/logistics_lom/waybill_segment` as ws
    where (ws.order_id in $orders_by_tag or ws.order_id in $orders_by_partner)
);

$yandex_go_segment = (
    select *
    from $order_segment as yandex_go_ws
    where yandex_go_ws.segment_type in ('COURIER', 'GO_PLATFORM')
);

$market_courier_segment = (
    select *
    from $order_segment as market_courier_ws
    where market_courier_ws.segment_type = 'MOVEMENT'
);


$change_request_to_ondemand = (
    select 
        * 
    from `//home/cdc/prod/market/logistics_lom/change_order_request` as cr 
    where cr.id IN (
        select 
            min(cr_in.id)
        from `//home/cdc/prod/market/logistics_lom/change_order_request` as cr_in
        where cr_in.request_type = 'CHANGE_TO_ON_DEMAND'
        group by cr_in.order_id
    )
);

$changed_date = (
    SELECT 
    waybill_segment_id,
    min(`date`) as `date` --первый перенос (44 чп) их бывает много
    , count(`date`) as count_resch  
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'DELIVERY_UPDATED_BY_SHOP'
    GROUP BY waybill_segment_id
);


$delivered_at_date = (
    SELECT 
    waybill_segment_id,
    min(`date`) as `date` --первое вручение (49 чп) их бывает много, если вручают не с первого раза
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'DELIVERY_TRANSMITTED_TO_RECIPIENT'
    GROUP BY waybill_segment_id
);


$cancelled_at_date = (
    SELECT 
    waybill_segment_id,
    min(`date`) as `date` 
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'CANCELED'
    GROUP BY waybill_segment_id
);

$delivery_arrived_pickup_point_date = (
    SELECT 
    waybill_segment_id,
    min(`date`) as `date` --первое прибытие на ПВЗ
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'DELIVERY_ARRIVED_PICKUP_POINT'
    GROUP BY waybill_segment_id
);

$last_delivery_arrived_pickup_point_date = (
    SELECT 
    waybill_segment_id,
    max(`date`) as `date` --последнее прибытие на ПВЗ
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'DELIVERY_ARRIVED_PICKUP_POINT'
    GROUP BY waybill_segment_id
);

$delivery_transportation_recipient_date = (
    SELECT 
    waybill_segment_id,
    min(`date`) as `date` --первый вызов курьера на лавку
    from `home/cdc/prod/market/logistics_lom/waybill_segment_status_history` 
    where tracker_status = 'DELIVERY_TRANSPORTATION_RECIPIENT'
    GROUP BY waybill_segment_id
);

$feedback = (
    SELECT 
    CAST(feedback.order_id as String) as feedback_checkouter_order_id,
    feedback.comment as feedback_comment,
    DateTime::MakeDatetime(DateTime::ParseIso8601(feedback.created_at)) as feedback_created_at,
    feedback.`feedback_type` as feedback_type,
    feedback.`grade` as feedback_grade,
    feedback.`is_callback_required` as feedback_is_callback_required
    FROM `//home/market/production/market-pers-feedback-production/cdc/order_feedback` as feedback
);


insert into `//home/taxi-delivery/analytics/dev/k2/one_hour_slot_orders` with truncate

select 
    o.id as lom_order_id,
    o.external_id as checkouter_order_id,
    DateTime::MakeDatetime(DateTime::ParseIso8601(o.created)) as order_created_datetime,
    source_ws.partner_type as source_partner_type,
    source_ws.partner_id as source_partner_id,
    market_courier_ws.partner_id as middle_delivery_partner_id,
    yandex_go_ws.partner_id as last_delivery_partner_id,
    yandex_go_ws.segment_type as last_delivery_segment_type,
    pickup_point.lms_id,
    pickup_point.gps_coord as pickup_point_gps,
    DateTime::MakeDate(DateTime::ParseIso8601(o.delivery_date_min)) as delivery_date,
    DateTime::MakeDatetime(DateTime::Update(DateTime::ParseIso8601(o.delivery_date_min),NULL, NULL, NULL,  CAST(SUBSTRING(CAST(delivery_start_time as String), NULL, 2) AS Uint8), "Europe/Moscow" as Timezone)) as delivery_date_time_start,
    DateTime::MakeDatetime(DateTime::Update(DateTime::ParseIso8601(o.delivery_date_min),NULL, NULL, NULL,  CAST(SUBSTRING(CAST(delivery_end_time as String), NULL, 2) AS Uint8), "Europe/Moscow" as Timezone)) as delivery_date_time_end,
    DateTime::MakeDate(DateTime::ParseIso8601(source_ws.shipment_date)) as source_shipment_date,
    
    DateTime::MakeDate(DateTime::ParseIso8601(market_courier_ws.shipment_date)) as middle_mile_arrived_pickup_date,
    market_courier_ws.inboundIntervalFrom as middle_mile_arrived_pickup_interval_from,
    market_courier_ws.inboundIntervalTo as middle_mile_arrived_pickup_interval_to,
    DateTime::MakeDatetime(DateTime::Update(DateTime::ParseIso8601(market_courier_ws.shipment_date),NULL, NULL, NULL,  market_courier_ws.inboundIntervalFrom, "Europe/Moscow" as Timezone)) as middle_mile_arrived_pickup_date_time_start,
    DateTime::MakeDatetime(DateTime::Update(DateTime::ParseIso8601(market_courier_ws.shipment_date),NULL, NULL, NULL,  market_courier_ws.inboundIntervalTo, "Europe/Moscow" as Timezone)) as middle_mile_arrived_pickup_date_time_end,

    yandex_go_ws.pickupPointId as pickupPointId,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_ws_history.date`)) as delivered_at,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_canc_history.date`)) as cancelled_at,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`market_courier_ws_history.date`)) as market_courier_arrived_pickup_point_at,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_ws_history_2.date`)) as yandex_go_arrived_pickup_point_at,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_resch_history.date`)) as rescheduled_planned_date,
    `yandex_go_resch_history.count_resch` as count_reschedules,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_ws_history_3.date`)) as yandex_go_transportation_recipient_at,
    DateTime::MakeDatetime(DateTime::ParseIso8601(`yandex_go_ws_history_4.date`)) as yandex_go_last_delivery_arrived_pickup_point_date, --последний 45 чп (мог быть уже после 49)
    to_ondemand.id as on_demand_ch_id,
    to_ondemand.reason as on_demand_reason,
    feedback.*,
    o.*,
    coalesce(Yson::Equals(Yson::Lookup(market_courier_ws.location_to, "inboundInterval"),
             Yson::Lookup(($row) -> { return ListFilter(Yson::ConvertToList(Yson::Lookup($row.`market_courier_ws.location_to`, "warehouseWorkTime"), Yson::Options(false as Strict)),
                ($x) -> { return Yson::LookupInt64($x, "day", Yson::Options(true as AutoConvert)) = DateTime::GetDayOfWeek(DateTime::ParseIso8601($row.`market_courier_ws.shipment_date`)) }) }(JoinTableRow())[0], "interval")),
                false) as is_default_market_courier_delivery_interval
from `home/cdc/prod/market/logistics_lom/orders` as o
join `home/cdc/prod/market/logistics_lom/waybill_segment` as source_ws on source_ws.order_id = o.id

join $yandex_go_segment as yandex_go_ws on yandex_go_ws.order_id = o.id
    left join $delivered_at_date as yandex_go_ws_history on yandex_go_ws_history.waybill_segment_id = yandex_go_ws.id
    left join $cancelled_at_date as yandex_go_canc_history on yandex_go_canc_history.waybill_segment_id = yandex_go_ws.id
    left join $changed_date as yandex_go_resch_history on yandex_go_resch_history.waybill_segment_id = yandex_go_ws.id
    left join $delivery_arrived_pickup_point_date as yandex_go_ws_history_2 on yandex_go_ws_history_2.waybill_segment_id = yandex_go_ws.id
    left join $delivery_transportation_recipient_date as yandex_go_ws_history_3 on yandex_go_ws_history_3.waybill_segment_id = yandex_go_ws.id
    left join $last_delivery_arrived_pickup_point_date as yandex_go_ws_history_4 on yandex_go_ws_history_4.waybill_segment_id = yandex_go_ws.id
join `home/cdc/prod/market/logistics_management_service/yt_outlet` as pickup_point
    on pickup_point.lms_id = yandex_go_ws.pickupPointId
join $market_courier_segment as market_courier_ws on market_courier_ws.order_id = o.id
left join $delivery_arrived_pickup_point_date as market_courier_ws_history
    on market_courier_ws_history.waybill_segment_id = market_courier_ws.id
left join $change_request_to_ondemand as to_ondemand on to_ondemand.order_id = o.id

left join $feedback as feedback on feedback.feedback_checkouter_order_id = o.external_id
where source_ws.waybill_segment_index = 0
;
