use hahn;

$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string); 


$days = [
    $one_day_before
    , $two_days_before
    , $three_days_before
    , $four_days_before
];

EVALUATE FOR $day IN $days DO BEGIN
    $table_to = '//home/taxi-delivery/analytics/production/k2/product_analytics/web_lavka_checkouts/' || $day;
    $table_from = '//home/taxi-dwh/ods/metrica/web_lavka/' || substring($day,0,7) || '-01';

    $table = 
        (select distinct  some(substring(referer_url, 8,20)) as referer_url
        , max(utc_event_dttm) as utc_event_dttm
        , some(region_name) as region_name
        , some(city_name) as city_name
        , some(yandex_uid) as yandex_uid
        , some(metrica_browser_uid) as metrica_browser_uid
        , some(app_platform) as app_platform
        , offer_id
        from $table_from
        where 
        (url like 'goal://10min.market.yandex.ru/%checkout.purchase' 
            or url like 'goal://lavka.yandex.ru/%checkout.purchase') 
        and substring(utc_event_dttm, 0, 10) = $day
        group by Yson::ConvertToString(event_value.offer_id) as offer_id

        union all 

        select distinct some(substring(referer_url, 8,20)) as referer_url
        , max(utc_event_dttm) as utc_event_dttm
        , some(region_name) as region_name
        , some(city_name) as city_name
        , some(yandex_uid) as yandex_uid
        , some(metrica_browser_uid) as metrica_browser_uid
        , some(app_platform) as app_platform
        , offer_id
        from $table_from
        where 
        (referer_url like '%10min.market.yandex.ru%success?orderId=%' 
            or referer_url like '%lavka.yandex.ru%success?orderId=%') 
        and substring(utc_event_dttm, 0, 10) = $day
        group by Yson::ConvertToString(event_value.offer_id) as offer_id

    );

    insert into $table_to WITH TRUNCATE 
    select 
        distinct t.* 
        , case when referer_url like '%lavka%' then 'lavka web - pretty'
            when referer_url like '%10min.market%' then '10min.market web'
            else 'none'
        end as web_lavka_or_10minMarket
    from $table as t;
END DO;
