--Пока скрипт выгружает два события, которые вынесены ниже
--Позже их можно дополнять


use hahn;
pragma yson.DisableStrict = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string);

$LAVKA_PURCHASE_EVENT = 'Superapp.Showcase.Event.eda.lavka.checkout.purchase';
$K2_CHECKOUT_EVENT = 'ShipmentGroceryCheckout.Shown';

$events_to_filter = (
    $LAVKA_PURCHASE_EVENT
    , $K2_CHECKOUT_EVENT
);

$extract_market_parcels = ($event_value) -> {
    $list = Yson::YPathList($event_value, '/serviceeventvalue/market_parcel');

    $extract_order_id = ($parcel) -> {
        return Yson::LookupString($parcel, 'order_id');
    };

    return ListMap($list, $extract_order_id);
};

$days = [
    $one_day_before,
    $two_days_before,
    $three_days_before,
    $four_days_before

];

EVALUATE FOR $day IN $days DO BEGIN
    $table_to = '//home/taxi-delivery/analytics/production/k2/product_analytics/superapp_lavka_checkouts/' || $day;
    $table_from = '//home/taxi-dwh/ods/appmetrica/taxi/' || $day;

    $sessions = (
        select appmetrica_device_id
            , session_id
            , some(app_platform) as app_platform
            , some(device_type) as device_type
            , some(gender) as gender
            , some(app_version_name) as app_version_name
            , some(device_manufacturer) as device_manufacturer
            , some(device_model) as device_model
            , some(
                Yson::YPathString(if(event_name = $K2_CHECKOUT_EVENT, event_value, null), '/open_reason')
            ) as k2_checkout_open_reason
            , some(
                Yson::YPathString(if(event_name = $K2_CHECKOUT_EVENT, event_value, null), '/id')
            ) as k2_checkout_request_id
            , some(
                $extract_market_parcels(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null))
            ) as lavka_external_order_ids
            , some(
                Yson::YPathString(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null), '/serviceeventvalue/order_id')
            ) as lavka_order_id
            , SOME(
                Yson::YPathList(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null), '/serviceeventvalue/active_parcel_ids')
            ) as lavka_wms_ids
            , SUM_IF(1, event_name = $LAVKA_PURCHASE_EVENT) as lavka_buy
            , SUM_IF(1, event_name = $K2_CHECKOUT_EVENT) as k2_checkout
            , some(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null)) as lavka_checkout_event_value
            , some(if(event_name = $K2_CHECKOUT_EVENT, event_value, null)) as k2_checkout_event_value
            , some(yandex_uid) as yandex_uid
        from $table_from
        where 1=1
            and event_name in $events_to_filter
        group by appmetrica_device_id
            , session_id
        having (
            (ListLength(some(
                $extract_market_parcels(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null))
            )) > 0) 
            or 
            (ListLength(SOME(
                Yson::YPathList(if(event_name = $LAVKA_PURCHASE_EVENT, event_value, null), 
                                '/serviceeventvalue/active_parcel_ids')
            )) > 0)
        )
    );

    INSERT INTO $table_to WITH TRUNCATE 
    select * from $sessions;
END DO;