/*
    Что делает скрипт?
    Фильтрует заходы из приложения Яндекс Маркета на чекаут Яндекс Лавки для заказа доставки по клику Яндекс доставки

    Автор:
    @ikhomyanin
*/

use hahn;

$TAXI_ACCESS_LOG = '//home/logfeller/logs/taxi-access-log/1d';

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P1D') as String);

$save_to = '//home/taxi-delivery/analytics/production/k2/product_analytics/from_market_to_lavka_without_upsale/' || $yesterday;

$extract_market_parcel = ($req) -> {
    $index_start = find($req, 'packageOrder=');
    $word_length = cast(13 as Uint32);
    $order_length = cast(8 as Uint32);

    return substring($req, $index_start + $word_length, $order_length);
};

$requests = (
        SELECT
        `timestamp` as utc_request_dttm
        , user_agent
        , case
            when (user_agent like '%iPhone%' or user_agent like '%iPad%') then 'ios'
            when user_agent like '%Android%' then 'android'
            else 'desktop'
        end as device_type
        , case 
            when user_agent like '%Beru%' then 'market webview'
            else 'browser'
        end as access_type
        , request
        , $extract_market_parcel(request) as market_id
    FROM range($TAXI_ACCESS_LOG, $yesterday, $yesterday)
    WHERE 1=1
        and http_host = 'lavka.yandex.ru'
        and request LIKE '/checkout?packageOrder%'
        and status = '200'
        and method = 'GET'
);

insert into $save_to with truncate
SELECT market_id
    , max_by('lavka without upsale - ' || device_type || ' - ' || access_type, utc_request_dttm) as app_platform
    , max(utc_request_dttm) as max_utc_request_dttm
    , max_by(user_agent, utc_request_dttm) as user_agent
    , max_by(request, utc_request_dttm) as request
    , max_by(device_type, utc_request_dttm) as device_type
    , max_by(access_type, utc_request_dttm) as access_type
from $requests
group by market_id;
