use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
 
$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string);

$days = [
    $one_day_before,
    $two_days_before,
    $three_days_before,
    $four_days_before

];

EVALUATE FOR $day IN $days DO BEGIN
    $table_to = '//home/taxi-delivery/analytics/production/k2/product_analytics/lavka_orders_source/' || $day;
    $MARKET_ALL = '//home/taxi-delivery/analytics/production/k2/product_analytics/from_market_to_lavka_without_upsale/' || $day;
    $LAVKA_CHECKOUTS = '//home/taxi-delivery/analytics/production/k2/product_analytics/superapp_lavka_checkouts/' || $day;
    $WEB_LAVKA_CHECKOUTS = '//home/taxi-delivery/analytics/production/k2/product_analytics/web_lavka_checkouts/' || $day;
    $K2_DATAMART = '//home/taxi-delivery/analytics/production/k2/k2_datamart';

    $lavka_orders = (
        select lavka_order_id
            , avg(user_cost_w_vat_lcy) as upsale_value
            , some(application_platform) as application_platform
            -- , some(msk_created_dttm) as msk_created_time
            , some(market_order_id) as market_order_id
            , some(substring(msk_created_dttm, 0 ,10)) as msk_created_dttm
            , offer_id
        from $K2_DATAMART as k2
        where 1=1
            and pickup_or_lavka = 'lavka'
           -- and msk_created_dttm 
        group by external_id as lavka_order_id
            , offer_id
    );

    INSERT INTO $table_to WITH TRUNCATE 
        
    SELECT k2.*
            , lc.*
            , CASE 
                when (lc.lavka_order_id is null and k2.application_platform in ('superapp_ios', 'superapp_android')) then k2.application_platform
                WHEN k2.application_platform = 'superapp_ios' then 'ios - ' || coalesce(lc.k2_checkout_open_reason, 'without one-click')
                WHEN k2.application_platform = 'superapp_android' then 'android - ' || coalesce(lc.k2_checkout_open_reason, 'without one-click')
                when k2.application_platform = 'lavka_web' and wlc.web_lavka_or_10minMarket = 'lavka web - pretty' then 'lavka web - pretty'
                when k2.application_platform = 'web_market_lavka' and wlc.web_lavka_or_10minMarket = '10min.market web' then '10min.market web'

                when market.app_platform = 'lavka without upsale - android - browser' then 'lavka without upsale - android - browser'
                when market.app_platform = 'lavka without upsale - android - market webview'  then 'lavka without upsale - android - market webview'
                when market.app_platform = 'lavka without upsale - desktop - browser' then 'lavka without upsale - desktop - browser'
                when market.app_platform = 'lavka without upsale - ios - browser'  then 'lavka without upsale - ios - browser'
                when market.app_platform = 'lavka without upsale - ios - market webview'  then 'lavka without upsale - ios - market webview'
                -- when k2.application_platform = 'lavka_web' and (wlc.web_lavka_or_10minMarket != 'lavka web - pretty' or wlc.web_lavka_or_10minMarket != '10min.market web') then 'lavka web - web without upsale'
                -- старый вариант, но уже нет lavka_order_id в wlc: 
                -- when k2.application_platform = 'lavka_web' and wlc.lavka_order_id is null then 'lavka web - web without upsale'
                ELSE k2.application_platform
            end as app_screen
        from $lavka_orders as k2 
        left join $LAVKA_CHECKOUTS as lc on k2.lavka_order_id = lc.lavka_order_id
        left join $WEB_LAVKA_CHECKOUTS as wlc on k2.offer_id = wlc.offer_id
        left join $MARKET_ALL as market on k2.market_order_id = market.market_id
        where msk_created_dttm = $day
        ;        
END DO;
