USE hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

$dt_format = DateTime::Format('%Y-%m-%d');

-- Dates

$DT_START = $dt_format(DateTime::StartOfMonth(DateTime::ShiftMonths(CurrentUtcDate(), -1)));
$DT_END = $dt_format(
    DateTime::MakeDatetime((DateTime::StartOfMonth(CurrentUtcDateTime())))
    - DateTime::IntervalFromDays(1)
);

$extract_shipents = ($meta) -> {
    return Yson::YPathList($meta, '/commonparams/ongoing_orderids');
};


$appmetrica = '//home/taxi-dwh/ods/appmetrica/taxi/';

$RESULT_PATH = '//home/taxi-delivery/analytics/production/k2/product_analytics/events_from_go/' || $DT_START;
    
    $info_from_logs = 
        (select  
            app_platform 
            , app_version_name 
            , device_manufacturer  
            , device_model  
            , device_type  
            , event_name 
            , event_value 
            , $extract_shipents((event_value)) as order_id
            , Yson::ConvertToString((event_value).serviceeventvalue.user_info.personal_phone_id) as phone_pd_id
            , session_id 
            , user_id
            , utc_event_dttm           
            , yandex_uid
        from range($appmetrica,$DT_START,$DT_END)
        where event_name like '%K2Shipment%'
        );

    -- разбить ордела по строкам 
    $take_order_id = 
        (select * 
        from $info_from_logs
        flatten list by order_id); 



-- Delete daily tables

$DATE_START = CAST($DT_START AS Date);
$DATE_END = CAST($DT_END AS Date);

$tables_idx = ListFromRange(1, Unwrap(DateTime::ToDays($DATE_END - $DATE_START)) + 1);

EVALUATE FOR $table_idx IN $tables_idx DO BEGIN
    $table_name = CAST(CAST($DATE_START + DateTime::IntervalFromDays($table_idx) AS Date) AS String);
    $TABLE_PATH = '//home/taxi-delivery/analytics/production/k2/product_analytics/events_from_go/' || $table_name;
    
    DROP TABLE $TABLE_PATH;

END DO;

    -- сделать order_id строкой 
    INSERT INTO $RESULT_PATH WITH TRUNCATE 
select 
    app_platform
    , app_version_name
    , device_manufacturer
    , device_model
    , device_type
    , event_name
    , event_value
        -- , order_id -- тут прописать условие ордера чтобы уж наверняка 
    , case when Yson::ConvertToString(order_id) like '%grocery%' then  substring(Yson::ConvertToString(order_id),8)
        when Yson::ConvertToString(order_id) like '%delivery:logistic%' then substring(Yson::ConvertToString(order_id),27)
        when Yson::ConvertToString(order_id) like '%shipment%' then  substring(Yson::ConvertToString(order_id),9)
        else Yson::ConvertToString(order_id)
    END as order_id
    , case when Yson::ConvertToString(order_id) like '%grocery%' then  'grocery'
        when Yson::ConvertToString(order_id) like '%delivery:logistic%' then 'delivery:logistic'
        when Yson::ConvertToString(order_id) like '%shipment%' then  'shipment'
        else Yson::ConvertToString(order_id)
    END as order_id_info
    , phone_pd_id
    , session_id
    , user_id
    , utc_event_dttm
    , yandex_uid
from $take_order_id
;