use hahn; 
-- $metrica = '//home/logfeller/logs/taxi-metrika-mobile-log/1d';
-- $metrica = '//home/logfeller/logs/taxi-metrika-mobile-log/30min/2022-03-23T16:30:00';

$extract_shipents = ($meta) -> {
    return Yson::YPathList($meta, '/commonparams/ongoing_orderids');
};

$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string);

$days = [
    $one_day_before,
    $two_days_before,
    $three_days_before,
    $four_days_before

];

EVALUATE FOR $day IN $days DO BEGIN
    $SAVE_TO = '//home/taxi-delivery/analytics/production/k2/product_analytics/events_from_go/' || $day;
    $appmetrica = '//home/taxi-dwh/ods/appmetrica/taxi/' || $day;
    
    $info_from_logs = 
        (select  
            app_platform 
            , app_version_name 
            , device_manufacturer  
            , device_model  
            , device_type  
            , event_name 
            , event_value 
            , $extract_shipents((event_value)) as order_id
            , Yson::ConvertToString((event_value).serviceeventvalue.user_info.personal_phone_id) as phone_pd_id
            , session_id 
            , user_id
            , utc_event_dttm           
            , yandex_uid
        from $appmetrica
        where event_name like '%K2Shipment%'
        );

    -- разбить ордера по строкам 
    $take_order_id = 
        (select * 
        from $info_from_logs
        flatten list by order_id); 

    -- сделать order_id строкой 
    INSERT INTO $SAVE_TO
    select 
        app_platform
        , app_version_name
        , device_manufacturer
        , device_model
        , device_type
        , event_name
        , event_value
        -- , order_id -- тут прописать условие ордера чтобы уж наверняка 
        , case when Yson::ConvertToString(order_id) like '%grocery%' then  substring(Yson::ConvertToString(order_id),8)
            when Yson::ConvertToString(order_id) like '%delivery:logistic%' then substring(Yson::ConvertToString(order_id),27)
            when Yson::ConvertToString(order_id) like '%shipment%' then  substring(Yson::ConvertToString(order_id),9)
            else Yson::ConvertToString(order_id)
        END as order_id
        , case when Yson::ConvertToString(order_id) like '%grocery%' then  'grocery'
            when Yson::ConvertToString(order_id) like '%delivery:logistic%' then 'delivery:logistic'
            when Yson::ConvertToString(order_id) like '%shipment%' then  'shipment'
            else Yson::ConvertToString(order_id)
        END as order_id_info
        , phone_pd_id
        , session_id
        , user_id
        , utc_event_dttm
        , yandex_uid
    from $take_order_id
    ;
END DO;

