use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$fact_new = '//home/market/production/mstat/analyst/regular/cubes_vertica/fact_new_order_dict_flattened';
$request_log = '//home/delivery-dwh/ods/logistic_platform_market/request_log';

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/Market_Orders_On_Demand_dash/k2_ts_shs_orders_dash';

$table = (
    select 
        delivery_region_own_name
        , creation_date
        , id
        , on_demand_delivery_flag
        , delivery_service_id
        , case 
            WHEN ListHas(Yson::ConvertToStringList(operator_tag_list), "WIDE_INTERVAL") = true then 'WIDE_INTERVAL'
            when ListHas(Yson::ConvertToStringList(operator_tag_list), "DEFERRED_COURIER") = true then 'DEFERRED_COURIER'
            else NULL 
        end as operator_tag_list
    from $fact_new as f
    left join range($request_log, '2021-10-01') as r on cast(f.id as string) = r.request_code
    where 1=1
    and creation_date >= '2021-10-01'
    and order_status in (
        'DELIVERED'
        , 'DELIVERY'
        , 'PENDING'
        , 'PLACING'
        , 'PROCESSING'
        , 'RESERVED'
    )
);

$table_agg = (
    select delivery_region_own_name
        , creation_date
        , id
        , on_demand_delivery_flag
        , delivery_service_id
        , MAX(operator_tag_list) as operator_tag_list
    from $table
    group by delivery_region_own_name
        , creation_date
        , id
        , on_demand_delivery_flag
        , delivery_service_id
);

$agg_info = 
    (select 
        delivery_region_own_name
        , creation_date
        , count(id) as market_orders_total_cnt
        , count(id) - count_if(on_demand_delivery_flag and delivery_service_id != 93730) - count_if(delivery_service_id = 93730) as not_yandex_delivery_orders
        , count_if(on_demand_delivery_flag and delivery_service_id!=93730) as on_demand_orders_cnt
        , count_if(delivery_service_id=93730 and not on_demand_delivery_flag and operator_tag_list = 'WIDE_INTERVAL') as wild_slot_orders_cnt
        , count_if(delivery_service_id=93730 and not on_demand_delivery_flag and operator_tag_list = 'DEFERRED_COURIER') as time_slot_orders_cnt
        , count_if(delivery_service_id=93730 and on_demand_delivery_flag and operator_tag_list = 'DEFERRED_COURIER') as time_slot_to_ondemand_orders_cnt
        , count_if(delivery_service_id=93730 and on_demand_delivery_flag and operator_tag_list = 'WIDE_INTERVAL') as wild_slot_to_ondemand_orders_cnt

    from $table_agg
    group by delivery_region_own_name
        , creation_date
);

insert into $SAVE_TO WITH TRUNCATE 

SELECT 
    delivery_region_own_name
    , creation_date
    , market_orders_total_cnt
    , not_yandex_delivery_orders
    , on_demand_orders_cnt
    , wild_slot_orders_cnt
    , time_slot_orders_cnt
    , time_slot_to_ondemand_orders_cnt
    , wild_slot_to_ondemand_orders_cnt
    , Math::Round(1.0 * (on_demand_orders_cnt + time_slot_orders_cnt + wild_slot_orders_cnt + time_slot_to_ondemand_orders_cnt + wild_slot_to_ondemand_orders_cnt) / market_orders_total_cnt, -3) as yandex_delivery_share
    , Math::Round(1.0* (on_demand_orders_cnt + time_slot_to_ondemand_orders_cnt + wild_slot_to_ondemand_orders_cnt) / market_orders_total_cnt, -3) as on_demand_share
    , Math::Round(1.0 * time_slot_orders_cnt / market_orders_total_cnt, -3) as time_slot_share
    , Math::Round(1.0 * wild_slot_orders_cnt / market_orders_total_cnt, -3) as wild_slot_share
from $agg_info 
