import sys
import os
import pandas as pd
import numpy as np
from business_models import hahn
from business_models.greenplum import GreenplumManager

if __name__=='__main__':

    with open ('turnover_base.sql') as f:
        sql = f.read()
    hahn(sql)

    greenplum = GreenplumManager(user='svkorolev', token=str(os.environ['GP_TOKEN']),
                                 connect_args={'sslmode': 'require'})

    greenplum.replicate(#yt_path='//home/taxi-analytics/alena-lukina/courier20/turnover_base',
                        yt_path='//home/taxi-delivery/analytics/production/k2/turnover_base',
    table_name='snb_taxi.svkorolev_courier20_turnover_base', if_exists='replace')

    with open ('accept_time.sql') as m:
        sql1 = m.read()
    hahn(sql1)

    greenplum.replicate(yt_path='home/taxi-delivery/analytics/dev/k2/accept_time_on_lavki',
    table_name='snb_taxi.svkorolev_accept_time_monitoring', if_exists='replace')

    with open('beru_orders_points.sql') as t:
        sql2 = t.read()
    hahn(sql2)

    greenplum.replicate(#yt_path='//home/taxi-analytics/alena-lukina/courier20/beru_orders_points',
                        yt_path='//home/taxi-delivery/analytics/production/k2/beru_orders_points',
                        table_name='snb_taxi.svkorolev_courier20_beru_orders_points', if_exists='replace')

