use hahn;

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};

$seconds_to_dttm = ($seconds) -> {
    return cast(AddTimezone(Datetime::FromSeconds($time_cast($seconds)), 'Europe/Moscow') as Datetime)
};

$final_table = "//home/taxi-delivery/analytics/production/k2/express_logplathform";


$requests = 
(
SELECT
    distinct 
    $seconds_to_dttm(created_at) as created_dttm,
    request_code,
    employer_code,
    request_id
FROM range(`//home/taxi/testing/export/taxi-logistic-platform-production/requests_history`, '2021-08-01')
union all 
SELECT
    distinct 
    $seconds_to_dttm(created_at) as created_dttm,
    request_code,
    employer_code,
    request_id
FROM range(`//home/taxi/testing/export/taxi-logistic-platform-market-production/requests_history`, '2021-08-01')
)
;

$nodes = 
(
    select
    distinct
    request_id 
    , Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/details/locality')) as city 
    ,
Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/details/settlement')) as settlement 
    ,
Yson::ConvertToDouble(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/coord/x')) as x_point 
    ,
Yson::ConvertToDouble(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/coord/y')) as y_point 
    , $seconds_to_dttm(Yson::ConvertToUint64(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/planned_interval_time/min'))) as interval_start_dttm
    , $seconds_to_dttm(Yson::ConvertToUint64(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/planned_interval_time/max'))) as interval_finish_dttm
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history`, '2021-08-01')
where 
    1=1
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data),  '/node_code')) in ('n_to', 'node_to')
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/policy')) = 'AFAP'
union all 

    select
    distinct
    request_id 
    , Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/details/locality')) as city 
    , $seconds_to_dttm(Yson::ConvertToUint64(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/planned_interval_time/min'))) as interval_start_dttm
    , $seconds_to_dttm(Yson::ConvertToUint64(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/planned_interval_time/max'))) as interval_finish_dttm
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_nodes_history`, '2021-08-01')
where 
    1=1
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data),  '/node_code')) in ('n_to', 'node_to')
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/policy')) = 'AFAP'
)
;

$transfers = 
(
    select 
    request_id
    , max(external_order_id) as external_order_id
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history`, '2021-08-01')
    group by 
        request_id 

union all

    select 
    request_id
    , max(external_order_id) as external_order_id
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_transfers_history`, '2021-08-01')
    group by 
        request_id 
)
;


$LP = 
(select 
    distinct
    r.request_id as request_id
    , r.request_code as request_code
    , r.employer_code as employer_code
    , t.external_order_id as external_order_id
    , created_dttm
    , interval_start_dttm
    , city
    , settlement
    , x_point, y_point
from 
    $requests as r 
inner join 
    $nodes as n
    on n.request_id = r.request_id
inner join 
    $transfers as t 
    on t.request_id = r.request_id
)
;


insert into
$final_table
WITH TRUNCATE 
select * from $LP;
