use hahn;

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};

$seconds_to_dttm = ($seconds) -> {
    return cast(AddTimezone(Datetime::FromSeconds($time_cast($seconds)), 'Europe/Moscow') as Datetime)
};

$final_table = "//home/taxi-delivery/analytics/production/k2/k2_logplathform";


$requests = 
(
SELECT
    distinct 
    $seconds_to_dttm(created_at) as created_dttm,
    request_code,
    employer_code,
    request_id
FROM range(`//home/taxi/testing/export/taxi-logistic-platform-production/requests_history`, '2021-08-01')
)
;

$nodes = 
(
    select
    distinct
    request_id 
    , Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/details/locality')) as city 
    ,
Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/temporary_location/details/settlement')) as settlement 
    , $seconds_to_dttm(Yson::ConvertToUint64(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/planned_interval_time/min'))) as interval_start_dttm
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history`, '2021-08-01')
where 
    1=1
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data),  '/node_code')) in ('n_to', 'node_to')
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/requested_processing_interval/policy')) = 'min_by_request'
)
;

$nodes_from = 
(
    select
    distinct
    request_id 
    , Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/station_location/station_id')) as station_id 
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history`, '2021-08-01')
where 
    1=1
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data),  '/node_code')) in ('n_from', 'node_from')
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/station_location/station_id')) is not null 
    and Yson::ConvertToString(Yson::YPath(Yson::Parse(unpacked_data), '/node_location/station_location/station_id')) <> ''
) 
;

$transfers = 
(
    select 
    request_id
    , max(external_order_id) as external_order_id
from 
    range(`//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history`, '2021-08-01')
    group by 
        request_id 
)
;

$events = ( 
    select 
    distinct external_order_id
    , operator_id
    , max(case when operator_event_type = 'ordered' then $seconds_to_dttm(event_instant) else null end) as claim_created_dttm
    , max(case when operator_event_type = 'delivered' then $seconds_to_dttm(event_instant) else null end) as delivered_dttm
from range(`//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history`, '2021-08-01')
group by external_order_id
, operator_id 
        
)
;


$LP = 
(select 
    distinct
    r.request_id as request_id
    , r.request_code as request_code
    , r.employer_code as employer_code
    , t.external_order_id as external_order_id
    , created_dttm
    , station_id
    , interval_start_dttm
    , claim_created_dttm
    , delivered_dttm
    , city
    , settlement
    , operator_id
    , case when (1.0 * (DateTime::ToSeconds(claim_created_dttm)) / 60) between ((1.0 * (DateTime::ToSeconds(interval_start_dttm)) / 60) - 15) and ((1.0 * (DateTime::ToSeconds(interval_start_dttm)) / 60) + 45) then False else True end as change_to_on_demand_flg
from 
    $requests as r 
inner join 
    $nodes as n
    on n.request_id = r.request_id
left join 
    $nodes_from as nf
    on nf.request_id = r.request_id
inner join 
    $transfers as t 
    on t.request_id = r.request_id
left join 
    $events as e
    on e.external_order_id = t.external_order_id
)
;


insert into
$final_table
WITH TRUNCATE 
select * from $LP;
