USE chyt.hahn/taxi-delivery;


--drop table if exists "//home/taxi-delivery/analytics/production/k2/wide_slots_logplatform";
--create table "//home/taxi-delivery/analytics/production/k2/wide_slots_logplatform" engine=YtTable() as
insert into "<append=false>//home/taxi-delivery/analytics/production/k2/wide_slots_logplatform" --engine=YtTable() as
select dt as created_dt
, request_code
, operator_status
, status_dt
, toDateTime(min_int) as min_dt
, timestamp_sub(hour, 144, toDateTime(max_int)) as max_dt
, lavka_order_id
, wms_id
from 
(SELECT distinct
    toDate(`created_at`) as dt,
    request_code,
    request_id,
    YPathString(unpacked_data, '/operator_tags/0') as op_tag_1,
    YPathString(unpacked_data, '/operator_tags/1') as op_tag_2,
    YPathString(unpacked_data, '/operator_tags/1') as op_tag_3
FROM concatYtTablesRange(`//home/taxi/testing/export/taxi-logistic-platform-market-production/requests_history`, '2022-03-14')
where 
1=1
and (op_tag_1 = 'DEFERRED_COURIER' or op_tag_2 = 'DEFERRED_COURIER' or op_tag_3 = 'DEFERRED_COURIER')
and (op_tag_1 = 'WIDE_INTERVAL' or op_tag_2 = 'WIDE_INTERVAL' or op_tag_3 = 'WIDE_INTERVAL')
) as rh
left join 
(
    select 
    request_id 
    , argMax(external_order_id, history_event_id) as external_order_id
    from 
    concatYtTablesRange(`//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_transfers_history`, '2022-03-14')
    group by 
        request_id
) as pth 
on pth.request_id = rh.request_id
left join 
(
select 
    external_order_id,
    argMax(operator_event_type, history_event_id) as operator_status,
    MAX(event_instant) as status_dt
FROM concatYtTablesRange(`//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history`, '2022-03-14') 
group by 
    external_order_id
) as oeh 
on oeh.external_order_id = pth.external_order_id
left join 
(select 
    request_id, 
    YPathInt64(unpacked_data, '/requested_processing_interval/planned_interval_time/min') as min_int,
    YPathInt64(unpacked_data, '/requested_processing_interval/planned_interval_time/max') as max_int
FROM concatYtTablesRange(`//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_nodes_history`, '2022-03-14') 
where YPathString(unpacked_data, '/node_code') = 'n_to'
) as pnh 
on pnh.request_id = rh.request_id
left join 
(select 
market_order_id as ref_order,  lavka_order_id,  wms_id
from 
"//home/taxi-delivery/analytics/dev/k2/lavka_actual_statuses"
) as lavka
on lavka.ref_order = rh.request_code

