use hahn;
PRAGMA yt.InferSchema = '10';
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$k2_base = '//home/taxi-delivery/analytics/production/k2/ts_datamart_for_tableau';
$ts_base = '//home/taxi-delivery/analytics/production/k2/k2_datamart_for_tableau';
$path = '//home/taxi-delivery/analytics/production/k2/dash_beru';


$base =
(

    select a.*, 'hour_slot' as delivery_option
    from $k2_base as a
    where dt < CurrentUtcDate()

    union all

    select b.*, 'on demand' as delivery_option
    from $ts_base as b
    where dt < CurrentUtcDate()

);


insert into $path with truncate
SELECT
    app_platform_name
    ,application_platform
    ,confirmed_flg
    ,delivery_option
    ,dt
    ,executor_tariff_class_code
    ,place_address_short	
    ,region_name	
    ,type
    ,application_plathform_group
    ,courier_type
    ,app_platform
    ,first_order_flg
    ,pickup_type
    ,active_zone_name
    ,sum(cte_dur_sec/60) as cte_min	
    ,sum(delivered_first_attempt_orders) as delivered_first_attempt_orders
    ,sum(delivered_items_count) as delivered_items_count
    ,sum(delivered_orders) as delivered_orders
    ,sum(delivery_cost_lcy) as delivery_cost_lcy
    ,sum_if(1, order_item_cost_w_vat_lcy > 0) as orders_with_upsale
    ,sum(order_item_cnt) as order_item_cnt
    ,sum(order_item_cost_w_vat_lcy) as order_item_cost_w_vat_lcy
    ,sum(parcel_market_cnt) as parcel_market_cnt
    ,sum(parcels) as parcels
    ,count(distinct operator_order_id) as operator_orders
    ,count(distinct order_id) as orders
from
    $base
group by
    app_platform_name
    ,application_platform
    ,confirmed_flg
    ,delivery_option
    ,dt
    ,executor_tariff_class_code
    ,place_address_short	
    ,region_name	
    ,type
    ,case
        when coalesce(application_platform, app_platform_name) in ('lavka_web','web') then 'Desktop'
        when coalesce(application_platform, app_platform_name) in ('mobileweb_android','mobileweb_ios') then 'Touch'
        else 'Other'
        end as application_plathform_group
    ,if(executor_tariff_class_code = 'lavka', 'lavka_courier', 'taxi_courier') as courier_type
    ,coalesce(application_platform, app_platform_name) as app_platform
    ,if(cast(first_order_flg as Int8) > 0, 'first', 'non first') as first_order_flg
    ,coalesce(pickup_or_lavka, 'lavka') as pickup_type
    ,coalesce(active_zone_name, 'foot') as active_zone_name
;
