use hahn;
PRAGMA yt.InferSchema = '10';
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$start_date = '2021-03-01';

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};


$seconds_to_dttm = ($seconds) -> {
    return cast(cast(Datetime::FromSeconds($time_cast($seconds)) as Datetime) as string)
};

$datetime_parse_market = DateTime::Parse("%Y-%m-%dT%H:%M:%S")
;

$transfers = (
    select distinct  
        request_id 
        , request_code as market_order_id
        , operator_id
        , $seconds_to_dttm(created_dttm) as market_order_creation_dttm
        , request_code as request_code
        , $seconds_to_dttm(interval_start_dttm) as order_original_delivery_from_datetime
        , case when delivered_dttm is not null then True else False end as market_order_delivered_flag
        , change_to_on_demand_flg
        , external_order_id
        , external_order_id as claim_uuid_id
        , delivered_dttm
    from `//home/taxi-delivery/analytics/production/k2/time_slots_logplathform`
);

$all_ids = (
    SELECT DISTINCT
        cl.id AS claim_id,
        cl.uuid_id AS claim_uuid_id,
        cl.taxi_order_id AS taxi_order_id,
        cl.status as claim_status,
        tr.market_order_id AS market_order_id,
        tr.request_id AS request_id,
        tr.request_code as request_code,
        tr.market_order_delivered_flag as market_order_delivered_flag,
        tr.change_to_on_demand_flg as change_to_on_demand_flg,
        tr.market_order_creation_dttm as market_order_creation_dttm,
        tr.order_original_delivery_from_datetime as order_original_delivery_from_datetime,
        tr.external_order_id as external_order_id,
        tr.delivered_dttm as delivered_dttm
    FROM  $transfers AS tr
    LEFT JOIN hahn.`home/taxi/production/replica/postgres/cargo_claims/claims` AS cl
    ON cl.uuid_id = tr.claim_uuid_id
    --where cl.status not in ('cancelled_by_taxi', 'performer_not_found')
) ;


$ts_lavka_base = (
    select
        distinct
        1 as market_on_demand_lavka_delivery_flg
        , 0 as market_on_demand_market_pickup_delivery_flg
        , a.*
        , Yson::ConvertToString(Yson::YPath(Yson::Parse(l.items), '/0/status_meta/order_id')) as lavka_order_id
    from 
        $all_ids as a
    inner join 
        range(`//home/lavka/production/replica/postgres/tristero_parcels/orders`, "2021-03") as l
        on l.id = a.external_order_id
)
;



$ts_market_pickup_base = 
    select 
        distinct
        0 as market_on_demand_lavka_delivery_flg
        , 1 as market_on_demand_market_pickup_delivery_flg
        , a.*
        , null as lavka_order_id
    from 
        $all_ids as a
    where 
        a.market_order_id not in (select distinct market_order_id from $ts_lavka_base)
;


$ts_base = 
select
    *
from 
    $ts_lavka_base
union all
select 
    *
from 
    $ts_market_pickup_base
;


$lavka_id = 
select 
    id as external_order_id
    , SOME(Yson::ConvertToString(Yson::YPath(Yson::Parse(items), '/0/status_meta/order_id'))) as lavka_order_id
from 
    range("//home/lavka/production/replica/postgres/tristero_parcels/orders" , "2021-06")
group by 
    id
; 

$lavka = 
select 
    cast(active_zone_name as string)  as active_zone_name
    , k.request_code as market_order_id
    , k.market_order_creation_dttm as market_order_creation_dttm
    , k.change_to_on_demand_flg as change_to_on_demand_flg
    , k.order_original_delivery_from_datetime as order_original_delivery_from_datetime
    , application_platform
    , cancel_reason_type
    , dm.claim_id as claim_id
    , confirmed_flg
    , courier_type
    , cte_dur_sec
    , currency_code
    , currency_rate_rub
    , delivery_cost_lcy
    , delivery_type
    , dispatch_cargo_status
    , local_claim_created_dttm as msk_claim_created_dttm
    , local_created_dttm as msk_created_dttm
    , local_delivered_dttm as msk_delivered_dttm
    , offer_id
    , dm.order_id as order_id
    , order_item_cnt
    , order_item_cost_w_vat_lcy
    , order_location_lat
    , order_location_lon
    , place_address_short
    , region_name
    , user_cost_w_vat_lcy
    , user_phone_pd_id as user_id
    , unique_item_cnt
    , parcel_market_cnt
    , parcel_market_flg
    , payment_type
    , external_id
    , order_item_cost_vat_lcy
    , case
        when executor_tariff_class_code = 'eda' then 'lavka'
        else executor_tariff_class_code end as executor_tariff_class_code
    , taxi_order_flg
    , order_item_cnt as delivered_items_count
    , o.first_order_flg as first_order_flg
    , 'lavka'             as pickup_or_lavka
    , null as operator_event_type
    , k.delivered_dttm as event_instant_dttm
from 
    (select distinct external_order_id 
    , market_on_demand_lavka_delivery_flg
    --, operator_event_type
    , delivered_dttm
    , request_code
    , market_order_creation_dttm
    , change_to_on_demand_flg
    , order_original_delivery_from_datetime
     from $ts_base
    ) as k 
left join 
    $lavka_id as l 
    on l.external_order_id = k.external_order_id
left join 
    range("//home/eda-dwh/cdm/order/dm_lavka_order", "2021") as dm
    on l.lavka_order_id = dm.order_id
left join 
    (select distinct claim_id, taxi_order_id from
    range("//home/delivery-dwh/ods/cargo_claims/claim", "2021-01-01")) as c 
    on dm.claim_id = c.claim_id
left join 
    (select distinct order_id, first_order_flg from range("//home/taxi-dwh/cdm/marketplace/fct_order", $start_date)) as o
    on o.order_id = c.taxi_order_id  
where k.market_on_demand_lavka_delivery_flg = 1
and dispatch_cargo_status <> 'returned_finish'
;

$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S")
;
$datetime_parse_2 = DateTime::Parse("%Y-%m-%dT%H:%M:%SZ")
;

$format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$pickup_market = 
SELECT
    'pickup-market' as active_zone_name
    , k.request_code as market_order_id
    , k.market_order_creation_dttm as market_order_creation_dttm
    , k.change_to_on_demand_flg as change_to_on_demand_flg
    , k.order_original_delivery_from_datetime as order_original_delivery_from_datetime
    , app_platform_name
    , Yson::YPathString(cancel_reason_list, '/0') as cancel_reason_type
    , c.claim_id as claim_id
    , case
        when success_order_flg = True and status_code = 'delivered_finish' then True
        else False end as confirmed_flg
    , 'courier' as courier_type
    , 1.0 * order_completion_time_mnt * 60 as cte_dur_sec
    , c.currency_code as currency_code
    , currency_rate as currency_rate_rub
    , order_cost as delivery_cost_lcy
    , 'cargo_dispatch' as delivery_type
    , status_code as dispatch_cargo_status
    , cast(DateTime::MakeDate($datetime_parse(c.utc_created_dttm)) + Interval('PT3H') as string) as msk_claim_created_dttm
    , msk_order_created_dttm as msk_created_dttm
    , $format($datetime_parse_2($seconds_to_dttm(DateTime::ToSeconds(DateTime::MakeDate($datetime_parse(msk_order_created_dttm))) + (60.0 * order_completion_time_mnt))
     )) as msk_delivered_dttm
    , offer_id
    , order_id
    , 1 as order_item_cnt
    , 0 as order_item_cost_w_vat_lcy
    , null as order_location_lat
    , null as order_location_lon
    , destination_plan_address as place_address_short
    , agglomeration_name_ru as region_name
    , user_w_vat_cost as user_cost_w_vat_lcy
    , user_phone_pd_id as user_id
    , 1 as unique_item_cnt
    , 1 as parcel_market_cnt
    , True as parcel_market_flg
    , fact_payment_type as payment_type
    , c.taxi_order_id as external_id
    , 0 as order_item_cost_vat_lcy
    , 'courier' as executor_tariff_class_code
    , True as taxi_order_flg
    , 1 as delivered_items_count
    , first_order_flg
    , 'pickup_market' as pickup_or_lavka
    , null as operator_event_type
    , k.delivered_dttm as event_instant_dttm
from 
    $ts_base as k
left join
    range("//home/taxi-dwh/cdm/marketplace/fct_order", $start_date) as o
    on o.order_id = k.taxi_order_id
left join 
    range("//home/delivery-dwh/ods/cargo_claims/claim", "2021-01-01") as c 
    on o.order_id = c.taxi_order_id   
where 
    k.market_on_demand_market_pickup_delivery_flg = 1
    and status_code <> 'returned_finish'
;
 

$together = (
    SELECT *
    from $lavka

    union all 

    select  * 
    from $pickup_market);

$log_info = (
    select
        distinct request_code
        , request_id
        , case 
            WHEN ListHas(Yson::ConvertToStringList(operator_tag_list), "WIDE_INTERVAL") = true then 'WIDE_INTERVAL'
            when ListHas(Yson::ConvertToStringList(operator_tag_list), "DEFERRED_COURIER") = true then 'DEFERRED_COURIER'
            else NULL 
        end as operator_tag_list
    from range("//home/delivery-dwh/ods/logistic_platform_market/request_log",'2021-05-01')
);

$totally_together = (
    select 
        t.* 
        , operator_tag_list
    from $together as t 
    left join $log_info as l on t.market_order_id = l.request_code
);

insert into 
`//home/taxi-delivery/analytics/production/k2/ts_datamart`
WITH TRUNCATE
select * 
from $totally_together
;
