use chyt.hahn/taxi-delivery;

insert into
"<append=false>//home/taxi-delivery/analytics/production/k2/ts_datamart_for_tableau"
select 
    dt
    , operator_order_id
    , parcels
    , delivered_orders
    , delivered_first_attempt_orders
    , operator_info.*
from 
(
select 
    dt
    , operator_order_id
    , count(market_order_id) as parcels
    , sum(delivered) as delivered_orders
    , sum(delivered_first_attempt) as delivered_first_attempt_orders
from (
select 
    dt
    , market_order_id
    , operator_order_id
    , delivered
    , case when attempts = 1 then 1*delivered else 0*delivered end as delivered_first_attempt
from (
select all_del.market_order_id as market_order_id
, attempts
, operator_order_id
, case when success.market_order_id is not null then 1 else 0 end as delivered 
, case when success.market_order_id is not null then success.dt else all_del.dt end as dt
from 
(
select
    market_order_id
    , count(distinct order_id) as attempts
    , argMax(order_id, msk_delivered_dttm) as operator_order_id
    , toDate(MAX(msk_delivered_dttm)) as dt
from 
    "//home/taxi-delivery/analytics/production/k2/ts_defect_rate"
where 
    1=1
    and toDate(msk_delivered_dttm) >= toDate('2021-06-15')
group by 
    market_order_id
--having dt >= toDate('2022-01-09')

union all 

select
    market_order_id
    , count(distinct order_id) as attempts
    , argMax(order_id, msk_delivered_dttm) as operator_order_id
    , toDate(MAX(msk_delivered_dttm)) as dt
from 
    "//home/taxi-delivery/analytics/production/k2/ts_datamart"
where 
    1=1
    and toDate(msk_delivered_dttm) < toDate('2021-06-15')
group by 
    market_order_id
--having toDate(dt) >= toDate('2022-01-09')
) as all_del 

left join 
(
select
    market_order_id
    , toDate(MAX(msk_delivered_dttm)) as dt
from 
    "//home/taxi-delivery/analytics/production/k2/ts_datamart"
where msk_delivered_dttm is not null
group by 
    market_order_id
--having toDate(dt) >= toDate('2022-01-09')
) as success
on success.market_order_id = all_del.market_order_id
) 
) 
group by 
dt, operator_order_id 
) as base 
left join
(
    SELECT
    distinct
    'hour slot' as type,
    order_item_cost_w_vat_lcy,
    "active_zone_name",
    "app_platform_name",
    "application_platform",
    coalesce(confirmed_flg, 0) as confirmed_flg,
    "courier_type",
    "cte_dur_sec",
    "delivered_items_count",
    "first_order_flg",
    "msk_claim_created_dttm",
    "msk_delivered_dttm",
    "order_id",
    "order_item_cnt",
    "pickup_or_lavka",
    "place_address_short",
    "region_name",
    executor_tariff_class_code,
    "parcel_market_cnt",
    delivery_cost_lcy
FROM "//home/taxi-delivery/analytics/production/k2/ts_defect_rate"
where 1=1 
and toDate(msk_delivered_dttm) < today()
and toDate(msk_delivered_dttm) >= toDate('2021-06-15')

union all 

SELECT
    distinct
    'hour slot' as type,
    order_item_cost_w_vat_lcy,
    "active_zone_name",
    "app_platform_name",
    "application_platform",
    coalesce(confirmed_flg, 0) as confirmed_flg,
    "courier_type",
    "cte_dur_sec",
    "delivered_items_count",
    "first_order_flg",
    "msk_claim_created_dttm",
    "msk_delivered_dttm",
    "order_id",
    "order_item_cnt",
    "pickup_or_lavka",
    "place_address_short",
    "region_name",
    executor_tariff_class_code,
    "parcel_market_cnt",
    delivery_cost_lcy
FROM "//home/taxi-delivery/analytics/production/k2/ts_datamart"
where 1=1 
and toDate(msk_delivered_dttm) < toDate('2021-06-15')

) as operator_info 
on base.operator_order_id = operator_info.order_id
