use hahn;
PRAGMA yt.InferSchema = '10';
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
}; 

$seconds_to_dttm = ($seconds) -> {
    return cast(cast(Datetime::FromSeconds($time_cast($seconds)) as Datetime) as string)
};

$start_dt = '2021-03-01';

$planned_transfers = 
SELECT
    distinct
          request_id 
          , external_order_id
    from
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/planned_transfers_history", "2021-08-20")
;

$operator_events_delivered = 
SELECT 
    external_order_id
    , operator_id
    , max(operator_event_type) as operator_event_type
    , max($seconds_to_dttm(event_instant)) as event_instant_dttm
    from
    range("//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history", "2021-08-20")
where 
    operator_event_type = 'delivered'
group by 
    external_order_id
    , operator_id
;

$lavka_id = 
select DISTINCT 
    external_order_id
    , lavka_order_id
from(
select 
    id as external_order_id
    , SOME(Yson::ConvertToString(Yson::YPath(Yson::Parse(items), '/0/status_meta/order_id'))) as lavka_order_id
from 
    range("//home/lavka/production/replica/postgres/tristero_parcels/orders" , "2021-06")
group by 
    id
union all
select 
id as external_order_id
    , SOME(Yson::ConvertToString(Yson::YPath(Yson::Parse(items), '/0/item_history/-3/meta/order_id'))) as lavka_order_id
from 
    range("//home/lavka/production/replica/postgres/tristero_parcels/orders" , "2021-06")
group by 
    id
)
where external_order_id is not null
; 

$k2_base = 
SELECT
    distinct 

    d.request_code as request_code
    , p.external_order_id as external_order_id
    , case when d.operator_id = 'lavka' then false else true end as market_on_demand_market_pickup_delivery_flg
    , case when d.operator_id = 'lavka' then true else false end as market_on_demand_lavka_delivery_flg
    --, d.claim_status
    , o.external_order_id
    , o.operator_id
    , o.operator_event_type as operator_event_type
    , o.event_instant_dttm as event_instant_dttm
FROM `//home/taxi-delivery/analytics/production/k2/time_slots_logplathform` as d
left join 
    $planned_transfers as p 
    on p.request_id = d.request_id
left join 
    $operator_events_delivered as o 
    on o.external_order_id = p.external_order_id
--and d.claim_status not in ('cancelled_by_taxi', 'performer_not_found')
;

$lavka = 
select 
    cast(active_zone_name as string)  as active_zone_name
    , k.request_code as market_order_id
    , application_platform
    , cancel_reason_type
    , dm.claim_id as claim_id
    , confirmed_flg
    , courier_type
    , cte_dur_sec
    , currency_code
    , currency_rate_rub
    , delivery_cost_lcy
    , delivery_type
    , dispatch_cargo_status
    , local_claim_created_dttm as msk_claim_created_dttm
    , local_created_dttm as msk_created_dttm
    , local_delivered_dttm as msk_delivered_dttm
    , offer_id
    , dm.order_id as order_id
    , order_item_cnt
    , order_item_cost_w_vat_lcy
    , order_location_lat
    , order_location_lon
    , place_address_short
    , region_name
    , user_cost_w_vat_lcy
    , user_id
    , unique_item_cnt
    , parcel_market_cnt
    , parcel_market_flg
    , payment_type
    , external_id
    , order_item_cost_vat_lcy
    , case
        when executor_tariff_class_code = 'eda' then 'lavka'
        else executor_tariff_class_code end as executor_tariff_class_code
    , taxi_order_flg
    , order_item_cnt as delivered_items_count
    , o.first_order_flg as first_order_flg
    , 'lavka'             as pickup_or_lavka
    , k.operator_event_type as operator_event_type
    , k.event_instant_dttm as event_instant_dttm

from 
    (select distinct external_order_id 
    , market_on_demand_lavka_delivery_flg
    , operator_event_type
    , event_instant_dttm
    , request_code
     from $k2_base
    ) as k 
left join 
    $lavka_id as l 
    on l.external_order_id = k.external_order_id
left join 
    range("//home/eda-dwh/cdm/order/dm_lavka_order", "2021") as dm
    on l.lavka_order_id = dm.order_id
left join 
    (select distinct claim_id, taxi_order_id from
    range("//home/delivery-dwh/ods/cargo_claims/claim", "2021-01-01")) as c 
    on dm.claim_id = c.claim_id
left join 
    (select distinct order_id, first_order_flg from range("//home/taxi-dwh/cdm/marketplace/fct_order", $start_dt)) as o
    on o.order_id = c.taxi_order_id  
where k.market_on_demand_lavka_delivery_flg
and dispatch_cargo_status <> 'returned_finish'
;


$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S")
;
$datetime_parse_2 = DateTime::Parse("%Y-%m-%dT%H:%M:%SZ")
;

$format = DateTime::Format("%Y-%m-%d %H:%M:%S");


$pickup_market = 
SELECT
    'pickup-market' as active_zone_name
    , k.request_code as market_order_id
    , app_platform_name
    , Yson::YPathString(cancel_reason_list, '/0') as cancel_reason_type
    , c.id as claim_id
    , case
        when success_order_flg = True and status = 'delivered_finish' then True
        else False end as confirmed_flg
    , 'courier' as courier_type
    , 1.0 * order_completion_time_mnt * 60 as cte_dur_sec
    , 'RUB' as currency_code
    , currency_rate as currency_rate_rub
    , order_cost as delivery_cost_lcy
    , 'cargo_dispatch' as delivery_type
    , status as dispatch_cargo_status
    , cast(DateTime::MakeDate(DateTime::FromSeconds(cast(c.created_ts as Uint32))) + Interval('PT3H') as string) as msk_claim_created_dttm
    , msk_order_created_dttm as msk_created_dttm
    , $format($datetime_parse_2($seconds_to_dttm(DateTime::ToSeconds(DateTime::MakeDate($datetime_parse(msk_order_created_dttm))) + (60.0 * order_completion_time_mnt))
     )) as msk_delivered_dttm
    , offer_id
    , order_id
    , 1 as order_item_cnt
    , 0 as order_item_cost_w_vat_lcy
    , null as order_location_lat
    , null as order_location_lon
    , destination_plan_address as place_address_short
    , agglomeration_name_ru as region_name
    , user_w_vat_cost as user_cost_w_vat_lcy
    , user_client_id as user_id
    , 1 as unique_item_cnt
    , 1 as parcel_market_cnt
    , True as parcel_market_flg
    , fact_payment_type as payment_type
    , c.taxi_order_id as external_id
    , 0 as order_item_cost_vat_lcy
    , 'courier' as executor_tariff_class_code
    , True as taxi_order_flg
    , 1 as delivered_items_count
    , first_order_flg
    , 'pickup_market' as pickup_or_lavka
    , k.operator_event_type as operator_event_type
    , k.event_instant_dttm as event_instant_dttm
from 
    $k2_base as k
left join 
    `//home/taxi/production/replica/postgres/cargo_claims/claims` as c  
    on c.uuid_id = k.external_order_id
left join
    range("//home/taxi-dwh/cdm/marketplace/fct_order", $start_dt) as o
    on o.order_id = c.taxi_order_id
where 
    k.market_on_demand_market_pickup_delivery_flg
    and status <> 'returned_finish'
;

insert into 
`//home/taxi-delivery/analytics/production/k2/ts_defect_rate`
WITH TRUNCATE 
SELECT 
*
from 
$lavka 
union all 
select 
* 
from 
$pickup_market
;
