use hahn;
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$format = DateTime::Format("%Y-%m-%d");

$raw = (SELECT
            item_id,
            $format(DateTime::FromSeconds(cast(created as Uint32))) as created_dt,
            title,
            store_id,
            external_id,
            Yson::ConvertToList(barcode)    AS barcode,
            status
    FROM `home/lavka/production/replica/postgres/wms/items`
    where type = 'parcel'
 );
$raw_ = (
    select raw.*
        from $raw as raw
    flatten list by barcode
);

$order =
(
select
    order_id,
    created,
    updated,
    external_id,
    store_id,
    required,
    status,
    type,
    Yson::ConvertToString(required.item_id)                    as product_id,
    Yson::ConvertToInt64(required.`count`)                     as `count`,
    coalesce(Yson::ConvertToInt64(required.`result_count`), 0) as result_count,
    from(
        select
        order_id,
        created,
        updated,
        external_id,
        store_id,
        status,
        type,
        Yson::ConvertToList(Yson::ParseJson(Yson::ConvertToString(required))) as required
        from `//home/lavka/production/replica/postgres/wms/orders` as orders
        where type in ["acceptance","shipment","order","refund"]
        ) as q
-- where Yson::ConvertTo(required.item_id) is not null
FLATTEN LIST BY required
)
;

$base =
(
select order_id,
    product_id,
    case when type = 'acceptance' and status = 'complete' and result_count = 1 then updated else null end as accepted_dttm,
    case when type = 'order' and status = 'complete' and count = 1 then updated else null end as ordered_dttm,
    case when type = "shipment" and status = 'complete' and result_count = 1 then updated else null end as shipment_dttm,
    case when type = "refund" then updated else null end as refund_dttm
from $order
where product_id is not null
-- group by order_id, product_id
)
;

$turnover_semifinal =
(
select product_id,
    max(accepted_dttm) as accepted_dttm,
    max(ordered_dttm) as ordered_dttm,
    max(shipment_dttm) as shipment_dttm,
    max(refund_dttm) as refund_dttm
from $base
group by product_id
-- order by product_id
)
;

$turnover_final =
(
select product_id,
        accepted_dttm,
        $format(DateTime::FromSeconds(cast(accepted_dttm as Uint32))) as accepted_dt,
        ordered_dttm,
        shipment_dttm,
        refund_dttm,
        1.0 * (case when ordered_dttm is not null then ordered_dttm - accepted_dttm
        when ordered_dttm is null and shipment_dttm is not null then shipment_dttm - accepted_dttm
        else Null
        end)/3600 as turnover_h_all,
        1.0 * if(ordered_dttm is not null and refund_dttm is null, ordered_dttm - accepted_dttm, null) / 3600 as turnover_h_ordered,
        1.0* (case when ordered_dttm is null and shipment_dttm is not null
                then shipment_dttm - accepted_dttm else Null
            end)/3600 as turnover_h_back_to_beru,
        case when refund_dttm is not null then True else False end as refund_flg,
        case when ordered_dttm is null and shipment_dttm is not null then True else False end as back_to_beru_flg
from $turnover_semifinal
where accepted_dttm is not null
)
;

-- INSERT INTO  `//home/taxi-analytics/alena-lukina/courier20/turnover_base`
INSERT INTO `//home/taxi-delivery/analytics/production/k2/turnover_base`
WITH TRUNCATE
select *
from $raw_ as raw
    join $turnover_final as raw_orders
        on  raw.item_id = raw_orders.product_id
    left join (select distinct store_id, address, external_id as lavka_ext_id, title as lavka_title,
    location, cluster as city
    from `//home/lavka/production/replica/postgres/wms/stores`
    ) as stores on raw.store_id = stores.store_id
;
