-- СТАРЫЙ КОД ОТНОСИТЕЛЬНО ПОИСКА САЙТА! Сейчас \order считается по-другому

-- заказы из \order
select
    utc_order_dt,
    payment_type,
    count (distinct order_id) as orders
from summary.dm_order
where utc_order_dt >= '2021-06-01'
    and application_platform = 'light_business'
    and payment_type = 'card'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
group by 1, 2
order by utc_order_dt;


-- чек того, что такое app. остановимся на order_source = 'yandex'
select
    distinct order_source,
    application_platform,
    utc_order_dt,
    count (distinct order_id) as orders
from summary.dm_order
where utc_order_dt >= '2021-06-10'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and order_source = 'yandex'
group by 1, 2, 3
order by utc_order_dt, application_platform;








-- сколько ордеров через /ордер
-- заказы из \order
select
    date_trunc('day', utc_order_dt):: date as day,
    -- success_order_flg,
    order_cancel_reason,
    count (distinct order_id) as orders
from summary.dm_order
where utc_order_dt >= '2020-07-01'
    and application_platform = 'light_business'
    and payment_type = 'card'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and not success_order_flg
group by 1, 2
order by 1;


-- MAU из \order
select
    date_trunc('month', utc_order_dt):: date as week,
    count (distinct user_phone_pd_id) as orders
from summary.dm_order
where utc_order_dt >= '2020-07-01'
    and application_platform = 'light_business'
    and payment_type = 'card'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
group by 1
order by 1;


-- ОСНОВНОЕ
-- Newbies и Old из \order
drop table if exists t1;
CREATE TEMP TABLE t1 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_all
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t1;


drop table if exists t2;
CREATE TEMP TABLE t2 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_order
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and application_platform = 'light_business'
        and payment_type = 'card'
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t2;


drop table if exists t3;
CREATE TEMP TABLE t3 as
select
    t2.user_phone_pd_id as user_phone_pd_id,
    t1.min_date_all as min_date_all,
    t2.min_date_order as min_date_order
from t2 as t2
left join t1 as t1 on t1.user_phone_pd_id = t2.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE t3;


drop table if exists t4;
CREATE TEMP TABLE t4 as
select
    t3.*,
    case
        when min_date_all = min_date_order then 'Newbie'
        else 'Old' end as flag
from t3
DISTRIBUTED RANDOMLY;
ANALYZE t4;


drop table if exists t5;
CREATE TEMP TABLE t5 as
select
    date_trunc('month', min_date_order):: date as month,
    flag,
    count (distinct user_phone_pd_id) as users
from t4
where flag = 'Newbie'
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE t5;


select *
from t5
order by month;








-- Newbies - это SMB?
drop table if exists a;
CREATE TEMP TABLE a as
select
    distinct user_phone_pd_id,
    date_trunc('day', min_date_order):: date as day
from t4
where flag = 'Old'
-- where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE a;


drop table if exists b;
CREATE TEMP TABLE b as
select
    a.*,
    dm.user_id,
    tier4.datefrom
from a
left join summary.dm_order as dm on dm.user_phone_pd_id = a.user_phone_pd_id
left join snb_taxi.niksm_b2b_tier4_user_datefrom as tier4 on tier4.user_id = dm.user_id
where dm.order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
    and dm.utc_order_dt::date between '2019-01-01' and '2021-06-21'
DISTRIBUTED RANDOMLY;
ANALYZE b;


drop table if exists c;
CREATE TEMP TABLE c as
select
    count (distinct user_phone_pd_id) as users
from b
where datefrom is not null and day >= datefrom
DISTRIBUTED RANDOMLY;
ANALYZE c;


select *
from c;








-- какая частотность у Newbies? до дня
drop table if exists a;
CREATE TEMP TABLE a as
select
    distinct user_phone_pd_id,
    date_trunc('day', min_date_order):: date as day
from t4
where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE a;


-- добавляем ордеры
drop table if exists b;
CREATE TEMP TABLE b as
select
    distinct user_phone_pd_id,
    date_trunc('day', utc_order_dt):: date as day,
    count (distinct order_id) as orders
from summary.dm_order
where user_phone_pd_id in (select distinct user_phone_pd_id from a)
    and utc_order_dt between '2020-07-01' and '2021-06-21'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE b;


-- добавляем день, когда новичок появился
drop table if exists c;
CREATE TEMP TABLE c as
select
    b.*,
    a.day as min_day
from b
left join a on a.user_phone_pd_id = b.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE c;


-- флаг частотности
drop table if exists d;
CREATE TEMP TABLE d as
select
    *,
    case
        when sum_previous_month_delivery = 1 then '1'
        when sum_previous_month_delivery between 2 and 4 then '2-4'
        when sum_previous_month_delivery >= 5 then '5+'
        when newbie_flg = 'Newbie' and sum_previous_month_delivery is null then 'Newbie' -- не было доставок в течение 30 предыдущих дней
        when newbie_flg = 'Old' and sum_previous_month_delivery is null then 'No del in prev 30 days' -- не было доставок в течение 30 предыдущих дней
        else 'Other' end as frequency_flag
from (select
        c.*,
        case
            when day = min_day then 'Newbie'
                else 'Old' end as newbie_flg,
        sum (c.orders) over
        (partition by c.user_phone_pd_id
        order by c.day
        range between 30 preceding and 1 preceding) as sum_previous_month_delivery
        from c) as test
DISTRIBUTED RANDOMLY;
ANALYZE d;


-- группируем, тут до дня
drop table if exists f;
CREATE TEMP TABLE f as
select
    day,
    newbie_flg,
    frequency_flag,
    count (distinct user_phone_pd_id) as users
from d
group by 1, 2, 3
DISTRIBUTED RANDOMLY;
ANALYZE f;








-- какая частотность у Newbies? до месяца
drop table if exists a;
CREATE TEMP TABLE a as
select
    distinct user_phone_pd_id,
    date_trunc('month', min_date_order):: date as month
from t4
where flag = 'Old'
-- where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE a;


-- добавляем ордеры
drop table if exists b;
CREATE TEMP TABLE b as
select
    distinct user_phone_pd_id,
    date_trunc('month', utc_order_dt):: date as month,
    count (distinct order_id) as orders
from summary.dm_order
where user_phone_pd_id in (select distinct user_phone_pd_id from a)
    and utc_order_dt between '2019-03-01' and '2021-06-21'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE b;


-- добавляем день, когда новичок появился
drop table if exists c;
CREATE TEMP TABLE c as
select
    b.*,
    a.month as min_month
from b
left join a on a.user_phone_pd_id = b.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE c;


-- флаг частотности
drop table if exists d;
CREATE TEMP TABLE d as
select
    *,
    case
        when orders = 1 then '1'
        when orders between 2 and 4 then '2-4'
        when orders >= 5 then '5+'
        when newbie_flg = 'Newbie' and orders is null then 'Newbie' -- не было доставок в течение 30 предыдущих дней
        when newbie_flg = 'Old' and orders is null then 'No del in prev 30 days' -- не было доставок в течение 30 предыдущих дней
        else 'Other' end as frequency_flag
from (select
        user_phone_pd_id,
        case
            when month = min_month then 'Newbie'
                else 'Old' end as newbie_flg,
        month,
        sum (orders) as orders
        from c
        group by 1, 2, 3) as test
DISTRIBUTED RANDOMLY;
ANALYZE d;


-- группируем, тут до месяца
drop table if exists f;
CREATE TEMP TABLE f as
select
    month,
    frequency_flag,
    count (distinct user_phone_pd_id) as users
from d
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE f;


select *
from f
order by month;








-- какой средний срок жизни у Newbies/Old?
drop table if exists a;
CREATE TEMP TABLE a as
select
    distinct user_phone_pd_id,
    date_trunc('month', min_date_all):: date as min_month
    -- date_trunc('month', min_date_order):: date as min_month
from t4
-- where flag = 'Old'
-- where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE a;


-- добавляем dm_order
drop table if exists b;
CREATE TEMP TABLE b as
select
    distinct user_phone_pd_id,
    date_trunc('month', utc_order_dt):: date as month
    -- count (distinct order_id) as orders
from summary.dm_order
where user_phone_pd_id in (select distinct user_phone_pd_id from a)
    and utc_order_dt >= '2019-03-01'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
DISTRIBUTED RANDOMLY;
ANALYZE b;


/* -- находим последний месяц с доставками у Newbies
drop table if exists c;
CREATE TEMP TABLE c as
select
    b.*,
    last_value (month) over
        (partition by
            user_phone_pd_id
        order by month
        range between unbounded preceding and unbounded following) as last_month
from b
DISTRIBUTED RANDOMLY;
ANALYZE c;*/


-- соединяем первый месяц и последний месяц
drop table if exists d;
CREATE TEMP TABLE d as
select
    a.user_phone_pd_id,
    a.min_month,
    b.month
from a
left join b on a.user_phone_pd_id = b.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE d;


-- находим разницу в месяцах
drop table if exists f;
CREATE TEMP TABLE f as
select
    d.*,
    (date_part('year', month) - date_part('year', min_month)) * 12 + date_part('month', month) - date_part('month', min_month) AS age_month
from d
DISTRIBUTED RANDOMLY;
ANALYZE f;


-- считаем кол-во юзеров по минимальному и максимальному месяцу
drop table if exists g;
CREATE TEMP TABLE g as
select
    min_month,
    age_month,
    count (distinct user_phone_pd_id) as users
from f
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE g;


select *
from g
order by min_month;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- какой средний LTV у Newbies/Old?
drop table if exists a;
CREATE TEMP TABLE a as
select
    distinct user_phone_pd_id,
    date_trunc('month', min_date_all):: date as min_month
    -- date_trunc('month', min_date_order):: date as min_month
from t4
-- where flag = 'Old'
-- where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE a;


-- добавляем dm_order
drop table if exists b;
CREATE TEMP TABLE b as
select
    distinct user_phone_pd_id,
    date_trunc('month', utc_order_dt):: date as month,
    sum(net_inflow * currency_rate) as net_inflow,
    sum(order_cost * currency_rate) as gmv,
    count (distinct order_id) as orders
from summary.dm_order
where user_phone_pd_id in (select distinct user_phone_pd_id from a)
    and utc_order_dt >= '2019-03-01'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE b;


/* -- находим последний месяц с доставками у Newbies
drop table if exists c;
CREATE TEMP TABLE c as
select
    b.*,
    last_value (month) over
        (partition by
            user_phone_pd_id
        order by month
        range between unbounded preceding and unbounded following) as last_month
from b
DISTRIBUTED RANDOMLY;
ANALYZE c;*/

                                          
-- соединяем первый месяц и последний месяц
drop table if exists d;
CREATE TEMP TABLE d as
select
    a.user_phone_pd_id,
    a.min_month,
    b.month,
    b.net_inflow,
    b.gmv,
    b.orders
from a
left join b on a.user_phone_pd_id = b.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE d;

select *
from d
order by user_phone_pd_id;

                                          
                                          
-- находим разницу в месяцах
drop table if exists f;
CREATE TEMP TABLE f as
select
    d.*,
    (date_part('year', month) - date_part('year', min_month)) * 12 + date_part('month', month) - date_part('month', min_month) AS age_month
from d
DISTRIBUTED RANDOMLY;
ANALYZE f;


-- считаем кол-во денег по минимальному и максимальному месяцу
drop table if exists g;
CREATE TEMP TABLE g as
select
    min_month,
    age_month,
    count (distinct user_phone_pd_id) as users,
    sum (net_inflow) as net_inflow,
    sum (gmv) as gmv,
    sum (orders) as orders
from f
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE g;


select *
from g
order by min_month;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- Переток Newbies в другие каналы
-- ОСНОВНОЕ
-- Newbies и Old из \order
drop table if exists t1;
CREATE TEMP TABLE t1 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_all
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t1;


drop table if exists t2;
CREATE TEMP TABLE t2 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_order
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and application_platform = 'light_business'
        and payment_type = 'card'
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t2;


drop table if exists t3;
CREATE TEMP TABLE t3 as
select
    t2.user_phone_pd_id as user_phone_pd_id,
    t1.min_date_all as min_date_all,
    t2.min_date_order as min_date_order
from t2 as t2
left join t1 as t1 on t1.user_phone_pd_id = t2.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE t3;


drop table if exists t4;
CREATE TEMP TABLE t4 as
select
    t3.*,
    case
        when min_date_all = min_date_order then 'Newbie'
        else 'Old' end as flag
from t3
DISTRIBUTED RANDOMLY;
ANALYZE t4;


-- сейчас фильтруем Новичков
drop table if exists t5;
CREATE TEMP TABLE t5 as
select *
from t4
where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE t5;


-- раньше ноября нет новичков
-- сейчас смотрим, где были заказы у новичков
drop table if exists next;
CREATE TEMP TABLE next as
select
    dm.user_phone_pd_id,
    dm.order_id,
    dm.utc_order_dttm,
    case
        when dm.application_platform = 'light_business' and payment_type = 'card' then '\order'
        when dm.order_source = 'yandex' then 'app'
        when dm.order_id in (select distinct taxi_order_id from analyst.diskhakova_personal_account_orders) then 'personal account'
        else 'other' end as channel
from summary.dm_order as dm
where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
    and success_order_flg
    and not fake_order_flg
    and utc_order_dt::date between '2020-07-01' and '2021-06-21'
    and user_phone_pd_id in (select distinct user_phone_pd_id from t5)
DISTRIBUTED RANDOMLY;
ANALYZE next;


-- смотрим, где были заказы сразу после сайта
drop table if exists next_more;
CREATE TEMP TABLE next_more as
select
    next.*,
    t4.min_date_order
from next
left join t4 on t4.user_phone_pd_id = next.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE next_more;


-- оставляем только те, что после order (ставим флаг)
drop table if exists next_only;
CREATE TEMP TABLE next_only as
select *
from next_more
where utc_order_dttm > min_date_order
DISTRIBUTED RANDOMLY;
ANALYZE next_only;


-- ставим флаг следующего за \order приложения
drop table if exists next_app;
CREATE TEMP TABLE next_app as
select
    next_only.*,
    first_value (channel) over
        (partition by
            user_phone_pd_id
        order by utc_order_dttm
        range between unbounded preceding and unbounded following) as first_channel
from next_only
DISTRIBUTED RANDOMLY;
ANALYZE next_app;


-- первый следующий заказ
drop table if exists next_app_newbies;
CREATE TEMP TABLE next_app_newbies as
select
    date_trunc('month', min_date_order):: date as month,
    channel,
    -- first_channel,
    count (distinct user_phone_pd_id) as newbies
from next_app
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE next_app_newbies;

select *
from next_app_newbies
order by month;


-- считаем доставки
drop table if exists next_all_app_newbies;
CREATE TEMP TABLE next_all_app_newbies as
select
    -- date_trunc('month', min_date_order):: date as month,
    case
        when date_trunc('month', min_date_order):: date < '2021-02-01' then 'before 2021-02-01'
        else 'after 2021-02-01' end as month,
    first_channel,
    count (distinct user_phone_pd_id) as orders
from next_app
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE next_all_app_newbies;


select *
from next_all_app_newbies
order by month;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- Переток Old в другие каналы
-- ОСНОВНОЕ
-- Newbies и Old из \order
drop table if exists t1;
CREATE TEMP TABLE t1 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_all
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t1;


drop table if exists t2;
CREATE TEMP TABLE t2 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_order
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and application_platform = 'light_business'
        and payment_type = 'card'
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t2;


drop table if exists t3;
CREATE TEMP TABLE t3 as
select
    t2.user_phone_pd_id as user_phone_pd_id,
    t1.min_date_all as min_date_all,
    t2.min_date_order as min_date_order
from t2 as t2
left join t1 as t1 on t1.user_phone_pd_id = t2.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE t3;


drop table if exists t4;
CREATE TEMP TABLE t4 as
select
    t3.*,
    case
        when min_date_all = min_date_order then 'Newbie'
        else 'Old' end as flag
from t3
DISTRIBUTED RANDOMLY;
ANALYZE t4;


-- сейчас фильтруем Старых
drop table if exists t5;
CREATE TEMP TABLE t5 as
select *
from t4
where flag = 'Old'
DISTRIBUTED RANDOMLY;
ANALYZE t5;


-- сейчас смотрим, где были заказы у старичков
drop table if exists next;
CREATE TEMP TABLE next as
select
    dm.user_phone_pd_id,
    dm.order_id,
    dm.utc_order_dttm,
    case
        when dm.application_platform = 'light_business' and payment_type = 'card' then '\order'
        when dm.order_source = 'yandex' then 'app'
        when dm.order_id in (select distinct taxi_order_id from analyst.diskhakova_personal_account_orders) then 'personal account'
        else 'other' end as channel
from summary.dm_order as dm
where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
    and success_order_flg
    and not fake_order_flg
    and utc_order_dt::date between '2019-03-01' and '2021-06-21'
    and user_phone_pd_id in (select distinct user_phone_pd_id from t5)
DISTRIBUTED RANDOMLY;
ANALYZE next;


-- смотрим, где были заказы перед сайтом
drop table if exists next_more;
CREATE TEMP TABLE next_more as
select
    next.*,
    t4.min_date_order
from next
left join t4 on t4.user_phone_pd_id = next.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE next_more;

                                          
                                          
-- оставляем только те, что ДО/После order
drop table if exists next_only;
CREATE TEMP TABLE next_only as
select *
from next_more
where utc_order_dttm > min_date_order
DISTRIBUTED RANDOMLY;
ANALYZE next_only;

                                          
-- ставим флаг приложения перед \order
drop table if exists next_app;
CREATE TEMP TABLE next_app as
select
    next_only.*,
    first_value (channel) over
        (partition by
            user_phone_pd_id
        order by utc_order_dttm
        range between unbounded preceding and unbounded following) as first_channel
from next_only
DISTRIBUTED RANDOMLY;
ANALYZE next_app;


-- последний заказ перед сайтом
drop table if exists next_app_newbies;
CREATE TEMP TABLE next_app_newbies as
select
    date_trunc('month', min_date_order):: date as month,
    channel,
    -- count (distinct order_id) as orders
    -- first_channel,
    count (distinct user_phone_pd_id) as newbies
from next_app
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE next_app_newbies;


select *
from next_app_newbies
order by month;


drop table if exists next_all_app_newbies;
CREATE TEMP TABLE next_all_app_newbies as
select
    -- date_trunc('month', min_date_order):: date as month,
    case
        when date_trunc('month', min_date_order):: date < '2021-04-01' then 'before 2021-04-01'
        else 'after 2021-04-01' end as month,
    channel,
    count (distinct order_id) as orders
from next_app
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE next_all_app_newbies;


select *
from next_all_app_newbies
order by month;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- какой средний LTV в приложении?
-- добавляем dm_order
drop table if exists b;
CREATE TEMP TABLE b as
select
    distinct user_phone_pd_id,
    date_trunc('month', utc_order_dt):: date as month,
    sum(net_inflow * currency_rate) as net_inflow,
    sum(order_cost * currency_rate) as gmv,
    count (distinct order_id) as orders
from summary.dm_order
where utc_order_dt >= '2019-03-01'
    and order_tariff in ('express', 'courier', 'cargo', 'cargocorp')
    and success_order_flg
    and order_source = 'yandex'
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE b;


-- соединяем первый месяц и последний месяц
drop table if exists d;
CREATE TEMP TABLE d as
select
    *,
    first_value (month) over
        (partition by
                user_phone_pd_id
        order by month
        range between unbounded preceding and unbounded following) as first_month
from b
DISTRIBUTED RANDOMLY;
ANALYZE d;


-- находим разницу в месяцах
drop table if exists f;
CREATE TEMP TABLE f as
select
    d.*,
    (date_part('year', month) - date_part('year', first_month)) * 12 + date_part('month', month) - date_part('month', first_month) AS age_month
from d
DISTRIBUTED RANDOMLY;
ANALYZE f;


-- считаем кол-во денег по минимальному и максимальному месяцу
drop table if exists g;
CREATE TEMP TABLE g as
select
    first_month,
    age_month,
    count (distinct user_phone_pd_id) as users,
    sum (net_inflow) as net_inflow,
    sum (gmv) as gmv,
    sum (orders) as orders
from f
group by 1, 2
DISTRIBUTED RANDOMLY;
ANALYZE g;

                                          
select *
from g
order by first_month;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- какая тарифная зона заказов у Новичков order?
-- Newbies и Old из \order
drop table if exists t1;
CREATE TEMP TABLE t1 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_all
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t1;


drop table if exists t2;
CREATE TEMP TABLE t2 as
    select
        user_phone_pd_id,
        min(utc_order_dttm) as min_date_order
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and success_order_flg
        and not fake_order_flg
        and application_platform = 'light_business'
        and payment_type = 'card'
        and utc_order_dt::date between '2019-01-01' and '2021-06-21' /*(current_date - interval '1 day')*/
    group by 1
DISTRIBUTED RANDOMLY;
ANALYZE t2;


drop table if exists t3;
CREATE TEMP TABLE t3 as
select
    t2.user_phone_pd_id as user_phone_pd_id,
    t1.min_date_all as min_date_all,
    t2.min_date_order as min_date_order
from t2 as t2
left join t1 as t1 on t1.user_phone_pd_id = t2.user_phone_pd_id
DISTRIBUTED RANDOMLY;
ANALYZE t3;


drop table if exists t4;
CREATE TEMP TABLE t4 as
select
    t3.*,
    case
        when min_date_all = min_date_order then 'Newbie'
        else 'Old' end as flag
from t3
DISTRIBUTED RANDOMLY;
ANALYZE t4;


-- сейчас фильтруем Новичков
drop table if exists t5;
CREATE TEMP TABLE t5 as
select *
from t4
where flag = 'Newbie'
DISTRIBUTED RANDOMLY;
ANALYZE t5;


-- раньше ноября нет новичков
-- сейчас смотрим, где были заказы у новичков
drop table if exists next;
CREATE TEMP TABLE next as
select
    dm.order_id,
    dm.tariff_zone
from summary.dm_order as dm
where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
    and success_order_flg
    and not fake_order_flg
    and utc_order_dt::date between '2020-10-01' and '2021-06-21'
    and user_phone_pd_id in (select distinct user_phone_pd_id from t5)
DISTRIBUTED RANDOMLY;
ANALYZE next;


select
    case
        when tariff_zone = 'moscow' then 'moscow'
        else 'other' end as zone,
    count (distinct order_id) as orders
from next
group by 1
order by 2 desc;


-- какая тарифная зона итого в аппе?
drop table if exists next;
CREATE TEMP TABLE next as
select
    dm.order_id,
    dm.tariff_zone
from summary.dm_order as dm
where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
    and success_order_flg
    and not fake_order_flg
    and utc_order_dt::date between '2020-10-01' and '2021-06-21'
    and order_source = 'yandex'
DISTRIBUTED RANDOMLY;
ANALYZE next;


select
    case
        when tariff_zone = 'moscow' then 'moscow'
        else 'other' end as zone,
    count (distinct order_id) as orders
from next
group by 1
order by 2 desc;

                                          
                                          
                                          
                                          
                                          
                                          
                                          
-- какая причина не успешности заказа
drop table if exists t1;
CREATE TEMP TABLE t1 as
    select
        CASE
            when driver_id is null then 'no drivers'
            else 'drivers ok' end as drivers,
        status,
        taxi_status,
        order_cancel_reason,
        count (distinct order_id) as orders
    from summary.dm_order
    where order_tariff in ('cargo', 'express', 'courier', 'cargocorp')
        and not fake_order_flg
        and not success_order_flg
        and application_platform = 'light_business'
        and payment_type = 'card'
        and utc_order_dt::date between '2020-07-05' and '2021-06-21'
group by 1, 2, 3, 4
DISTRIBUTED RANDOMLY;
ANALYZE t1;


select *
from t1
order by 1;
