USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;

$start_days = 30;
$comms_from_dt = cast(CurrentUtcDate() - DateTime::IntervalFromDays($start_days) as string);
$dttm_format = DateTime::Format("%Y-%m-%d %H:%M:%S");
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");


$script = @@
import json
import re
def f(s):
    s = s.decode("unicode-escape")
    pattern = r'(?<=banner\?id=)(.*?)(?=")'
    r1 = re.search(pattern, s)
    return 'None' if r1 is None else r1.group(0) 
@@;

$udf = Python3::f(Callable<(String?)->String?>, $script);


$owner_names = (
    'ruban-nika',
    'alex-zhestkov',
    'ploskymi',
    'yakirgeffen',
    'yulvasilyeva',
    'lizafeo22',
    'alinaskripnik'
);


$prev_logs = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/campaign_logs_final';
$previous = (SELECT * FROM $prev_logs);


$cm_camps_and_groups = (
    SELECT DISTINCT
            cmp.id as campaign_id,
            cmp.name as campaign_name,
            cmp.entity_type as entity_type,
            cmp.ticket as experiment_id,
            grp.id as cm_group_id,
            grp.name as cm_group_name,
            Yson::ConvertToString(grp.params.channel_name) as channel,
            grp.created_at as grp_created,
            cmp.created_at as cm_created,
            crt.name as creative_name,
            cmp.is_regular as is_regular,
            $udf(Yson::ConvertToString(crt.params)) as banner_id
        FROM `//home/taxi/production/replica/postgres/crm_admin/groups_v2` AS grp
        JOIN `//home/taxi/production/replica/postgres/crm_admin/campaigns` AS cmp ON cmp.segment_id == grp.segment_id
        JOIN `//home/taxi/production/replica/postgres/crm_admin/creative` AS crt ON grp.creative_id == crt.id
        WHERE cmp.owner_name IN $owner_names
);


$push_comms_cm_pre = (
    SELECT
        creation_time,
        String::AsciiToLower(exp.channel) AS channel_name,
        grp.campaign_name AS campaign_name,
        grp.campaign_id AS campaign_id,
        exp.experiment_id AS experiment_id,
        exp.group_id AS group_id,
        grp.cm_group_id AS cm_group_id,
        grp.cm_group_name AS cm_group_name,
        exp.properties['application'] AS app_name,
        exp.unic_obj_id AS user_phone_id,
        exp.comm_obj_id AS user_client_id,
        exp.properties['communication_status'] AS cm_comm_status,
        exp.properties['policy_allowed'] AS policy_allowed,
        exp.properties['country'] AS country,
        grp.is_regular as is_regular,
        grp.banner_id as banner_id
    FROM range(`//home/taxi-crm/production/experiments`, $comms_from_dt) AS exp
    INNER JOIN $cm_camps_and_groups AS grp
        ON grp.experiment_id == exp.experiment_id
        AND exp.group_name == grp.cm_group_name
    WHERE String::AsciiToLower(exp.channel) == 'push'
        AND exp.properties['application'] != 'yango_deli'
);


$push_comms_cm = (
    SELECT
        experiment_id,
        user_phone_id,
        MIN(creation_time) as creation_time,
        MIN_BY(channel_name, creation_time) as channel_name,
        MIN_BY(campaign_name, creation_time) as campaign_name,
        MIN_BY(campaign_id, creation_time) as campaign_id,
        MIN_BY(group_id, creation_time) as group_id,
        MIN_BY(cm_group_id, creation_time) as cm_group_id,
        MIN_BY(cm_group_name, creation_time) as cm_group_name,
        MIN_BY(app_name, creation_time) as app_name,
        MIN_BY(user_client_id, creation_time) as user_client_id,
        MIN_BY(cm_comm_status, creation_time) as cm_comm_status,
        MIN_BY(policy_allowed, creation_time) as policy_allowed,
        MIN_BY(banner_id, creation_time) as banner_id,
        MIN_BY(is_regular, creation_time) as is_regular,
        SOME(country) as country
    FROM $push_comms_cm_pre
    GROUP BY experiment_id, user_phone_id
);


$push_comms_infra = (
    SELECT DISTINCT 
        Yson::ConvertToString((Yson::ParseJson(pld.provider_payload)).payload.id) AS push_bulk_id,
        snt.intent AS intent,
        Yson::ConvertToInt64((Yson::ParseJson(snt.meta)).campaign_id) AS campaign_id,
        Yson::ConvertToInt64((Yson::ParseJson(snt.meta)).group_id) AS cm_group_id,
        snt.user_id AS user_client_id,
        snt.status AS sending_status,
        $dttm_format(DateTime::MakeDatetime($datetime_parse(snt.iso_eventtime)) - interval("PT3H")) AS utc_sending_status_dttm,
        dlv.status AS delivery_status,
        $dttm_format(DateTime::FromMicroseconds(cast(dlv.created AS uint64) / 1000)) AS utc_delivery_status_dttm
    FROM (
        SELECT *
        FROM range(`//home/logfeller/logs/taxi-ucommunications-user-notfications-push-log/1d`, $comms_from_dt)
    ) AS snt
    LEFT JOIN (
        SELECT *
        FROM range(`//home/logfeller/logs/taxi/production/taxi-ucommunications-user-notifications-push-payload-log/1d`, $comms_from_dt)
    ) AS pld
        ON snt.notification_id == pld.notification_id
    LEFT JOIN (
        SELECT *
        FROM range(`//home/logfeller/logs/taxi-ucommunications-user-notfications-push-status-log/1d`, $comms_from_dt)
    ) AS dlv
        ON snt.notification_id == Substring(dlv.notification_id, 1u + Find(dlv.notification_id, ':'))
    -- where substring(snt.intent, 0, 3) == "crm"
);


$push_comms_product = (
    SELECT
        push_bulk_id,
        user_client_id,
        COUNT_IF(event_name = 'Push.Shown') > 0 AS push_shown_flg,
        MIN(IF(event_name = 'Push.Shown', utc_event_dttm, NULL)) AS utc_push_shown_dttm,
        MIN_BY(event_id, IF(event_name = 'Push.Shown', utc_event_dttm, NULL)) AS push_shown_event_id,
        MIN_BY(session_id, if(event_name = 'Push.Shown', utc_event_dttm, NULL)) as push_shown_session_id,
        COUNT_IF(event_name = 'Push.Tapped') > 0 AS push_tapped_flg,
        min(IF(event_name = 'Push.Tapped', utc_event_dttm, NULL)) AS utc_push_tapped_dttm,
        MIN_BY(event_id, IF(event_name = 'Push.Tapped', utc_event_dttm, NULL)) AS push_tapped_event_id,
        MIN_BY(session_id, IF(event_name = 'Push.Tapped', utc_event_dttm, NULL)) as push_tapped_session_id,
        COUNT_IF(event_name = 'Push.ButtonTapped') > 0 AS push_button_tapped_flg,
        MIN(IF(event_name = 'Push.ButtonTapped', utc_event_dttm, NULL)) AS utc_push_button_tapped_dttm,
        MIN_BY(event_id, IF(event_name = 'Push.ButtonTapped', utc_event_dttm, NULL)) AS push_button_tapped_event_id,
        MIN_BY(session_id, IF(event_name = 'Push.ButtonTapped', utc_event_dttm, NULL)) AS push_button_tapped_session_id,
        COUNT_IF(event_name = 'Push.Dismissed') > 0 AS push_dismissed_flg,
        MIN(IF(event_name = 'Push.Dismissed', utc_event_dttm, NULL)) AS utc_push_dismissed_dttm,
        MIN_BY(event_id, IF(event_name = 'Push.Dismissed', utc_event_dttm, NULL)) AS push_dismissed_event_id,
        MIN_BY(session_id, IF(event_name = 'Push.Dismissed', utc_event_dttm, NULL)) AS push_dismissed_session_id
    from RANGE(`//home/taxi-dwh/ods/appmetrica/taxi`, $comms_from_dt)
    where event_name IN (
            'Push.Shown',
            'Push.Tapped',
            'Push.ButtonTapped',
            'Push.Dismissed'
        )
        and SUBSTRING(utc_event_dttm, NULL, 10) >= $comms_from_dt
    group by
        user_id as user_client_id,
        Yson::ConvertToString(event_value.push_id)??Yson::ConvertToString(event_value.id) AS push_bulk_id
);


$new_wihout_fs = (
    SELECT
        crm.experiment_id AS experiment_id,
        crm.cm_group_name AS cm_group_name,
        crm.user_phone_id AS user_phone_id,
        SOME(app_name) AS app_name,
        SOME(campaign_name) AS campaign_name,
        SOME(channel_name) AS channel_name,
        SOME(crm.country) AS country,
        MIN(creation_time) AS creation_time,
        MIN(inf.utc_sending_status_dttm) AS utc_sending_status_dttm,
        SOME(crm.policy_allowed) AS policy_allowed,
        SOME(crm.user_client_id) AS user_client_id,
        SOME(group_id) AS group_id,
        SOME(banner_id) AS banner_id,
        SOME(is_regular) AS is_regular,
        IF(ListHas(AGG_LIST_DISTINCT(push_dismissed_flg), TRUE), TRUE, FALSE) AS push_dismissed_flg,
        IF(ListHas(AGG_LIST_DISTINCT(push_shown_flg), TRUE), TRUE, FALSE) AS push_shown_flg,
        IF(ListHas(AGG_LIST_DISTINCT(push_tapped_flg), TRUE), TRUE, FALSE) AS push_tapped_flg,
        IF(ListHas(AGG_LIST_DISTINCT(push_button_tapped_flg), TRUE), TRUE, FALSE) AS push_button_tapped_flg,
        IF(ListHas(AGG_LIST_DISTINCT(inf.sending_status), 'sent') OR 
            ListHas(AGG_LIST_DISTINCT(inf.sending_status), 'sent_noack'), 'sent', NULL) AS sending_status,
        IF(ListHas(AGG_LIST_DISTINCT(inf.delivery_status), 'delivered'), 'delivered', 'expired') AS delivery_status,
    WITHOUT
        crm.cm_group_id,
        crm.campaign_id,
        inf.campaign_id,
        inf.cm_group_id,
        inf.user_client_id,
        app.push_bulk_id,
        inf.push_bulk_id,
        app.user_client_id,
    FROM $push_comms_cm AS crm
    LEFT JOIN $push_comms_infra AS inf
        ON inf.campaign_id == crm.campaign_id
        AND inf.cm_group_id == crm.cm_group_id
        AND inf.user_client_id == crm.user_client_id
    LEFT JOIN $push_comms_product AS app
        ON app.user_client_id == inf.user_client_id
        AND app.push_bulk_id == inf.push_bulk_id
    GROUP BY crm.experiment_id, crm.cm_group_name, crm.user_phone_id
);


$push_comms_product_fs_part = (
    SELECT
        banner_id,
        user_client_id,
        COUNT_IF(event_name == 'FS_RECEIVED') > 0 as fs_received,
        COUNT_IF(event_name == 'FS_SEEN') > 0 as fs_seen,
        COUNT_IF(event_name == 'PromoDidSelectAction') > 0 as fs_selected,
        COUNT_IF(event_name == 'PromoDidReceiveClose') > 0 as fs_closed
    from RANGE(`//home/taxi-dwh/ods/appmetrica/taxi`, $comms_from_dt)
    where event_name IN (
            'FS_RECEIVED',
            'FS_SEEN',
            'PromoDidSelectAction',
            'PromoDidReceiveClose',
        )
        and SUBSTRING(utc_event_dttm, NULL, 10) >= $comms_from_dt
    group by
        Yson::ConvertToString(event_value.banner_id) as banner_id,
        user_id as user_client_id
        );


$new = (
    SELECT
        *
    FROM $new_wihout_fs as nwf
    LEFT JOIN $push_comms_product_fs_part as pcp
    ON nwf.banner_id == pcp.banner_id
    AND nwf.user_client_id ==  pcp.user_client_id
);


$prev = (
    SELECT
        *
    FROM $previous as prev
    LEFT ONLY JOIN $new AS new
    ON new.experiment_id = prev.experiment_id
    AND new.cm_group_name = prev.cm_group_name
    AND new.user_phone_id = prev.user_phone_id
);


$to_insert = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/campaign_logs_final';
INSERT INTO $to_insert
WITH TRUNCATE
SELECT * FROM $new
UNION ALL
SELECT * FROM $prev;
