USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;

$start_days = 30;
$comms_from_dt = cast(CurrentUtcDate() - DateTime::IntervalFromDays($start_days) as string);
$dttm_format = DateTime::Format("%Y-%m-%d %H:%M:%S");
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");


$owner_names = (
    'ruban-nika',
    'alex-zhestkov',
    'ploskymi',
    'yakirgeffen',
    'yulvasilyeva',
    'lizafeo22',
    'alinaskripnik'
);


$prev_logs = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/campaign_logs_final_fs';
$previous = (SELECT * FROM $prev_logs);


$cm_camps_and_groups = (
    SELECT DISTINCT
            cmp.id as campaign_id,
            cmp.name as campaign_name,
            cmp.entity_type as entity_type,
            cmp.ticket as experiment_id,
            grp.id as cm_group_id,
            grp.name as cm_group_name,
            Yson::ConvertToString(grp.params.channel_name) as channel,
            grp.created_at as grp_created,
            cmp.created_at as cm_created,
            crt.name as creative_name,
            cmp.is_regular as is_regular,
            Yson::ConvertToString(Yson::ParseJson(Yson::ConvertToString(crt.params)).content) as banner_id
        FROM `//home/taxi/production/replica/postgres/crm_admin/groups_v2` AS grp
        JOIN `//home/taxi/production/replica/postgres/crm_admin/campaigns` AS cmp ON cmp.segment_id == grp.segment_id
        JOIN `//home/taxi/production/replica/postgres/crm_admin/creative` AS crt ON grp.creative_id == crt.id
        WHERE cmp.owner_name IN $owner_names
);


$push_comms_cm_pre = (
    SELECT
        creation_time,
        String::AsciiToLower(exp.channel) AS channel_name,
        grp.campaign_name AS campaign_name,
        grp.campaign_id AS campaign_id,
        exp.experiment_id AS experiment_id,
        exp.group_id AS group_id,
        grp.cm_group_id AS cm_group_id,
        grp.cm_group_name AS cm_group_name,
        exp.properties['application'] AS app_name,
        exp.unic_obj_id AS user_phone_id,
        exp.comm_obj_id AS user_client_id,
        exp.properties['communication_status'] AS cm_comm_status,
        exp.properties['policy_allowed'] AS policy_allowed,
        exp.properties['country'] AS country,
        grp.is_regular as is_regular,
        grp.banner_id as banner_id
    FROM range(`//home/taxi-crm/production/experiments`, $comms_from_dt) AS exp
    INNER JOIN $cm_camps_and_groups AS grp
        ON grp.experiment_id == exp.experiment_id
        AND exp.group_name == grp.cm_group_name
    WHERE String::AsciiToLower(exp.channel) == 'promo.fs'
        AND exp.properties['application'] != 'yango_deli'
);


$push_comms_cm = (
    SELECT
        experiment_id,
        user_phone_id,
        MIN(creation_time) as creation_time,
        MIN_BY(channel_name, creation_time) as channel_name,
        MIN_BY(campaign_name, creation_time) as campaign_name,
        MIN_BY(campaign_id, creation_time) as campaign_id,
        MIN_BY(group_id, creation_time) as group_id,
        MIN_BY(cm_group_id, creation_time) as cm_group_id,
        MIN_BY(cm_group_name, creation_time) as cm_group_name,
        MIN_BY(app_name, creation_time) as app_name,
        MIN_BY(user_client_id, creation_time) as user_client_id,
        MIN_BY(cm_comm_status, creation_time) as cm_comm_status,
        MIN_BY(policy_allowed, creation_time) as policy_allowed,
        MIN_BY(banner_id, creation_time) as banner_id,
        MIN_BY(is_regular, creation_time) as is_regular,
        SOME(country) as country
    FROM $push_comms_cm_pre
    GROUP BY experiment_id, user_phone_id
);


$push_comms_product_fs_part = (
    SELECT
        banner_id,
        user_client_id,
        COUNT_IF(event_name == 'FS_RECEIVED') > 0 as fs_received,
        COUNT_IF(event_name == 'FS_SEEN') > 0 as fs_seen,
        COUNT_IF(event_name == 'PromoDidSelectAction') > 0 as fs_selected,
        COUNT_IF(event_name == 'PromoDidReceiveClose') > 0 as fs_closed
    from RANGE(`//home/taxi-dwh/ods/appmetrica/taxi`, $comms_from_dt)
    where event_name IN (
            'FS_RECEIVED',
            'FS_SEEN',
            'PromoDidSelectAction',
            'PromoDidReceiveClose',
        )
        and SUBSTRING(utc_event_dttm, NULL, 10) >= $comms_from_dt
    group by
        Yson::ConvertToString(event_value.banner_id) as banner_id,
        user_id as user_client_id
        );


$new = (
    SELECT
        *
    FROM $push_comms_cm as pcc
    LEFT JOIN $push_comms_product_fs_part as pcp
    ON pcc.banner_id == pcp.banner_id
    AND pcc.user_client_id ==  pcp.user_client_id
);


$prev = (
    SELECT
        *
    FROM $previous as prev
    LEFT ONLY JOIN $new AS new
    ON new.experiment_id = prev.experiment_id
    AND new.cm_group_name = prev.cm_group_name
    AND new.user_phone_id = prev.user_phone_id
);


$to_insert = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/campaign_logs_final_fs';
INSERT INTO $to_insert
WITH TRUNCATE
SELECT * FROM $new
UNION ALL
SELECT * FROM $prev;
