USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.MaxRowWeight = "128M";

$day_from_exp = 21;
$start_days = 29;
$start_date = cast(CurrentUtcDate() - DateTime::IntervalFromDays($start_days) as string);
$numer_of_month = 3;
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$start_month = ($x) -> {
    return CAST(DateTime::MakeDate(DateTime::StartOfMonth(DateTime::ShiftMonths($x, -$numer_of_month ))) as string)
};
$get_to_date = ($x) -> {
    return CAST(DateTime::MakeDatetime($datetime_parse($x)) + DateTime::IntervalFromDays($day_from_exp) AS STRING)
};

$get_from_date = ($x, $y) -> {
    return CAST(DateTime::MakeDatetime($datetime_parse($x)) - DateTime::IntervalFromDays($day_from_exp + $y) AS STRING)
};


$fct = '//home/taxi-dwh/cdm/marketplace/fct_order';
$com = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/campaign_logs_final';
-- табличка с данными "открытки" от Наташи Зориной. Джоиним по order_id
$post_card = '//home/taxi-delivery/analytics/dev/product/postcard/orders_with_postcard_flg';

$fraud = (
    SELECT
        DISTINCT order_id
    FROM `//home/taxi-fraud/export/production/delivery/self_orders/merge`
);

-- 
$com_pre = (
SELECT
    experiment_id,
    user_phone_id,
    utc_sending_status_dttm,
    creation_time,
    cm_group_name as group_name,
    group_id, 
    -- это отвечает за реально тех кому отправили, потому как тестовая группа определяется до проверки возможности коммуникации.
    CASE
        WHEN group_id like '%test%' and policy_allowed = '1' then 'test'
        WHEN group_id like '%control%' and policy_allowed = '1' then 'control'
        ELSE NULL
    END as real_group_id,
    FROM $com
    WHERE 1=1
    AND group_id NOT LIKE "%global_control%"
);

$min_max_exp_dates = (
    SELECT
        experiment_id,
        group_name,
        MIN(utc_sending_status_dttm)??MIN(creation_time) as min_date,
        MAX(utc_sending_status_dttm)??MAX(creation_time) as max_date,
        MIN(creation_time) as min_creation_time,
	DateTime::ToDays(
            cast(substring(MAX(utc_sending_status_dttm)??MAX(creation_time), 0, 10) as date) - 
            cast(substring(MIN(utc_sending_status_dttm)??MIN(creation_time), 0, 10) as date))
        as date_diff
    FROM $com_pre
    GROUP BY experiment_id, group_name
);


-- тут можно отсекать кампании по времени (28 дней назад или 3 дня назад)
$com_pre_to_join = (
    SELECT
        com.experiment_id as experiment_id,
        real_group_id,
        com.group_name as group_name,
        user_phone_id,
        utc_sending_status_dttm,
        date_diff,
        min_date,
        max_date
    FROM $com_pre as com
    LEFT JOIN $min_max_exp_dates as ddt
    ON com.experiment_id == ddt.experiment_id
       and com.group_name == ddt.group_name
    WHERE min_creation_time > $start_date
);


$campaign_users = (SELECT DISTINCT user_phone_id FROM $com_pre);


$min_date_1 = (SELECT MIN(creation_time) as min_date FROM $com_pre);
$max_date_1 = (SELECT MAX(utc_sending_status_dttm) FROM $com_pre);
$min_date = (SELECT $get_from_date($min_date_1, 0));
$max_date = (SELECT $get_to_date($max_date_1));

$raw_data = (
SELECT
    fct.order_source_code as order_source_code,
    fct.order_id as order_id,
    fct.utc_order_created_dttm as utc_order_created_dttm,
    fct.user_phone_id AS user_phone_id,
    fct.tariff_class_code AS tariff,
    cpj.utc_sending_status_dttm as utc_sending_status_dttm,
    cpj.experiment_id as experiment_id,
    cpj.real_group_id as real_group_id,
    cpj.group_name as group_name,
    cpj.min_date as min_date,
    cpj.max_date as max_date,
    $get_from_date(min_date, date_diff) as min_date_from,
    $get_to_date(max_date) as max_date_to,
    CASE
        WHEN fct.utc_order_created_dttm >= $get_from_date(min_date, date_diff)
            AND fct.utc_order_created_dttm < min_date  THEN 'aa'
        WHEN fct.utc_order_created_dttm
            BETWEEN min_date AND $get_to_date(max_date) THEN 'ab'
        ELSE NULL
    END AS ab_aa_group,

    fct.delivery_point_cnt as deliveries,

    IF(pcd.order_id IS NULL, 0, 1) as with_post_card,
    IF(fct.order_requirement_list like '%door_to_door%', 1, 0) as door_to_door,
    IF(fct.order_requirement_list like '%thermobag%', 1, 0) as thermobag

FROM range($fct, $start_month(CurrentUtcDate())) AS fct
LEFT JOIN $post_card as pcd ON fct.order_id = pcd.order_id
LEFT JOIN $com_pre_to_join as cpj ON fct.user_phone_id = cpj.user_phone_id
WHERE 1=1
    AND fct.order_source_code in ('yandex', 'cargo', 'yauber')
    AND fct.delivery_point_cnt > 0
    AND fct.order_id not in $fraud
    -- AND not fct.corp_order_flg
    -- AND fct.corp_client_id IS NULL
    AND fct.utc_order_created_dttm > $min_date
    AND fct.utc_order_created_dttm < $max_date
    AND fct.user_phone_id in $campaign_users
    AND ((fct.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp'))
            or (fct.tariff_class_code = 'ubernight' and fct.utc_order_created_dttm >= '2021-09-01'))
);


$clean_raw_data = (
    SELECT * FROM $raw_data WHERE ab_aa_group IS NOT NULL and real_group_id IS NOT NULL
);



$pre_aggregated_deliv = (
    SELECT
        rd.*,
        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND with_post_card = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as aa_test_deliveries_with_postcard,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND with_post_card = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as aa_control_deliveries_with_postcard,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND with_post_card = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as ab_test_deliveries_with_postcard,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND with_post_card = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as ab_control_deliveries_with_postcard,

        -- thermobag
        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND thermobag = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as aa_test_deliveries_with_thermobag,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND thermobag = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as aa_control_deliveries_with_thermobag,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND thermobag = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as ab_test_deliveries_with_thermobag,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND thermobag = 1
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND tariff in ('courier', 'express')
            ) THEN -deliveries
            ELSE NULL
        END as ab_control_deliveries_with_thermobag,


        --  door_to_door
        CASE 
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND door_to_door = 1
                AND tariff = 'express'
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'test'
                AND tariff = 'express'
            ) THEN -deliveries
            ELSE NULL
        END as aa_test_deliveries_with_door_to_door,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND door_to_door = 1
                AND tariff = 'express'
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'aa'
                AND real_group_id = 'control'
                AND tariff = 'express'
            ) THEN -deliveries
            ELSE NULL
        END as aa_control_deliveries_with_door_to_door,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND door_to_door = 1
                AND tariff = 'express'
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'test'
                AND tariff = 'express'
            ) THEN -deliveries
            ELSE NULL
        END as ab_test_deliveries_with_door_to_door,

        CASE
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND door_to_door = 1
                AND tariff = 'express'
                ) THEN deliveries
            WHEN (
                1=1
                AND ab_aa_group = 'ab'
                AND real_group_id = 'control'
                AND tariff = 'express'
            ) THEN -deliveries
            ELSE NULL
        END as ab_control_deliveries_with_door_to_door

    FROM $clean_raw_data as rd
    -- LEFT JOIN
    -- $com_pre_to_join as cp ON
    --     rd.user_phone_id == cp.user_phone_id
    -- and rd.experiment_id == cp.experiment_id
);


$aggregated_deliv_by_exp_and_group_name = (
    SELECT
        experiment_id,
        group_name,
        --postcard Проникновение в доставках Открытка (К+Э) - процент

        1.0 * SUM(if(ab_test_deliveries_with_postcard > 0, ab_test_deliveries_with_postcard, 0))/SUM(if(ab_test_deliveries_with_postcard > 0, ab_test_deliveries_with_postcard, -1 * ab_test_deliveries_with_postcard)) as test_postcard_delivereies_ratio,

        1.0 * SUM(if(ab_control_deliveries_with_postcard > 0, ab_control_deliveries_with_postcard, 0))/SUM(if(ab_control_deliveries_with_postcard > 0, ab_control_deliveries_with_postcard, -1 * ab_control_deliveries_with_postcard)) as control_postcard_delivereies_ratio,

        AGGREGATE_LIST(aa_test_deliveries_with_postcard) as aa_test_deliveries_with_postcard,
        AGGREGATE_LIST(aa_control_deliveries_with_postcard) as aa_control_deliveries_with_postcard,
        AGGREGATE_LIST(ab_test_deliveries_with_postcard) as ab_test_deliveries_with_postcard,
        AGGREGATE_LIST(ab_control_deliveries_with_postcard) as ab_control_deliveries_with_postcard, 
        

        1.0 * SUM(if(ab_test_deliveries_with_thermobag > 0, ab_test_deliveries_with_thermobag, 0))/SUM(if(ab_test_deliveries_with_thermobag > 0, ab_test_deliveries_with_thermobag, -1 * ab_test_deliveries_with_thermobag)) as test_thermobag_delivereies_ratio,

        1.0 * SUM(if(ab_control_deliveries_with_thermobag > 0, ab_control_deliveries_with_thermobag, 0))/SUM(if(ab_control_deliveries_with_thermobag > 0, ab_control_deliveries_with_thermobag, -1 * ab_control_deliveries_with_thermobag)) as control_thermobag_delivereies_ratio,

        AGGREGATE_LIST(aa_test_deliveries_with_thermobag) as aa_test_deliveries_with_thermobag,
        AGGREGATE_LIST(aa_control_deliveries_with_thermobag) as aa_control_deliveries_with_thermobag,
        AGGREGATE_LIST(ab_test_deliveries_with_thermobag) as ab_test_deliveries_with_thermobag, 
        AGGREGATE_LIST(ab_control_deliveries_with_thermobag) as ab_control_deliveries_with_thermobag,


        1.0 * SUM(if(ab_test_deliveries_with_door_to_door > 0, ab_test_deliveries_with_door_to_door, 0))/SUM(if(ab_test_deliveries_with_door_to_door > 0, ab_test_deliveries_with_door_to_door, -1 * ab_test_deliveries_with_door_to_door)) as test_door_to_door_delivereies_ratio,

        1.0 * SUM(if(ab_control_deliveries_with_door_to_door > 0, ab_control_deliveries_with_door_to_door, 0))/SUM(if(ab_control_deliveries_with_door_to_door > 0, ab_control_deliveries_with_door_to_door, -1 * ab_control_deliveries_with_door_to_door)) as control_door_to_door_delivereies_ratio,

        AGGREGATE_LIST(aa_test_deliveries_with_door_to_door) as aa_test_deliveries_with_door_to_door,
        AGGREGATE_LIST(aa_control_deliveries_with_door_to_door) as aa_control_deliveries_with_door_to_door,
        AGGREGATE_LIST(ab_test_deliveries_with_door_to_door) as ab_test_deliveries_with_door_to_door,
        AGGREGATE_LIST(ab_control_deliveries_with_door_to_door) as ab_control_deliveries_with_door_to_door


    FROM $pre_aggregated_deliv
    GROUP BY experiment_id, group_name
);



$pre_aggregated_by_user_group_name = (
    SELECT
        cpj.experiment_id as experiment_id,
        cpj.group_name as group_name,
        cpj.user_phone_id as user_phone_id,
        door_to_door,
        thermobag,
        with_post_card,
        deliveries,

        --del c+e
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express', 'ubernight'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_c_e_del,

        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express', 'ubernight'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as  aa_control_c_e_del,

        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express', 'ubernight'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_c_e_del,

        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express', 'ubernight'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_c_e_del,
        
        -- del cargo
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('cargo', 'cargocorp'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_cargo_del,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('cargo', 'cargocorp'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_control_cargo_del,
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('cargo', 'cargocorp'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_cargo_del,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('cargo', 'cargocorp'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_cargo_del,


        -- door_to_door
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('express') and door_to_door == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_d2d,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('express') and door_to_door == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_control_d2d,
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('express') and door_to_door == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_d2d,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('express') and door_to_door == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_d2d,


        -- express
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('express'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_express,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('express'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_control_express,
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('express'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_express,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('express'), deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_express,

        -- thermobag
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express') and thermobag == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_thermobag,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express') and thermobag == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_control_thermobag,
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express') and thermobag == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_thermobag,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express') and thermobag == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_thermobag,
        

        --postcard
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express') and with_post_card == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_test_postcard,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'aa' THEN
                        IF(tariff in ('courier', 'express') and with_post_card == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as aa_control_postcard,
        CASE
            WHEN cpj.real_group_id == 'test' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express') and with_post_card == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_test_postcard,
        CASE
            WHEN cpj.real_group_id == 'control' THEN
                CASE
                    WHEN raw.ab_aa_group == 'ab' THEN
                        IF(tariff in ('courier', 'express') and with_post_card == 1, deliveries, 0)
                    WHEN raw.ab_aa_group IS NULL THEN 0
                    ELSE 0
                END
            ELSE NULL
        END as ab_control_postcard


    FROM $clean_raw_data as raw
    RIGHT JOIN $com_pre_to_join as cpj
    ON raw.user_phone_id = cpj.user_phone_id
       AND raw.experiment_id = cpj.experiment_id
       AND raw.real_group_id =  cpj.real_group_id
    WHERE cpj.real_group_id is not NULL
);

$pre_aggregated_by_user_group_name_2 = (
    SELECT
        experiment_id,
        group_name,
        user_phone_id,


        --del c+e
        SUM(aa_test_c_e_del) as aa_test_c_e_del,
        SUM(aa_control_c_e_del) as aa_control_c_e_del,
        SUM(ab_test_c_e_del) as ab_test_c_e_del,
        SUM(ab_control_c_e_del) as ab_control_c_e_del,

        --user
        IF(SUM(aa_test_c_e_del) > 0, 1, SUM(aa_test_c_e_del)) as aa_test_c_e_us,
        IF(SUM(aa_control_c_e_del) > 0, 1, SUM(aa_control_c_e_del)) as aa_control_c_e_us,
        IF(SUM(ab_test_c_e_del) > 0, 1, SUM(ab_test_c_e_del)) as ab_test_c_e_us,
        IF(SUM(ab_control_c_e_del) > 0, 1, SUM(ab_control_c_e_del)) as ab_control_c_e_us,
        
        -- del cargo
        SUM(aa_test_cargo_del) as aa_test_cargo_del,
        SUM(aa_control_cargo_del) as aa_control_cargo_del,
        SUM(ab_test_cargo_del) as ab_test_cargo_del,
        SUM(ab_control_cargo_del) as ab_control_cargo_del,

        --us cargo
        IF(SUM(aa_test_cargo_del) > 0, 1, SUM(aa_test_cargo_del)) as aa_test_cargo_us,
        IF(SUM(aa_control_cargo_del) > 0, 1, SUM(aa_control_cargo_del)) as aa_control_cargo_us,
        IF(SUM(ab_test_cargo_del) > 0, 1, SUM(ab_test_cargo_del)) as ab_test_cargo_us,
        IF(SUM(ab_control_cargo_del) > 0, 1, SUM(ab_control_cargo_del)) as ab_control_cargo_us,

        -- door_to_door
        SUM(aa_test_d2d) as aa_test_d2d,
        SUM(aa_control_d2d) as aa_control_d2d,
        SUM(ab_test_d2d) as ab_test_d2d,
        SUM(ab_control_d2d) as ab_control_d2d,

        -- d2d us
        IF(SUM(aa_test_d2d) > 0, 1, SUM(aa_test_d2d)) as aa_test_d2d_us,
        IF(SUM(aa_control_d2d) > 0, 1, SUM(aa_control_d2d)) as aa_control_d2d_us,
        IF(SUM(ab_test_d2d) > 0, 1, SUM(ab_test_d2d))  as ab_test_d2d_us,
        IF(SUM(ab_control_d2d) > 0, 1, SUM(ab_control_d2d)) as ab_control_d2d_us,

        -- d2d penetration
        CASE
            WHEN SUM(aa_test_d2d) > 0 THEN 1
            WHEN SUM(aa_test_express) > 0 THEN -1
            ELSE NULL
        END AS aa_test_d2d_pen,
        CASE
            WHEN SUM(aa_control_d2d) > 0 THEN 1
            WHEN SUM(aa_control_express) > 0 THEN -1
            ELSE NULL
        END AS aa_control_d2d_pen,
        CASE
            WHEN SUM(ab_test_d2d) > 0 THEN 1
            WHEN SUM(ab_test_express) > 0 THEN -1
            ELSE NULL
        END AS ab_test_d2d_pen,
        CASE
            WHEN SUM(ab_control_d2d) > 0 THEN 1
            WHEN SUM(ab_control_express) > 0 THEN -1
            ELSE NULL
        END AS ab_control_d2d_pen,


        -- express
        SUM(aa_test_express) as aa_test_express,
        SUM(aa_control_express) as aa_control_express,
        SUM(ab_test_express) as ab_test_express,
        SUM(ab_control_express) as ab_control_express,

        
        -- express us
        IF(SUM(aa_test_express) > 0, 1, SUM(aa_test_express)) as aa_test_express_us,
        IF(SUM(aa_control_express) > 0, 1, SUM(aa_control_express)) as aa_control_express_us,
        IF(SUM(ab_test_express) > 0, 1, SUM(ab_test_express)) as ab_test_express_us,
        IF(SUM(ab_control_express) > 0, 1, SUM(ab_control_express)) as ab_control_express_us,

        -- thermobag
        SUM(aa_test_thermobag) as aa_test_thermobag,
        SUM(aa_control_thermobag) as aa_control_thermobag,
        SUM(ab_test_thermobag) as ab_test_thermobag,
        SUM(ab_control_thermobag) as ab_control_thermobag,

        -- thermobag
        IF(SUM(aa_test_thermobag) > 0, 1, SUM(aa_test_thermobag)) as aa_test_thermobag_us,
        IF(SUM(aa_control_thermobag) > 0, 1, SUM(aa_control_thermobag)) as aa_control_thermobag_us,
        IF(SUM(ab_test_thermobag) > 0, 1, SUM(ab_test_thermobag)) as ab_test_thermobag_us,
        IF(SUM(ab_control_thermobag) > 0, 1, SUM(ab_control_thermobag)) as ab_control_thermobag_us,

        -- pen
        CASE
            WHEN SUM(aa_test_thermobag) > 0 THEN 1
            WHEN SUM(aa_test_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS aa_test_thermobag_pen,
        CASE
            WHEN SUM(aa_control_thermobag) > 0 THEN 1
            WHEN SUM(aa_control_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS aa_control_thermobag_pen,
        CASE
            WHEN SUM(ab_test_thermobag) > 0 THEN 1
            WHEN SUM(ab_test_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS ab_test_thermobag_pen,
        CASE
            WHEN SUM(ab_control_thermobag) > 0 THEN 1
            WHEN SUM(ab_control_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS ab_control_thermobag_pen,


        --postcard
        SUM(aa_test_postcard) as aa_test_postcard,
        SUM(aa_control_postcard) as aa_control_postcard,
        SUM(ab_test_postcard) as ab_test_postcard,
        SUM(ab_control_postcard) as ab_control_postcard,

        --postcard us
        IF(SUM(aa_test_postcard) > 0, 1, SUM(aa_test_postcard)) as aa_test_postcard_us,
        IF(SUM(aa_control_postcard) > 0, 1, SUM(aa_control_postcard)) as aa_control_postcard_us,
        IF(SUM(ab_test_postcard) > 0, 1, SUM(ab_test_postcard)) as ab_test_postcard_us,
        IF(SUM(ab_control_postcard) > 0, 1, SUM(ab_control_postcard)) as ab_control_postcard_us,

        -- postcard penetration
        CASE
            WHEN SUM(aa_test_postcard) > 0 THEN 1
            WHEN SUM(aa_test_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS aa_test_postcard_pen,
        CASE
            WHEN SUM(aa_control_postcard) > 0 THEN 1
            WHEN SUM(aa_control_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS aa_control_postcard_pen,
        CASE
            WHEN SUM(ab_test_postcard) > 0 THEN 1
            WHEN SUM(ab_test_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS ab_test_postcard_pen,
        CASE
            WHEN SUM(ab_control_postcard) > 0 THEN 1
            WHEN SUM(ab_control_c_e_del) > 0 THEN -1
            ELSE NULL
        END AS ab_control_postcard_pen

    FROM $pre_aggregated_by_user_group_name
    GROUP BY
        experiment_id,
        group_name,
        user_phone_id
);


$aggregated_by_user_group_name =  (
    SELECT
        experiment_id,
        group_name,

        -- C+E
        -- deliveries
        1.0 * SUM(ab_test_c_e_del) as test_express_couries_delivereies,

        -- Прирост в доставках (К+Э), относительно (20/10=100%)
        AGGREGATE_LIST(aa_test_c_e_del) as aa_test_express_couries_delivereies,
        AGGREGATE_LIST(aa_control_c_e_del) as aa_control_express_couries_delivereies,
        AGGREGATE_LIST(ab_test_c_e_del) as ab_test_express_couries_delivereies,
        AGGREGATE_LIST(ab_control_c_e_del) as ab_control_express_couries_delivereies,

        -- users
        1.0 * SUM(ab_test_c_e_us) as test_is_express_couries,

        -- Прирост в пользователях с доставкам (К+Э), абсолюты (20-10=10)
        AGGREGATE_LIST(aa_test_c_e_us) as aa_test_is_express_couries,
        AGGREGATE_LIST(aa_control_c_e_us) as aa_control_is_express_couries,
        AGGREGATE_LIST(ab_test_c_e_us) as ab_test_is_express_couries,
        AGGREGATE_LIST(ab_control_c_e_us) as ab_control_is_express_couries,


        --CARGO
        -- deliveries
        1.0 * SUM(ab_test_cargo_del) as test_cargo_deliveries,

        -- Прирост в доставках Грузового, относительно
        AGGREGATE_LIST(aa_test_cargo_del) as aa_test_cargo_deliveries,
        AGGREGATE_LIST(aa_control_cargo_del) as aa_control_cargo_deliveries,
        AGGREGATE_LIST(ab_test_cargo_del) as ab_test_cargo_deliveries,
        AGGREGATE_LIST(ab_control_cargo_del) as ab_control_cargo_deliveries,

        -- users
        AGGREGATE_LIST(aa_test_cargo_us) as aa_test_cargo_us,
        AGGREGATE_LIST(aa_control_cargo_us) as aa_control_cargo_us,
        AGGREGATE_LIST(ab_test_cargo_us) as ab_test_cargo_us,
        AGGREGATE_LIST(ab_control_cargo_us) as ab_control_cargo_us,
        1.0 * SUM(ab_test_cargo_us) as test_is_cargo,



        -- FEATURES
        -- door to door
        -- deliveries
        AGGREGATE_LIST(aa_test_d2d) as aa_test_d2d,
        AGGREGATE_LIST(aa_control_d2d) as aa_control_d2d,
        AGGREGATE_LIST(ab_test_d2d) as ab_test_d2d,
        AGGREGATE_LIST(ab_control_d2d) as ab_control_d2d,

        -- users
        AGGREGATE_LIST(aa_test_d2d_us) as aa_test_d2d_us,
        AGGREGATE_LIST(aa_control_d2d_us) as aa_control_d2d_us,
        AGGREGATE_LIST(ab_test_d2d_us) as ab_test_d2d_us,
        AGGREGATE_LIST(ab_control_d2d_us) as ab_control_d2d_us,

        -- penetraion
        AGGREGATE_LIST(aa_test_d2d_pen) as aa_test_d2d_pen,
        AGGREGATE_LIST(aa_control_d2d_pen) as aa_control_d2d_pen,
        AGGREGATE_LIST(ab_test_d2d_pen) as ab_test_d2d_pen,
        AGGREGATE_LIST(ab_control_d2d_pen) as ab_control_d2d_pen,

        1.0 * SUM(ab_test_d2d_us)/SUM(ab_test_express_us) as test_door_to_door_to_express,


        --thermobag
        -- deliveries
        AGGREGATE_LIST(aa_test_thermobag) as aa_test_thermobag,
        AGGREGATE_LIST(aa_control_thermobag) as aa_control_thermobag,
        AGGREGATE_LIST(ab_test_thermobag) as ab_test_thermobag,
        AGGREGATE_LIST(ab_control_thermobag) as ab_control_thermobag,

        -- users
        AGGREGATE_LIST(aa_test_thermobag_us) as aa_test_thermobag_us,
        AGGREGATE_LIST(aa_control_thermobag_us) as aa_control_thermobag_us,
        AGGREGATE_LIST(ab_test_thermobag_us) as ab_test_thermobag_us,
        AGGREGATE_LIST(ab_control_thermobag_us) as ab_control_thermobag_us,

        -- penetraion
        AGGREGATE_LIST(aa_test_thermobag_pen) as aa_test_thermobag_pen,
        AGGREGATE_LIST(aa_control_thermobag_pen) as aa_control_thermobag_pen,
        AGGREGATE_LIST(ab_test_thermobag_pen) as ab_test_thermobag_pen,
        AGGREGATE_LIST(ab_control_thermobag_pen) as ab_control_thermobag_pen,

        1.0 * SUM(ab_test_thermobag_us)/SUM(ab_test_c_e_us) as test_thermobag_to_express_courier,


        -- postcard
        -- deliveries
        AGGREGATE_LIST(aa_test_postcard) as aa_test_postcard,
        AGGREGATE_LIST(aa_control_postcard) as aa_control_postcard,
        AGGREGATE_LIST(ab_test_postcard) as ab_test_postcard,
        AGGREGATE_LIST(ab_control_postcard) as ab_control_postcard,

        -- users
        AGGREGATE_LIST(aa_test_postcard_us) as aa_test_postcard_us,
        AGGREGATE_LIST(aa_control_postcard_us) as aa_control_postcard_us,
        AGGREGATE_LIST(ab_test_postcard_us) as ab_test_postcard_us,
        AGGREGATE_LIST(ab_control_postcard_us) as ab_control_postcard_us,

        -- penetraion
        AGGREGATE_LIST(aa_test_postcard_pen) as aa_test_postcard_pen,
        AGGREGATE_LIST(aa_control_postcard_pen) as aa_control_postcard_pen,
        AGGREGATE_LIST(ab_test_postcard_pen) as ab_test_postcard_pen,
        AGGREGATE_LIST(ab_control_postcard_pen) as ab_control_postcard_pen,


        1.0 * SUM(ab_test_postcard_us)/SUM(ab_test_c_e_us) as test_postcard_to_express_courier,


        COUNT(aa_test_cargo_us) as total_users,
        1.0 * SUM(ab_test_c_e_us)/COUNT(aa_test_cargo_us) as c_e_cr,
        1.0 * SUM(ab_test_cargo_us)/COUNT(ab_test_cargo_us) as cargo_cr
    FROM $pre_aggregated_by_user_group_name_2
    GROUP BY experiment_id, group_name
);


$to_insert_2 = '//home/taxi-delivery/analytics/dev/marketing/agliukov/crm_exp/for_python_21_final';
INSERT INTO $to_insert_2
WITH TRUNCATE
SELECT
    '21' as window_selector,
    all_data.*
FROM (
SELECT 
    *
FROM $aggregated_by_user_group_name as abu
LEFT JOIN $aggregated_deliv_by_exp_and_group_name as abd
on abu.experiment_id = abd.experiment_id and 
abu.group_name = abd.group_name) as all_data;

