use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


$fct = '//home/taxi-dwh/cdm/marketplace/fct_order';

$fraud = (
    SELECT
        DISTINCT order_id
    FROM `//home/taxi-fraud/export/production/delivery/self_orders/merge`
);

$smb = (SELECT user_phone_id FROM `//home/taxi-delivery/analytics/production/marketing/smb/all_smb_user_phone_id`);


$smb_users = (
    SELECT
    DISTINCT user_phone_id
    FROM range($fct, '2019-07-01') AS fct
    WHERE 1=1
        AND fct.order_source_code in ('yandex', 'cargo')
        AND fct.user_phone_id in $smb
        AND fct.order_id not in $fraud
        AND fct.delivery_point_cnt > 0
        AND not fct.corp_order_flg
        AND fct.corp_client_id IS NULL
        AND (fct.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp'))
        AND fct.country_name_ru == 'Израиль'
);


$corp_users = (
    SELECT
    DISTINCT user_phone_id
    FROM range($fct, '2019-07-01') AS fct
    WHERE 1=1
        AND fct.order_source_code in ('yandex', 'cargo')
        AND fct.delivery_point_cnt > 0
        AND fct.order_id not in $fraud
        AND fct.corp_order_flg
        AND (fct.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp'))
        AND fct.country_name_ru == 'Израиль'

);

$insert_corp = '//home/taxi-delivery/analytics/production/marketing/corp_users_israel';

INSERT INTO $insert_corp
WITH TRUNCATE
SELECT * FROM $corp_users;

$insert_corp_smb = '//home/taxi-delivery/analytics/production/marketing/corp_smb_users_israel';
INSERT INTO $insert_corp_smb
WITH TRUNCATE
SELECT
    DISTINCT user_phone_id
FROM(
    SELECT * FROM $corp_users
    UNION ALL
    SELECT * FROM $smb_users
)
