use hahn;

$first_direct_cab = '//home/delivery-dwh/raw/direct/deliveryapp_event_stats/deliveryapp_event_stats';
$second_direct_cab = '//home/delivery-dwh/raw/direct/ya_dostawka_event_stats/ya_dostawka_event_stats';
$third_direct_cab = '//home/delivery-dwh/raw/direct/delivery_event_stats/delivery_event_stats';

$all_cabs = (
    SELECT * FROM $first_direct_cab
    UNION ALL
    SELECT * FROM $second_direct_cab 
    UNION ALL
    SELECT * FROM $third_direct_cab
);


INSERT INTO `//home/taxi-delivery/analytics/dev/marketing/agliukov/performans/dict`
WITH TRUNCATE 
SELECT DISTINCT
    campaign_name,
    campaign_id,
    adgroup_id,
    ad_id,
    campaign_name || '.' || campaign_id as utm_campaign
FROM $all_cabs;


INSERT INTO `//home/taxi-delivery/analytics/dev/marketing/agliukov/performans/aggregated_direct_cabs`
WITH TRUNCATE
SELECT
    true_utm,
    `date`,
    SUM(clicks) as platform_clicks,
    SUM(`cost`) as cost,
    SUM(`impressions`) as impressions,
    SUM(`sessions`) as sessions
FROM $all_cabs
GROUP BY campaign_name || '.' || campaign_id as true_utm, `date`
