DROP TABLE IF EXISTS modified_plan_1;
CREATE TEMP TABLE modified_plan_1 as

select date,
       country,
       corp_order_flg,
       tariff,
       frequency,
       scale,
       plan_or_fact,
       plan_type,
       FALSE as is_newbies,
       a.value - n.value as au,
       d.value as deliveries
FROM snb_delivery.plan_fact_audience_new as a
INNER JOIN snb_delivery.plan_fact_aud_deliveries_new as d
USING (date, country,
       corp_order_flg, tariff, frequency,
       scale, plan_or_fact, plan_type)
INNER JOIN snb_delivery.plan_fact_audience_new as n
USING(date, country,
       corp_order_flg, tariff, frequency,
       scale, plan_or_fact, plan_type)
WHERE a.metric like '%AU' and n.metric like '%newbies'
UNION ALL
SELECT date,
       country,
       corp_order_flg,
       tariff,
       frequency,
       scale,
       plan_or_fact,
       plan_type,
       TRUE as is_newbies,
       value as au,
       0 as deliveries
FROM snb_delivery.plan_fact_audience_new
WHERE metric like '%newbies'

DISTRIBUTED RANDOMLY;
ANALYZE modified_plan_1;

DROP TABLE IF EXISTS modified_plan;
CREATE TEMP TABLE modified_plan as
select * from modified_plan_1
union
SELECT date,
       country,
       corp_order_flg,
       tariff,
       frequency,
       scale,
       plan_or_fact,
       'amb 2021 june'::text as plan_type,
       is_newbies,
       0 as au,
       0 as deliveries
FROM
(select * from modified_plan_1
where plan_type in ('bud 2021', 'amb 2021')) as tmp2
left join
(select * from modified_plan_1
where plan_type in ('amb 2021 june')) as tmp1
USING(date, country,
       corp_order_flg, tariff, frequency,
       scale, plan_or_fact, is_newbies)
where tmp1.plan_type is null
DISTRIBUTED RANDOMLY;
ANALYZE modified_plan;


DROP TABLE IF EXISTS final_modified_plan;
CREATE TEMP TABLE final_modified_plan as

select
    date_trunc('day', date)::date as date,
--     case
--         when (time_end + interval '29 days')::date <= (current_date - interval '1 day') then 'all'
--         else 'part' end as all_part_table,
    'no'::text as all_part_table,
    frequency,
    country,
    'no'::text as city,
    TRUE as is_b2c,
    corp_order_flg,
    tariff,
    scale,
    plan_or_fact,
    plan_type,
    is_newbies,
    au,
    deliveries
from (
         select *,
                case
                    when scale = 'week' then (date_trunc('week', date) + interval '6 days')::date
                    when scale = 'month' then (date_trunc('month', date) + interval '1 month - 1 day')::date
                    end as time_end
         from modified_plan
     ) as tmp1
DISTRIBUTED RANDOMLY;
ANALYZE final_modified_plan;

--  фильтруем и оставляем только B2C
DROP TABLE IF EXISTS deliveries_fact_tbl;
CREATE TEMP TABLE deliveries_fact_tbl AS
SELECT
    *
FROM (SELECT
        fo.order_id as order_id,
        fo.user_phone_pd_id AS user_phone_pd_id,
        case
            when fo.country_name_ru like '%Кот-д%' then 'Кот-д’Ивуар'
            else fo.country_name_ru
            end AS country,
        geo.name_ru AS city,
        CASE
            when not fo.corp_order_flg THEN TRUE
        END AS is_b2c,

        CASE
            WHEN fo.tariff_class_code IN ('express', 'courier', 'ubernight', 'uberlux') THEN 'Delivery+Courier'
            ELSE 'Cargo'
        END AS tariff,


        (fo.utc_order_created_dttm + INTERVAL '3 hours') as msk_order_created_dttm,
        DATE_TRUNC('day', (fo.utc_order_created_dttm + INTERVAL '3 hours'))::DATE AS day,
        DATE_TRUNC('week', (fo.utc_order_created_dttm + INTERVAL '3 hours'))::DATE AS week,
        (DATE_TRUNC('week', (fo.utc_order_created_dttm + INTERVAL '3 hours')) + INTERVAL '6 days')::DATE AS week_end,
        DATE_TRUNC('month', (fo.utc_order_created_dttm + INTERVAL '3 hours'))::DATE AS month,
        (DATE_TRUNC('month', (fo.utc_order_created_dttm + INTERVAL '3 hours')) + INTERVAL '1 month - 1 day')::DATE AS month_end,

--         case
--             when manager_group = 'Тир 3' then 'SMB'
--             when corp_order_flg then 'B2B'
--             when tier4.user_phone_pd_id is not null
--                      and (utc_order_created_dttm + interval '3 hours')::date >= datefrom then 'SMB'
--         else 'C2C'
        CASE
            WHEN fo.corp_order_flg THEN 'B2B'
            WHEN tier4.user_phone_pd_id IS NOT NULL THEN 'SMB'
--            WHEN fo.tariff_class_code in ('cargo', 'cargocorp') THEN 'C2C'
--            WHEN tier4.user_phone_pd_id IS NOT NULL
--                    AND (utc_order_created_dttm
--                            BETWEEN utc_valid_from_dt::date
--                                AND utc_valid_to_dt::date)
            ELSE 'C2C'
        END AS corp_order_flg,
        fo.corp_order_flg as cog,
        fo.corp_client_id as corp_client_id,

        fo.order_source_code as order_source_code,
        fo.delivery_point_cnt as deliveries

        FROM taxi_cdm_marketplace.fct_order AS fo

        LEFT JOIN (
            SELECT *
            FROM snb_delivery.smb_users_flags
            WHERE utc_valid_to_dt = '9999-12-31'
            ) AS tier4 ON tier4.user_phone_pd_id = fo.user_phone_pd_id

--      LEFT JOIN snb_delivery.smb_users_flags AS tier4
--      ON tier4.user_phone_pd_id = fo.user_phone_pd_id
--      AND (fo.utc_order_created_dttm BETWEEN tier4.utc_valid_from_dt::date
--            AND tier4.utc_valid_to_dt::date)

        LEFT JOIN (
            SELECT DISTINCT node_id, name_ru
            FROM taxi_cdm_geo.v_dim_op_geo_hierarchy
            WHERE node_type = 'agglomeration'
            ) AS geo ON geo.node_id = fo.agglomeration_node_id

        WHERE ((fo.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp'))
            or (fo.tariff_class_code = 'ubernight' and fo.msk_order_created_dttm >= '2021-09-01') -- пока только Доставка и Грузовой
            or (fo.tariff_class_code = 'uberlux' and fo.utc_order_created_dttm >= '2022-03-01'))
            AND (fo.utc_order_created_dttm + INTERVAL '3 hours') ::DATE BETWEEN '2019-01-01' AND (CURRENT_DATE - INTERVAL '1 day')
            AND fo.delivery_point_cnt > 0
            AND NOT fo.fake_order_flg
            AND NOT fo.mqc_order_flg
            AND NOT fo.user_fraud_flg
            AND fo.order_id not in (select order_id from snb_delivery.self_orders)
      ) AS tmp1
WHERE tmp1.corp_order_flg IN ('C2C', 'SMB')

DISTRIBUTED RANDOMLY;
ANALYZE deliveries_fact_tbl;

-- ищем новичков:
DROP TABLE IF EXISTS deliveries_fact_tbl_1;
CREATE TEMP TABLE deliveries_fact_tbl_1 AS
SELECT
       *,
       -- новички в принципе
       FIRST_VALUE(msk_order_created_dttm) OVER tariff_newbies AS tariff_newbies,
       FIRST_VALUE(msk_order_created_dttm) OVER all_newbies AS all_newbies,
       -- новички по странам
       FIRST_VALUE(msk_order_created_dttm) OVER tariff_country_newbies AS tariff_country_newbies,
       FIRST_VALUE(msk_order_created_dttm) OVER all_country_newbies AS all_country_newbies,
       -- новички по городам
       FIRST_VALUE(msk_order_created_dttm) OVER tariff_city_newbies AS tariff_city_newbies,
       FIRST_VALUE(msk_order_created_dttm) OVER all_city_newbies AS all_city_newbies
FROM deliveries_fact_tbl
WINDOW
       -- новички
       tariff_newbies AS (PARTITION BY
                                        user_phone_pd_id,
                                        tariff
                           ORDER BY msk_order_created_dttm ASC
                           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING),
       all_newbies AS (PARTITION BY
                                        user_phone_pd_id
                            ORDER BY msk_order_created_dttm ASC
                            RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING),
       -- новички по странам
       tariff_country_newbies AS (PARTITION BY
                                        user_phone_pd_id,
                                        tariff,
                                        country
                           ORDER BY msk_order_created_dttm ASC
                           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING),
       all_country_newbies AS (PARTITION BY
                                        user_phone_pd_id,
                                        country
                            ORDER BY msk_order_created_dttm ASC
                            RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING),
       -- новички по городам
       tariff_city_newbies AS (PARTITION BY
                                        user_phone_pd_id,
                                        tariff,
                                        city
                           ORDER BY msk_order_created_dttm ASC
                           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING),
       all_city_newbies AS (PARTITION BY
                                        user_phone_pd_id,
                                        city
                            ORDER BY msk_order_created_dttm ASC
                            RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING)
DISTRIBUTED RANDOMLY;
ANALYZE deliveries_fact_tbl_1;


-- Выставляем частотность
DROP TABLE IF EXISTS c2c_id_month;
CREATE TEMP TABLE c2c_id_month AS
SELECT
    *,
    -- частоты ВООБЩЕ по тарифам
    CASE
        WHEN SUM(deliveries) OVER global_all_tariff = 1 THEN '1'
        WHEN SUM(deliveries) OVER global_all_tariff BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_global_all_tariff,
    -- частоты ВООБЩЕ
    CASE
        WHEN SUM(deliveries) OVER global_all = 1 THEN '1'
        WHEN SUM(deliveries) OVER global_all BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_global_all,
    -- частоты по СТРАНАМ и тарифам
    CASE
        WHEN SUM(deliveries) OVER country_tariff = 1 THEN '1'
        WHEN SUM(deliveries) OVER country_tariff BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_country_tariff,
    -- частоты по СТРАНАМ
    CASE
        WHEN SUM(deliveries) OVER country_all = 1 THEN '1'
        WHEN SUM(deliveries) OVER country_all BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_country_all,
    -- частоты по ГОРОДАМ и тарифам
    CASE
        WHEN SUM(deliveries) OVER city_tariff = 1 THEN '1'
        WHEN SUM(deliveries) OVER city_tariff BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_city_tariff,
    -- частоты по ГОРОДАМ
    CASE
        WHEN SUM(deliveries) OVER city_all = 1 THEN '1'
        WHEN SUM(deliveries) OVER city_all BETWEEN 2 AND 4 THEN '2-4'
        ELSE '5+'
    END AS freq_city_all,
--     CASE
--         WHEN (month_end + INTERVAL '29 days')::DATE <= (CURRENT_DATE - INTERVAL '1 day') THEN 'all'
--         ELSE 'part'
--     END AS all_part_table
    'all'::text as all_part_table
FROM deliveries_fact_tbl_1
WHERE
    order_source_code in ('yandex', 'cargo') and corp_client_id is null and cog = false
WINDOW
        -- для частот всех по тарифам
        global_all_tariff AS (PARTITION BY
                user_phone_pd_id,
                tariff
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING),
        -- для частот без тарифов
        global_all AS (PARTITION BY
                user_phone_pd_id
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING),
        -- частоты по странам и тарифам
        country_tariff AS (PARTITION BY
                user_phone_pd_id,
                country,
                tariff
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING),
        -- частоты по странам без тарифов
        country_all AS (PARTITION BY
                user_phone_pd_id,
                country
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING),
        -- частоты по городам и тарифам
        city_tariff AS (PARTITION BY
                user_phone_pd_id,
                city,
                tariff
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING),
        -- частоты по городам
        city_all AS (PARTITION BY
                user_phone_pd_id,
                city
            ORDER BY day
            RANGE BETWEEN CURRENT ROW AND 29 FOLLOWING)
DISTRIBUTED RANDOMLY;
ANALYZE c2c_id_month;





--первые частоты
DROP TABLE IF EXISTS c2c_id_month_ag;
CREATE TEMP table c2c_id_month_ag AS
SELECT
       *,
       -- ПО МЕСЯЦУ
       ---- по ВСЕМУ МИРУ
       ------ по тарифу
       FIRST_VALUE(freq_global_all_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                month,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_global_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_global_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                month
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_global_all,
       ---- по СТРАНЕ
       ------ по тарифу
       FIRST_VALUE(freq_country_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                month,
                country,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_country_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_country_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                month,
                country
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_country_all,
       -- По ГОРОДАМ
       ------ по тарифу
       FIRST_VALUE(freq_city_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                month,
                city,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_city_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_city_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                month,
                city
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_month_city_all,
       -- ПО неделе
       ---- по ВСЕМУ МИРУ
       ------ по тарифу
       FIRST_VALUE(freq_global_all_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                week,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_global_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_global_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                week
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_global_all,
       ---- по СТРАНЕ
       ------ по тарифу
       FIRST_VALUE(freq_country_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                week,
                country,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_country_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_country_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                week,
                country
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_country_all,
       -- По ГОРОДАМ
       ------ по тарифу
       FIRST_VALUE(freq_city_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                week,
                city,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_city_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_city_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                week,
                city
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_week_city_all,
       -- ПО дням
       ---- по ВСЕМУ МИРУ
       ------ по тарифу
       FIRST_VALUE(freq_global_all_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_global_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_global_all) OVER (
            PARTITION BY
                user_phone_pd_id
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_global_all,
       ---- по СТРАНЕ
       ------ по тарифу
       FIRST_VALUE(freq_country_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                country,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_country_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_country_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                country
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_country_all,
       -- По ГОРОДАМ
       ------ по тарифу
       FIRST_VALUE(freq_city_tariff) OVER (
            PARTITION BY
                user_phone_pd_id,
                city,
                tariff
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_city_tariff,
       ------ без тарифов
       FIRST_VALUE(freq_city_all) OVER (
            PARTITION BY
                user_phone_pd_id,
                city
           ORDER BY day
           RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING
           ) AS frequency_city_all
FROM c2c_id_month

DISTRIBUTED RANDOMLY;
ANALYZE c2c_id_month_ag;

-- GLOBAL --
-- ALL day --
DROP TABLE IF EXISTS final_global_DAU;
CREATE TEMP TABLE final_global_DAU AS
-- по дню, везде, без тарифов.
SELECT day                              as date,
       all_part_table,
       frequency_global_all             as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', all_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_DAU;


DROP TABLE IF EXISTS final_global_tariff_DAU;
CREATE TEMP TABLE final_global_tariff_DAU AS
--по дню, везде, по тарифам
SELECT day                              as date,
       all_part_table,
       frequency_global_tariff          as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', tariff_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag AS c
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_tariff_DAU;


-- ALL week --
DROP TABLE IF EXISTS final_global_WAU;
CREATE TEMP TABLE final_global_WAU AS
-- по неделе, везде, без тарифов
SELECT week                             as date,
       all_part_table,
       frequency_week_global_all        as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', all_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_WAU;


DROP TABLE IF EXISTS final_global_tariff_WAU;
CREATE TEMP TABLE final_global_tariff_WAU AS
-- по неделе, везде, по тарифам
SELECT week                             as date,
       all_part_table,
       frequency_week_global_tariff     as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', tariff_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_tariff_WAU;


-- ALL month --
DROP TABLE IF EXISTS final_global_MAU;
CREATE TEMP TABLE final_global_MAU AS
-- по месяцу, везде, без тарифов
SELECT month                            as date,
       all_part_table,
       frequency_month_global_all       as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', all_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_MAU;


DROP TABLE IF EXISTS final_global_tariff_MAU;
CREATE TEMP TABLE final_global_tariff_MAU AS
-- по месяцу, везде, по тарифам
SELECT month                            as date,
       all_part_table,
       frequency_month_global_tariff    as frequency,
       'All'::text                       as country,
       'All'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', tariff_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_global_tariff_MAU;


-- COUNTRY --
-- ALL day --
DROP TABLE IF EXISTS final_country_DAU;
CREATE TEMP TABLE final_country_DAU AS
-- по дню, по стране, без тарифов
SELECT day                              as date,
       all_part_table,
       frequency_country_all            as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', all_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_DAU;


DROP TABLE IF EXISTS final_country_tariff_DAU;
CREATE TEMP TABLE final_country_tariff_DAU AS
-- по дню, по стране, по тарифам
SELECT day                              as date,
       all_part_table,
       frequency_country_tariff         as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', tariff_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag AS c
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_tariff_DAU;


-- ALL week --
DROP TABLE IF EXISTS final_country_WAU;
CREATE TEMP TABLE final_country_WAU AS
-- по неделе, по стране, без тарифов
SELECT week                             as date,
       all_part_table,
       frequency_week_country_all       as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', all_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_WAU;


DROP TABLE IF EXISTS final_country_tariff_WAU;
CREATE TEMP TABLE final_country_tariff_WAU AS
-- по неделе, по стране, c тарифами
SELECT week                             as date,
       all_part_table,
       frequency_week_country_tariff    as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', tariff_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_tariff_WAU;


-- ALL month --
DROP TABLE IF EXISTS final_country_MAU;
CREATE TEMP TABLE final_country_MAU AS
-- по месяцу, по стране, без тарифов
SELECT month                            as date,
       all_part_table,
       frequency_month_country_all      as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', all_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_MAU;


DROP TABLE IF EXISTS final_country_tariff_MAU;
CREATE TEMP TABLE final_country_tariff_MAU AS
-- по месяцу, по стране, с тарифами
SELECT month                            as date,
       all_part_table,
       frequency_month_country_tariff   as frequency,
       country,
       'no'::text                       as city,
       is_b2c,
       corp_order_flg,
       tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', tariff_country_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_country_tariff_MAU;


-- по городам --
-- ALL day --
DROP TABLE IF EXISTS final_city_DAU;
CREATE TEMP TABLE final_city_DAU AS
-- по городам, по дням, без тарифов
SELECT day                              as date,
       all_part_table,
       frequency_city_all               as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', all_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_DAU;


DROP TABLE IF EXISTS final_city_tariff_DAU;
CREATE TEMP TABLE final_city_tariff_DAU AS
-- по городам, по дням, с тарифами
SELECT day                              as date,
       all_part_table,
       frequency_city_tariff            as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       tariff,
       'day'::text                      as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN day = DATE_TRUNC('day', tariff_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag AS c
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_tariff_DAU;


-- ALL week --
DROP TABLE IF EXISTS final_city_WAU;
CREATE TEMP TABLE final_city_WAU AS
-- по неделям, по городам, без тарифов
SELECT week                             as date,
       all_part_table,
       frequency_week_city_all          as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', all_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_WAU;


DROP TABLE IF EXISTS final_city_tariff_WAU;
CREATE TEMP TABLE final_city_tariff_WAU AS
-- по неделям, по городам, c тарифами
SELECT week                             as date,
       all_part_table,
       frequency_week_city_tariff       as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       tariff,
       'week'::text                     as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN week = DATE_TRUNC('week', tariff_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_tariff_WAU;


-- ALL month --
DROP TABLE IF EXISTS final_city_MAU;
CREATE TEMP TABLE final_city_MAU AS
-- по месяцам, по городам, без тарифов
SELECT month                            as date,
       all_part_table,
       frequency_month_city_all         as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       'All'::text                      as tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', all_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_MAU;


DROP TABLE IF EXISTS final_city_tariff_MAU;
CREATE TEMP TABLE final_city_tariff_MAU AS
-- по месяцам, по городам, с тарифами
SELECT month                            as date,
       all_part_table,
       frequency_month_city_tariff      as frequency,
       'no'::text                       as country,
       city,
       is_b2c,
       corp_order_flg,
       tariff,
       'month'::text                    as scale,
       'fact'::text                     as plan_or_fact,
       'fact'::text                     as plan_type,
       CASE
           WHEN month = DATE_TRUNC('month', tariff_city_newbies) THEN TRUE
           ELSE FALSE
           END                          as is_newbies,
       COUNT(distinct user_phone_pd_id) AS au,
       SUM(deliveries)                  AS deliveries
FROM c2c_id_month_ag
WHERE day >= '2021-01-01'
GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
ORDER BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12

DISTRIBUTED RANDOMLY;
ANALYZE final_city_tariff_MAU;

DROP TABLE IF EXISTS pre_final_table;
CREATE TEMP TABLE pre_final_table AS
-- DROP TEMP IF EXISTS analyst.agliukov_final_united_tables;
-- CREATE TABLE analyst.agliukov_final_united_tables AS
-- SELECT date,
--                          case
--                              when scale = 'day' then (date - interval '1 day')::date
--                              when scale = 'week' then (date - interval '1 week')::date
--                              when scale = 'month' then (date - interval '1 week')::date
--                              end as prev_date
--                   from
select
       *,
       lag(au, case when scale='day' then 7 else 1 end) over (
--        lag(au, 1, 0::double precision) over (
           partition by
               all_part_table,
               frequency,
               country,
               city,
               is_b2c,
               corp_order_flg,
               tariff,
               scale,
               plan_or_fact,
               plan_type,
               is_newbies
           order by date asc
           ) as prev_au,
       lag(deliveries, case when scale='day' then 7 else 1 end) over (
           partition by
               all_part_table,
               frequency,
               country,
               city,
               is_b2c,
               corp_order_flg,
               tariff,
               scale,
               plan_or_fact,
               plan_type,
               is_newbies
           order by date asc
           ) as prev_del

from (
select * from final_global_DAU
union all
select * from final_global_tariff_DAU
union all
select * from final_global_WAU
union all
select * from final_global_tariff_WAU
union all
select * from final_global_MAU
union all
select * from final_global_tariff_MAU
union all
select * from final_country_DAU
union all
select * from final_country_tariff_DAU
union all
select * from final_country_WAU
union all
select * from final_country_tariff_WAU
union all
select * from final_country_MAU
union all
select * from final_country_tariff_MAU
union all
select * from final_city_DAU
union all
select * from final_city_tariff_DAU
union all
select * from final_city_WAU
union all
select * from final_city_tariff_WAU
union all
select * from final_city_MAU
union all
select * from final_city_tariff_MAU
union all
select * from final_modified_plan ) as tmp1
DISTRIBUTED RANDOMLY;
ANALYZE pre_final_table;

                                         
drop table if exists snb_delivery.plan_fact_audience_dash_upd;
create table snb_delivery.plan_fact_audience_dash_upd as
SELECT * FROM pre_final_table
where 1=1
    AND NOT ((scale = 'month' and date >= date_trunc('month', NOW()))
    OR (scale = 'week' and date >= date_trunc('week', NOW()))
    OR (scale = 'day' and date >= date_trunc('day', NOW())))
DISTRIBUTED RANDOMLY;
ANALYZE snb_delivery.plan_fact_audience_dash_upd;


GRANT SELECT ON snb_delivery.plan_fact_audience_dash_upd to public;
