USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$users = '//home/taxi-delivery/analytics/production/smb_model/users_probas';

$max_data = (SELECT MAX(utc_prediction_dt) from $users);

$data = (
    SELECT
        user_phone_pd_id,
        utc_prediction_dt,
        smb_proba,
        not_smb_proba,
    FROM $users 
    WHERE utc_prediction_dt == $max_data
);



-- 2. Ставим пороги на с2с и смб и добавляем флаг
$flag = 
(select 
    data.*,
    CASE 
        when smb_proba < 0.15 then 'c2c'
        when (smb_proba >= 0.15 and smb_proba < 0.31) then 'c2c_mb' -- не точно с2с
        when (smb_proba >= 0.31 and smb_proba < 0.56) then 'smb_mb' -- не точно смб
        when smb_proba >= 0.56 then 'smb'
        else 'else' end as flg
from $data as data);



INSERT INTO `//home/taxi-delivery/analytics/production/marketing/smb/all_smb_user_phone_id`
WITH TRUNCATE 
SELECT distinct user_phone_id FROM $flag as f
INNER join `//home/taxi-dwh/ods/mdb/user_phone/user_phone` as u
ON u.phone_pd_id = f.user_phone_pd_id
WHERE f.flg in ('smb_mb', 'smb') and user_phone_id is not NULL;


INSERT INTO `//home/taxi-delivery/analytics/production/marketing/smb/smb_mb_user_phone_id`
WITH TRUNCATE 
SELECT distinct user_phone_id FROM $flag as f
INNER join `//home/taxi-dwh/ods/mdb/user_phone/user_phone` as u
ON u.phone_pd_id = f.user_phone_pd_id
WHERE f.flg = 'smb_mb' and user_phone_id is not NULL;

INSERT INTO `//home/taxi-delivery/analytics/production/marketing/smb/smb_user_phone_id`
WITH TRUNCATE 
SELECT distinct user_phone_id FROM $flag as f
INNER join `//home/taxi-dwh/ods/mdb/user_phone/user_phone` as u
ON u.phone_pd_id = f.user_phone_pd_id
WHERE f.flg = 'smb' and user_phone_id is not NULL;
