use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma yson.DisableStrict;

-- ID нашего счетчика в метрике
$CounterID = 62915509;
 

$date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");
    $get_eventtime = ($eventtime) -> {
        RETURN cast($date_format(DateTime::FromSeconds(cast($eventtime as Uint32))) as string)
    };
$getdict = ($ev) -> (
    if(DictKeys(Yson::ConvertToDict($ev))[0] is not null, $ev[Unwrap(DictKeys(Yson::ConvertToDict($ev))[0])], null)
);
$parse = ($ev) -> (Yson::ParseJson($ev));
$param_getter = ($ev, $param) -> (
     $getdict($parse($ev))[$param] ??
     $getdict($getdict($parse($ev)))[$param] ??
     $getdict($getdict($getdict($parse($ev))))[$param]
);

-- 
$table_from = '//logs/bs-watch-log/1d/';



-- Dates
$dt_format = DateTime::Format('%Y-%m-%d');
$DT_START = $dt_format(DateTime::StartOfMonth(DateTime::ShiftMonths(CurrentUtcDate(), -1)));
$DT_END = $dt_format(
    DateTime::MakeDatetime((DateTime::StartOfMonth(CurrentUtcDateTime())))
    - DateTime::IntervalFromDays(1)
);

-- Result path

$RESULT_PATH = '//home/taxi-delivery/analytics/production/metrica/web_dostavka/' || $DT_START;


$first = (
    select 
        $get_eventtime(eventtime) as utc_event_dttm
        , watchid -- Уникальный идентификатор хита
        , uniqid -- Идентификатор юзера yandexuid для зоны domainzone.
        , clientip6 -- IPv6 клиента
        , useragent -- HTTP User-Agent
        , cast(regionid as int32) as regionid
        , params -- Параметры хита JSON с параметрами визитов http://help.yandex.ru/metrika/content/visit-params.xml
        , url
        , passportuid -- Passport UID из куки yandex.ru
        , cryptaid
        , referer -- HTTP referer. Страница с которой был переход на текущую. Если хит - достижение цели типа Событие, то в этом поле будет адрес текущей страницы
                    -- Если в browser-info  есть параметр ln:1 , то в этом поле будет адрес текущей страницы
        , counterid -- Идентификатор счетчика
        , counterclass -- Принадлежит ли счетчик к РСЯ Для счетчиков Директа CounterID - идентификатор Метрики
        , realtimeuserid -- yandexuid из реалтайма Крипты
        , domainuserid -- First Party Cookie
        , cookiei
        , browserinfo -- BLOB с данным от браузера
        , if(uniqid = '0',
            if (UserAgent::Parse(useragent).ITP and domainuserid!='0',     
                cast(domainuserid as UInt64), 
                Digest::SipHash(0, 0, Ip::FromString(clientip6) || useragent)
            ),
            cast(uniqid as UInt64)
        ) as UserID 
        , count(*) over(partition by $get_eventtime(eventtime), watchid) as cnt
        , metrikaexp
    from range($table_from, $DT_START, $DT_END)
    where (counterid = '62915509')
    );

    $second = ( 
        select 
            (case when cnt > 1 then watchid || '_' || Metrika::ParseBrowserinfo(browserinfo)["rn"] else watchid end) as event_id
            , utc_event_dttm as utc_event_dttm
            ,Geo::RoundRegionById(regionid, 'region').name as region_name
            ,Geo::RoundRegionById(regionid, 'city').name as city_name
            ,regionid as region_id
            ,cast(if(uniqid = '0',
                Digest::SipHash(0, 0, Ip::FromString(clientip6)||useragent),
                cast(uniqid as UInt64)) as string) as metrica_browser_uid
            ,case
                when useragent regexp 'iPhone' then 'ios'
                when useragent regexp 'Android' then 'android'
                else 'web' end
            as app_platform
            , Yson::Serialize(Yson::ParseJson(params)) as event_value
            ,cast(
                Yson::ConvertToInt64($param_getter(params, 'place_id')) ??
                Yson::ConvertToDouble($param_getter(params, 'place_id')) as Int64
            ) as place_id
            , url as url
            , passportuid as yandex_uid
            , cryptaid as crypta_id
            , referer as referer_url
            , cookiei as cookiei_id
            , counterid 
            , row_number() over w as row_num
            , UserID as userid
            , Metrika::ParseBrowserinfo(browserinfo)["ex"] as ex 
            , metrikaexp
            , cast(Metrika::ParseBrowserinfo(browserinfo)["ln"] as bool) as ln 
            , cast(Metrika::ParseBrowserinfo(browserinfo)["dl"] as bool) as dl 
        from $first
        window w as (
            partition by (counterid, counterclass, UserID, Metrika::ParseBrowserinfo(browserinfo)["rn"]) as rn
        )

    );

-- Delete daily tables

$DATE_START = CAST($DT_START AS Date);
$DATE_END = CAST($DT_END AS Date);

$tables_idx = ListFromRange(1, Unwrap(DateTime::ToDays($DATE_END - $DATE_START)) + 1);

EVALUATE FOR $table_idx IN $tables_idx DO BEGIN
    $table_name = CAST(CAST($DATE_START + DateTime::IntervalFromDays($table_idx) AS Date) AS String);
    $TABLE_PATH = '//home/taxi-delivery/analytics/production/metrica/web_dostavka/' || $table_name;
    
    DROP TABLE $TABLE_PATH;

END DO;


INSERT INTO $RESULT_PATH WITH TRUNCATE 
select   
        utc_event_dttm 
        , event_id
        , metrica_browser_uid 
        , event_value 
        , url 
        , yandex_uid 
        , crypta_id 
        , referer_url 
        , counterid
        , app_platform 
        , city_name 
        , cookiei_id
        , region_id 
        , region_name
        , userid 
        , Yson::ConvertToString(event_value.sharingKey) AS sharing_key
        , ex 
        , metrikaexp  
        , ln 
        , dl 
    from $second as s
        where row_num = 1 
;
