use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma yson.DisableStrict;

-- ID нашего счетчика в метрике
$CounterID = 62915509;
 
$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string);
$five_days_before = cast($today - Interval('P5D') as string);
$six_days_before = cast($today - Interval('P6D') as string);

$days = [
    $one_day_before,
    $two_days_before,
    $three_days_before,
    $four_days_before,
    $five_days_before,
    $six_days_before
];

$format_datetime = ($seconds) -> {
  return DateTime::Format('%Y-%m-%d %H:%M:%S')(
    DateTime::FromSeconds($seconds)
  )};

$get_utm_campaign_id = ($utm_campaign) -> {
  return String::ToLower(String::Substring($utm_campaign, 0, cast(String::Find($utm_campaign, '.') as Uint64)))
};

$get_utm_campaign_name = ($utm_campaign) -> {
  return String::ToLower(String::Substring($utm_campaign, cast(String::Find($utm_campaign, '.') + 1 as Uint64)))
};
EVALUATE FOR $day IN $days DO BEGIN
    $table_to = '//home/taxi-delivery/analytics/production/metrica/web_dostavka_visits/' || $day;
    $table_from = '//statbox/cooked_logs/visit-cooked-log/v1/1d/' || $day;


    $visit_version = (
        select
            row_number() over visit_versions                               as visit_version_index
            , $format_datetime(cast(UTCStartTime as Uint32))                 as utc_visit_start_dttm
            , $format_datetime(cast(FirstVisit as Uint32))                   as utc_first_visit_dttm
            , cast(VisitID as String)                                        as visit_id
            , Sign < 0                                                       as deleted_flg
            , cast(UserID as String)                                         as metrica_user_id
            , cast(PassportUserID as String)                                 as yandex_uid
            , RegionID                                                       as region_id
            , String::ToLower(UTMSource)                                     as utm_source
            , String::ToLower(UTMCampaign)                                   as utm_campaign
            , String::ToLower(UTMTerm)                                       as utm_term
            , String::ToLower(UTMContent)                                    as utm_content
            , String::ToLower(UTMMedium)                                     as utm_medium
            , case when String::Find(UTMCampaign, '.') > 0
                then $get_utm_campaign_id(UTMCampaign) else Null
            end                                                            as utm_campaign_id
            ,  case when String::Find(UTMCampaign, '.') > 0
                then $get_utm_campaign_name(UTMCampaign) else Null
            end                                                            as utm_campaign_name
            , coalesce(IsMobile, False)                                      as is_mobile_flg
            , UserAgent                                                      as user_agent_id
            , CASE WHEN Unicode::IsUtf(StartURL) THEN StartURL ELSE NULL END as start_url
            , StartURLDomain                                                 as start_url_domain_name
            , SearchEngineID                                                 as search_engine_id
            , EPurchase_ID                                                   as order_nr_list
            , CounterID                                                      as counter_id
            , Goals_OrderID                                                  as goals_order_id
            , Goals_EventTime                                                as goals_event_time
            , Goals_ID                                                       as goals_id
            , Goals_Serial                                                   as goals_serial
            ,TrafficSource_UTMCampaign                                       AS trafficsourse_utmcampain
            ,TrafficSource_UTMContent                                        AS trafficsourse_utmcontent
            ,TrafficSource_UTMMedium                                         AS trafficsourse_utmmedium
            ,TrafficSource_Model                                             AS trafficsourse_utmmodel
            ,TrafficSource_UTMSource                                         AS trafficsourse_utmsource
            ,TrafficSource_UTMTerm                                           AS trafficsourse_utmterm
            ,TrafficSource_ID                                                AS trafficsourse_id
            ,coalesce(IsRobot, FALSE)                                        AS is_robot
            ,Event_ID                                                        AS event_id
            ,coalesce(IsRobotInternal, FALSE)                                AS is_robot_internal
            ,coalesce(IsBounce, FALSE)                                       AS is_bounce
            ,EndURL                                                          AS end_url
            ,LinkURL                                                         AS link_url
            ,Referer                                                         AS referer
            ,SearchPhrase                                                    AS search_phrase
        from $table_from
        where
            CounterID = $CounterID
        window visit_versions as (
            partition by VisitID
            order by
            VisitVersion desc,
            Sign asc
    )
    );

    -- $all_informations = (
    --     select 
    --         counter_id -- CounterID
    --         , visit_version_index -- VisitVersion
    --         , visit_id -- VisitID
    --         , metrica_user_id -- UserID
    --         -- , Hits
    --         , is_mobile_flg --IsMobile
    --         , utc_first_visit_dttm
    --         , goals_event_time
    --         , goals_id -- Goals_ID
    --         , goals_serial -- Goals_Serial
    --         , utc_visit_start_dttm
    --         , yandex_uid --PassportUserID
    --         , utm_source --UTMSource
    --         , utm_term --UTMTerm
    --         , utm_campaign --UTMCampaign
    --         , utm_content --UTMContent
    --         , utm_medium --UTMMedium
    --         , start_url --StartURL
    --         , start_url_domain_name --StartURLDomain
    --         -- , VisitVersion
    --         -- , Sign
    --         , user_agent_id --UserAgent
    --         , order_nr_list --EPurchase_ID
    --         , goals_order_id --Goals_OrderID
    --         , search_engine_id --SearchEngineID
    --         , region_id --RegionID
    --         , deleted_flg
    --     from $visit_version
    --     );

    $result = (
        select order_nr_list AS order_nr, 
        t.* without visit_version_index, order_nr_list
        from $visit_version as t
        where visit_version_index = 1
    );
    INSERT INTO $table_to WITH TRUNCATE 
    select * 
    from $result;
END DO;