use hahn; 

$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/aggregated_information_from_log_platform';

-- $date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");
-- $date_format2 = DateTime::Format("%H:%M:%S");

$script = @@
def list_to_str(my_list):
    string = ''

    for i in my_list:
        string += (i.decode('utf-8') + ',\n ')

    return string.strip()
@@;

$list_to_str = Python::list_to_str(
    Callable<(List<String>?)->String?>,
    $script
);

$table = 
    (Select 
        corp_client_id
        , employer_code
        , some(request_id) as request_id
        , some(request_code) as request_code
        , some(external_order_id) as external_order_id
        , some(COALESCE(barcodes,[''])) as barcodes
        , some(COALESCE(articles,[''])) as articles
        , created_dttm
        , some(planned_delivery_dt) as planned_delivery_dt
        , some(planned_interval_time_max) as planned_interval_time_max
        , some(planned_interval_time_min) as planned_interval_time_min
        , some(operator_id) as operator_id
        , some(delivery_locality) as delivery_locality
        , some(delivery_address) as delivery_address
        , some(first_name || ' ' || last_name) as full_name
        , some(phone) as phone
        , count_if(mapped_event_type = 'Доставка перенесена' or mapped_event_type = 'Доставка перенесена по просьбе клиента' or mapped_event_type = 'Доставка перенесена службой доставки') as cnt_updates
        , some( if (mapped_event_type = 'На складе службы доставки', event_instant_ddtm, null)) as dt_sourse 
        , some( if (mapped_event_type = 'На складе службы доставки', event_instant_ddtm, null)) as dttm_sourse
        , max_by(mapped_event_type, history_event_id) as last_order_status
        , max_by(event_instant_ddtm, history_event_id) as time_of_last_order_status
        , max(event_instant_ddtm) as max_time
        , some(if (mapped_event_type = 'Доставлен', event_instant_ddtm, null)) as dttm_delivered
        , some(if (mapped_event_type = 'Посылка доставляется клиенту', event_instant_ddtm, null)) as dttm_is_being_delivered
        , some(payment_method) as payment_method
        , some(policy) as policy
    from $REQUEST_DATAMART
    group by corp_client_id
        , employer_code
        , created_dttm
    );
INSERT INTO $SAVE_TO WITH TRUNCATE 
select 
    corp_client_id
    , employer_code
    , request_id
    , request_code
    , external_order_id
    , $list_to_str(barcodes) as barcodes
    , $list_to_str(articles) as articles 
    , DateTime::Format("%Y-%m-%d")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(created_dttm)), 'Europe/Moscow')) as created_dt
    ,  DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(planned_interval_time_min)), 'Europe/Moscow')) as planned_interval_time_min
    , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(planned_interval_time_max)), 'Europe/Moscow')) as planned_interval_time_max
    , operator_id 
    , payment_method
    , delivery_locality as delivery_city
    , delivery_address
    , full_name
    , phone
    , cnt_updates
    , policy
    , DateTime::Format("%Y-%m-%d")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(dt_sourse)), 'Europe/Moscow')) as date_sourse
    ,  DateTime::Format("%H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(dttm_sourse)), 'Europe/Moscow')) as time_sourse
    , last_order_status
    ,  DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(time_of_last_order_status)), 'Europe/Moscow')) as time_of_last_order_status
    , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(dttm_delivered)), 'Europe/Moscow')) as dttm_delivered
    , DateTime::Format("%Y-%m-%d %H:%M:%S")(AddTimezone(DateTime::MakeDatetime(DateTime::ParseIso8601(dttm_is_being_delivered)), 'Europe/Moscow')) as dttm_is_being_delivered
from  $table
order by created_dt desc
;
