use hahn;
PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$today = DateTime::Format('%Y-%m-%d');
$day =  $today(CurrentUtcDate());


$name = '//home/taxi-delivery/analytics/production/ndd/magistral/market/' || $day;


insert into 
$name
with truncate
 SELECT
    FlightId as `ID рейса`,
    PlaceCount as `Place_Count`,
    null as `Place_Delivery_Range`,
    null as `Place_ExternalId`,
    AddressL as `Адрес выгрузки (последний)`,
    Address1 as `Адрес погрузки (1ый)`,
    PlaceDimensionsWeight as `Вес (общий)`,
    BookingDate as `Дата заказа (заявки)`,
    CreateDate as `Дата/время добавления заказа хаб`,
    MatchDate as `Дата/время мэтча`,
    CustomerName as `Заказчик`,
    SenderInn as `ИНН ЮР ЛИЦА`,
    GroupId as `Идентификатор объединения`,
    SrcId as `Идентификатор первоначального места`,
    SecondName as `Имя водителя`,
    CorporationTitle as `Корпорация`,
    PlaceName as `Название места/груза`, --!!!
    SenderName as `Название юр Лицо`,
    CarNumber as `Номер автомобиля`,
    PlaceDimensionsVolume as `Объем м3`,
    OperationId as `Операционный id`,
    MiddleName as `Отчество водителя`,
    PlaceDeliveryDate as `Планируемая Дата выгрузки`,
    PlaceShipmentDate as `Планируемая Дата погрузки`,
    UserName as `Пользователь (ФИО) логиста`,
    UserPhone as `Пользователь (телефон) логиста`,
    CarrierStatus as `Статус у перевозчика`,
    ExpeditorStatus as `Статус у экспедитора`,
    BodyType as `Тип кузова`,
    null as `Тип поездки`, ---!!!!
    FirstName as `Фамилия водителя`,
    cast(PlacePrice as Float) * cast(PlaceCount as Float) as `Цена клиентская`,
    PlacePrice as `Цена клиентская за место`,
    PlaceCount as `кол-во мест`
    FROM
        `//home/taxi-delivery/analytics/production/ndd/magistral/magistral_datamart`
    where ExpeditorStatus <> ''
        and CustomerName in  ('Яндекс', 'ЯНДЕКС')
