use chyt.hahn/taxi-delivery;

select 
count(1) as value
from 
(
select 
    (planned_interval_time_max - now()) / 60 as diff
    , argMax(last_status, history_event_id) as last_status
    , Max(history_timestamp) as  htm
from 
(
select 
    rh.request_id as request_id
    , rh.request_code as request_code
    , pth.external_order_id as external_order_id
    , YPathString(rh.unpacked_data, '/corp_client_id') as corp_client_id
    , rh.employer_code as employer_code
    , oeh.operator_id as operator_id
    --, toDateTime(oeh.history_timestamp) as tech_event_instant_ddtm
    , toDateTime(pnh.planned_interval_time_max) as planned_interval_time_max
    , (case when left(oeh.operator_event_type, 3) = '201' then 'Заказ создан'
            when left(oeh.operator_event_type, 3) = '222' then 'Ожидается в службе доставки'
            when left(oeh.operator_event_type, 3) = '224' then 'Заказ удален с выдачи на доставку'
            when left(oeh.operator_event_type, 3) = '221' then 'Доставляется по городу'
            when left(oeh.operator_event_type, 3) = '231' then 'Доставлен'
            when left(oeh.operator_event_type, 3) = '237' then 'Доставлен частично'
            when left(oeh.operator_event_type, 3) = '232' then 'Доставка перенесена'
            when left(oeh.operator_event_type, 3) = '236' then 'Доставка перенесена по просьбе клиента'
            when left(oeh.operator_event_type, 3) = '238' then 'Доставка отменена по просьбе клиента'
            when left(oeh.operator_event_type, 3) = '232' then 'Доставка перенесена'
            when left(oeh.operator_event_type, 3) = '235' then 'Доставка отменена (по просьбе магазина или клиента)'
            when left(oeh.operator_event_type, 3) = '410' then 'Заявка на доставку отклонена (до поступления товара на склад)'
            when left(oeh.operator_event_type, 3) = '301' then 'Доставлен - подтверждено'
            when left(oeh.operator_event_type, 3) = '302' then 'Доставлен частично - подтверждено'
            when left(oeh.operator_event_type, 3) = '305' then 'Отмена - подтверждено'
            when left(oeh.operator_event_type, 3) = '213' then 'Не поступил на склад'
            when left(oeh.operator_event_type, 3) = '214' then 'Ожидается в службе доставки'
            when left(oeh.operator_event_type, 3) = '212' then 'Заказ частично на складе'
            when left(oeh.operator_event_type, 3) = '211' then 'На складе службы доставки'
            when left(oeh.operator_event_type, 3) = '218' then 'Заказ подготовлен на магистраль'
            when left(oeh.operator_event_type, 3) = '219' then 'На магистрали'
            when left(oeh.operator_event_type, 3) = '311' then 'Готовится к возврату'
            when left(oeh.operator_event_type, 3) = '314' then 'Готов для передачи магазину'
            when left(oeh.operator_event_type, 3) = '312' then 'Возврат на пути к магазину'
            when left(oeh.operator_event_type, 3) = '313' then 'Возвращен в магазин'
            else oeh.operator_event_type
            end)
   as last_status
   , case when left(oeh.operator_event_type, 3) in ('232', '236')  then 1 else 0 end as reschedule_flg
   , oeh.history_timestamp as history_timestamp
   , oeh.history_event_id as history_event_id
   --, argMax(oeh.history_timestamp, oeh.history_event_id)  as htm

from 
(
    select 
        request_id
        , request_code
        , employer_code
        , unpacked_data
    from 
        concatYtTablesRange( "//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", toString(toDate(timestamp_sub(DAY, 5, now())))) 
    where 
        employer_code not in ('beru', 'Eva')
        and history_action = 'add'
 ) as rh
left join 
    (
        select 
            external_order_id
            , any(request_id) as request_id
        from 
            concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history", toString(toDate(timestamp_sub(DAY, 5, now()))))
        group by 
            external_order_id
    ) as pth
    on pth.request_id = rh.request_id
left join 
    (
        select 
            operator_id
            , cast(history_timestamp as Int64) as history_timestamp
            , operator_event_type
            , external_order_id
            , history_event_id
        from 
            concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history", toString(toDate(timestamp_sub(DAY, 5, now()))))
        where operator_event_type is not null
    ) as oeh 
    on oeh.external_order_id = pth.external_order_id
inner join 
    (
        select 
            request_id
            , YPathInt64(unpacked_data, '/requested_processing_interval/planned_interval_time/max') as planned_interval_time_max
        from 
            concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history", toString(toDate(timestamp_sub(DAY, 5, now()))))
        where 1=1
            and history_action = 'add'
            and YPathString(unpacked_data, '/node_code') in ('n_to', 'node_to')
            and toDate(planned_interval_time_max) = today()
    ) as pnh
    on pnh.request_id = rh.request_id
)
group by 
request_id
    , request_code
    , external_order_id
    , corp_client_id
    , employer_code
    , operator_id
    , planned_interval_time_max
 --as tabl
having
    1=1
    and ((external_order_id is not null and htm > 0)
        or external_order_id is null) 
    and last_status not in (
        'Доставлен', 
                                'Доставлен частично', 
                                'Доставлен - подтверждено', 
                                'Доставлен частино - подтверждено',
                                 'Отмена - подтверждено'
                                 , 'Доставка отменена (по просьбе магазина или клиента)'
                                 , 'Доставка отменена по просьбе клиента'
                                 , 'Заявка на доставку отклонена (до поступления товара на склад)'
                                 , 'Не поступил на склад')
    and diff between 0 and 30
)
